Description: fix failure to detect mpicc with gcc-14.
 Starting with gcc-14, when specifying mpicc, the configuration test
 considers it unusable:
 .
         checking for mpicc... /usr/bin/mpicc
         […]
         checking whether /usr/bin/mpicc works as MPI compiler... no
 .
 This turns out to be caused by a warning gone fatal in the conftest.c:
 .
         $ mpicc conftest.c 
         conftest.c: In function ‘main’:
         conftest.c:6:1: error: implicit declaration of function ‘exit’ [-Wimplicit-function-declaration]
             6 | exit(0);
               | ^~~~
         conftest.c:2:1: note: include ‘<stdlib.h>’ or provide a declaration of ‘exit’

Author: Étienne Mollier <emollier@debian.org>
Bug-Debian: https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=1075584
Forwarded: no
Last-Update: 2024-09-10
---
This patch header follows DEP-3: http://dep.debian.net/deps/dep3/
--- tree-puzzle.orig/configure.ac
+++ tree-puzzle/configure.ac
@@ -45,6 +45,7 @@
  if test  "$MPICCSET" = ""  ; then
 cat > conftest.c <<EOF
 #include<mpi.h>
+#include<stdlib.h>
 int main (int argc, char **argv)
 {
 MPI_Init(&argc,&argv);
