# FreeSWITCH

FreeSWITCH is a Software Defined Telecom Stack enabling the digital transformation from proprietary telecom switches to a versatile software implementation that runs on any commodity hardware. From a Raspberry PI to a multi-core server, FreeSWITCH can unlock the telecommunications potential of any device. Combined with our hosted cloud platform, SignalWire, FreeSWITCH can interconnect with the outside world and scale to any size.

Visit  [https://signalwire.com](https://signalwire.com/)  or https://github.com/signalwire for more info.

## Getting Started

FreeSWITCH is available on [Github](https://github.com/signalwire/freeswitch) in source code format.  You can checkout the development branch and build for many popular platforms including Linux, Windows, MacOSX and BSD.  There is an issue tracker and pull request system available as part of the repo online.

See https://developer.signalwire.com/freeswitch/FreeSWITCH-Explained/ for more detailed instructions.

## Additional Help

If you need assistance or have an interest in using a commercially supported build, you can contact coreteam@freeswitch.com to learn about professional services to support your project.

## Voice-over-IP services - SIP / SMS - App Integrations

[SignalWire](https://signalwire.com) is the primary sponsor of the FreeSWITCH project and was founded by the original developers of FreeSWITCH. SignalWire provides scalable services to enhance and scale your project such as SMS, SIP, Serverless Application hosting as well as programmable telecom. mod_signalwire which is distributed in this code base allows you to instantly pair with SignalWire and extend your FreeSWITCH.

## Documentation

The main index for documentation is available at:

  * https://freeswitch.org/confluence/


### Release notes:

  * https://freeswitch.org/confluence/display/FREESWITCH/Release+Notes

### Install from packages

Step by step tutorials to install FreeSWITCH from packages:

  * [Debian](https://freeswitch.org/confluence/display/FREESWITCH/Debian) [<b>Recommended</b>]
  * [Raspberry Pi](https://freeswitch.org/confluence/display/FREESWITCH/Raspberry+Pi)
  * [CentOS 7](https://freeswitch.org/confluence/display/FREESWITCH/CentOS+7+and+RHEL+7)

### Build from source

Example Dockerfiles to build FreeSWITCH and dependencies from source:
  * https://github.com/signalwire/freeswitch/tree/master/docker/examples

Step by step tutorials to build FreeSWITCH with provided dependency packages:
  * [Debian](https://freeswitch.org/confluence/display/FREESWITCH/Debian#Debian-buildfromsource) [<b>Recommended</b>]
  * [Raspberry Pi](https://freeswitch.org/confluence/display/FREESWITCH/Raspberry+Pi)
  * [CentOS 7](https://freeswitch.org/confluence/display/FREESWITCH/CentOS+7+and+RHEL+7)

## Downloads

  * [Tarballs](https://files.freeswitch.org/releases/freeswitch/)
  * [Windows Installer](http://files.freeswitch.org/windows/installer/x64/)
  * [Windows Sound Packages](http://files.freeswitch.org/windows/installer/x64/sounds/)

## Contributions

GitHub pull requests are the recommended way to contribute to the FreeSWITCH source code:

  * https://github.com/signalwire/freeswitch/pulls

## Community

Slack is our chat system where the developers, the FreeSWITCH team, and the most active users are present.
This is the place to get answers faster and chat with other users in real time. All you need to do is enter your email and verify it on the Slack signup page and you are ready to join in the discussion!

Slack Community:
  * https://signalwire.community/

Mailing list (ARCHIVED):

  * http://lists.freeswitch.org/pipermail/freeswitch-users/

**Thank you for using FreeSWITCH!**
