package NGCP::BulkProcessor::Dao::mr103::openser::voicemail_spool;
use strict;

## no critic

use threads::shared;

use Locale::Recode qw();

use NGCP::BulkProcessor::Logging qw(
    getlogger

);

use NGCP::BulkProcessor::ConnectorPool qw(
    get_kamailio_db
);

use NGCP::BulkProcessor::SqlProcessor qw(
    checktableinfo

    copy_row
);
use NGCP::BulkProcessor::SqlRecord qw();

require Exporter;
our @ISA = qw(Exporter NGCP::BulkProcessor::SqlRecord);
our @EXPORT_OK = qw(
    gettablename
    check_table

    source_findby_mailboxuser
    
);

my $tablename = 'voicemail_spool';
my $get_db = \&get_kamailio_db;

my $expected_fieldnames = [
  'id',
  'msgnum',
  'dir',
  'context',
  'macrocontext',
  'callerid',
  'origtime',
  'duration',
  'mailboxuser',
  'mailboxcontext',
  'recording',
];

my $indexes = {};

sub new {

    my $class = shift;
    my $self = NGCP::BulkProcessor::SqlRecord->new($class,$get_db,
                           $tablename,$expected_fieldnames,$indexes);

    copy_row($self,shift,$expected_fieldnames);

    return $self;

}

sub buildrecords_fromrows {

    my ($rows,$load_recursive) = @_;

    my @records = ();
    my $record;

    if (defined $rows and ref $rows eq 'ARRAY') {
        foreach my $row (@$rows) {
            $record = __PACKAGE__->new($row);

            # transformations go here ...

            push @records,$record;
        }
    }

    return \@records;

}

sub gettablename {

    return $tablename;

}

sub check_table {

    return checktableinfo(shift // $get_db,
                   __PACKAGE__,$tablename,
                   $expected_fieldnames,
                   $indexes);

}

sub source_new {

    my $class = shift;
    my $self = NGCP::BulkProcessor::SqlRecord->new_shared($class,shift,
                           $tablename,$expected_fieldnames,$indexes);

    copy_row($self,shift,$expected_fieldnames);

    return $self;

}

sub source_findby_mailboxuser {

    my ($source_dbs,$mailboxuser) = @_;

    my $source_db = $source_dbs->{openser_db};
    check_table($source_db);
    my $db = &$source_db();
    my $table = $db->tableidentifier($tablename);

    my $stmt = 'SELECT * FROM ' . $table . ' WHERE ' .
            $db->columnidentifier('mailboxuser') . ' = ?';
    my @params = ($mailboxuser);
    my $rows = $db->db_get_all_arrayref($stmt,@params);

    return source_buildrecords_fromrows($rows,$source_dbs);

}

sub source_buildrecords_fromrows {

    my ($rows,$source_dbs) = @_;

    my @records : shared = ();
    my $record;

    my $recoder = Locale::Recode->new( from => 'ISO-8859-1', to => 'UTF-8' );

    if (defined $rows and ref $rows eq 'ARRAY') {
        foreach my $row (@$rows) {
            $record = __PACKAGE__->source_new($source_dbs->{openser_db},$row);

            # transformations go here ...
            foreach my $field (keys %$record) {
                next if $field eq 'recording';
                $record->{$field} = $recoder->recode($record->{$field}) if $record->{field};
            }

            push @records,$record;
        }
    }

    return \@records;

}



1;
