package NGCP::Checks::TLSCerts 0.001;

use strict;
use warnings;

our @EXPORT = qw(
    is_tls_cert_expiring
);

use Exporter qw(import);
use Time::Piece;
use Time::Seconds;

=encoding utf8

=head1 NAME

NGCP::Checks::TLSCerts - Checks for TLS Certificate status

=head1 DESCRIPTION

This module provides support functions to check the status of the TLS
Certificates.

=head1 FUNCTIONS

=over 4

=item $bool = is_tls_cert_expiring($cert, $days_to_expiry)

Check whether the given TLS certificate is going to expire within the
specified days. If $days_to_expiry is omitted, it defaults to 30.

=cut

sub is_tls_cert_expiring {
    my ($cert, $days_to_expiry) = @_;

    my $secs_to_expiry = Time::Seconds->new(($days_to_expiry // 30) * ONE_DAY);

    return Time::Piece->new() + $secs_to_expiry > $cert->{expires_on};
}

=back

=head1 CHANGES

=head2 Version 0.xxx

This is a private module.

=head1 AUTHOR

Guillem Jover, C<< <gjover@sipwise.com> >>

=head1 BUGS

Please report any bugs to Sipwise GmbH.

=head1 LICENSE

Copyright (c) 2020-2022 Sipwise GmbH, Austria.

GPL-3+, Sipwise GmbH, Austria.

=cut

1;
