/*
 * JsSIP version 0.3.0
 * Copyright (c) 2012-2013 José Luis Millán - Versatica <http://www.versatica.com>
 * Homepage: http://jssip.net
 * License: http://jssip.net/license
 */


(function(e){var t=function(){"use strict";var e={};return Object.defineProperties(e,{version:{get:function(){return"0.3.0"}},name:{get:function(){return"JsSIP"}}}),e}();(function(e){var t,s,i=e.name+" | "+"EVENT EMITTER"+" | ";t=function(){},t.prototype={initEvents:function(e){var t=e.length;for(this.events={},this.onceNotFired=[],this.maxListeners=10,this.events.newListener=function(e){console.log(i+"new listener added to event "+e)};t--;)console.log(i+"adding event "+e[t]),this.events[e[t]]=[]},checkEvent:function(e){return this.events[e]?!0:(console.error(i+"no event named "+e),!1)},addListener:function(e,t){this.checkEvent(e)&&(this.events[e].length>=this.maxListeners&&console.warn(i+"max listeners exceeded for event "+e),this.events[e].push(t),this.events.newListener.call(null,e))},on:function(e,t){this.addListener(e,t)},once:function(e,t){this.events[e].unshift(t),this.onceNotFired.push(e)},removeListener:function(e,t){if(this.checkEvent(e))for(var s=this.events[e],i=0,r=s.length;r>i;)s[i]&&""+s[i]==""+t?s.splice(i,1):i++},removeAllListener:function(e){this.checkEvent(e)&&(this.events[e]=[])},setMaxListeners:function(e){Number(e)&&(this.maxListeners=e)},listeners:function(e){return this.events[e]},emit:function(t,s,r){var n,o,a=0;if(this.checkEvent(t)){console.log(i+"emitting event "+t),n=this.events[t],o=n.length;var c=new e.Event(t,s,r);if(c)for(a;o>a;a++)n[a].apply(null,[c]);else for(a;o>a;a++)n[a].call();a=this.onceNotFired.indexOf(t),-1!==a&&(this.onceNotFired.splice(a,1),this.events[t].shift())}},newListener:function(e){this.events.newListener=e}},s=function(e,t,s){this.type=e,this.sender=t,this.data=s},e.EventEmitter=t,e.Event=s})(t),t.C={USER_AGENT:t.name+" "+t.version,SIP:"sip",INVALID_TARGET_URI:"sip:invalid@invalid",causes:{CONNECTION_ERROR:"Connection Error",REQUEST_TIMEOUT:"Request Timeout",SIP_FAILURE_CODE:"SIP Failure Code",INVALID_TARGET:"Invalid Target",INTERNAL_ERROR:"Internal Error",BUSY:"Busy",REJECTED:"Rejected",REDIRECTED:"Redirected",UNAVAILABLE:"Unavailable",NOT_FOUND:"Not Found",ADDRESS_INCOMPLETE:"Address Incomplete",INCOMPATIBLE_SDP:"Incompatible SDP",AUTHENTICATION_ERROR:"Authentication Error",DIALOG_ERROR:"Dialog Error",WEBRTC_NOT_SUPPORTED:"WebRTC Not Supported",WEBRTC_ERROR:"WebRTC Error",CANCELED:"Canceled",NO_ANSWER:"No Answer",EXPIRES:"Expires",NO_ACK:"No ACK",USER_DENIED_MEDIA_ACCESS:"User Denied Media Access",BAD_MEDIA_DESCRIPTION:"Bad Media Description",RTP_TIMEOUT:"RTP Timeout"},SIP_ERROR_CAUSES:{REDIRECTED:[300,301,302,305,380],BUSY:[486,600],REJECTED:[403,603],NOT_FOUND:[404,604],UNAVAILABLE:[480,410,408,430],ADDRESS_INCOMPLETE:[484],INCOMPATIBLE_SDP:[488,606],AUTHENTICATION_ERROR:[401,407]},ACK:"ACK",BYE:"BYE",CANCEL:"CANCEL",INFO:"INFO",INVITE:"INVITE",MESSAGE:"MESSAGE",NOTIFY:"NOTIFY",OPTIONS:"OPTIONS",REGISTER:"REGISTER",UPDATE:"UPDATE",SUBSCRIBE:"SUBSCRIBE",REASON_PHRASE:{100:"Trying",180:"Ringing",181:"Call Is Being Forwarded",182:"Queued",183:"Session Progress",199:"Early Dialog Terminated",200:"OK",202:"Accepted",204:"No Notification",300:"Multiple Choices",301:"Moved Permanently",302:"Moved Temporarily",305:"Use Proxy",380:"Alternative Service",400:"Bad Request",401:"Unauthorized",402:"Payment Required",403:"Forbidden",404:"Not Found",405:"Method Not Allowed",406:"Not Acceptable",407:"Proxy Authentication Required",408:"Request Timeout",410:"Gone",412:"Conditional Request Failed",413:"Request Entity Too Large",414:"Request-URI Too Long",415:"Unsupported Media Type",416:"Unsupported URI Scheme",417:"Unknown Resource-Priority",420:"Bad Extension",421:"Extension Required",422:"Session Interval Too Small",423:"Interval Too Brief",428:"Use Identity Header",429:"Provide Referrer Identity",430:"Flow Failed",433:"Anonymity Disallowed",436:"Bad Identity-Info",437:"Unsupported Certificate",438:"Invalid Identity Header",439:"First Hop Lacks Outbound Support",440:"Max-Breadth Exceeded",469:"Bad Info Package",470:"Consent Needed",478:"Unresolvable Destination",480:"Temporarily Unavailable",481:"Call/Transaction Does Not Exist",482:"Loop Detected",483:"Too Many Hops",484:"Address Incomplete",485:"Ambiguous",486:"Busy Here",487:"Request Terminated",488:"Not Acceptable Here",489:"Bad Event",491:"Request Pending",493:"Undecipherable",494:"Security Agreement Required",500:"Server Internal Error",501:"Not Implemented",502:"Bad Gateway",503:"Service Unavailable",504:"Server Time-out",505:"Version Not Supported",513:"Message Too Large",580:"Precondition Failure",600:"Busy Everywhere",603:"Decline",604:"Does Not Exist Anywhere",606:"Not Acceptable"}},function(t){var s;s={ConfigurationError:function(){var t=function(t,s){this.code=1,this.name="CONFIGURATION_ERROR",this.parameter=t,this.value=s,this.message=this.value?"Invalid value "+e.JSON.stringify(this.value)+' for parameter "'+this.parameter+'"':"Missing parameter: "+this.parameter};return t.prototype=Error(),t}(),InvalidTargetError:function(){var e=function(e){this.code=2,this.name="INVALID_TARGET_ERROR",this.target=e,this.message="Invalid target: "+this.target};return e.prototype=Error(),e}(),InvalidStateError:function(){var e=function(e){this.code=3,this.name="INVALID_STATE_ERROR",this.status=e};return e.prototype=Error(),e}()},t.Exceptions=s}(t),function(e){var t,s=500,i=4e3,r=5e3;t={T1:s,T2:i,T4:r,TIMER_B:64*s,TIMER_D:0*s,TIMER_F:64*s,TIMER_H:64*s,TIMER_I:0*s,TIMER_J:0*s,TIMER_K:0*r,TIMER_L:64*s,TIMER_M:64*s},e.Timers=t}(t),function(t){var s,i=t.name+" | "+"TRANSPORT"+" | ",r={STATUS_READY:0,STATUS_DISCONNECTED:1,STATUS_ERROR:2};s=function(e,t){this.ua=e,this.ws=null,this.server=t,this.reconnection_attempts=0,this.closed=!1,this.connected=!1,this.reconnectTimer=null,this.lastTransportError={},this.ua.transport=this,this.connect()},s.prototype={send:function(e){var t=""+e;return this.ws&&this.ws.readyState===WebSocket.OPEN?(this.ua.configuration.trace_sip===!0&&console.log(i+"sending WebSocket message:\n\n"+t+"\n"),this.ws.send(t),!0):(console.warn(i+"unable to send message, WebSocket is not open"),!1)},disconnect:function(){this.ws&&(this.closed=!0,console.log(i+"closing WebSocket "+this.server.ws_uri),this.ws.close())},connect:function(){var e=this;if(this.ws&&(this.ws.readyState===WebSocket.OPEN||this.ws.readyState===WebSocket.CONNECTING))return console.log(i+"WebSocket "+this.server.ws_uri+" is already connected"),!1;this.ws&&this.ws.close(),console.log(i+"connecting to WebSocket "+this.server.ws_uri);try{this.ws=new WebSocket(this.server.ws_uri,"sip")}catch(t){console.warn(i+"error connecting to WebSocket "+this.server.ws_uri+": "+t)}this.ws.binaryType="arraybuffer",this.ws.onopen=function(){e.onOpen()},this.ws.onclose=function(t){e.onClose(t)},this.ws.onmessage=function(t){e.onMessage(t)},this.ws.onerror=function(t){e.onError(t)}},onOpen:function(){this.connected=!0,console.log(i+"WebSocket "+this.server.ws_uri+" connected"),e.clearTimeout(this.reconnectTimer),this.closed=!1,this.ua.onTransportConnected(this)},onClose:function(e){var t=this.connected;this.connected=!1,this.lastTransportError.code=e.code,this.lastTransportError.reason=e.reason,console.warn(i+"WebSocket disconnected (code: "+e.code+(e.reason?"| reason: "+e.reason:"")+")"),e.wasClean===!1&&console.warn(i+"WebSocket abrupt disconnection"),t===!0?(this.ua.onTransportClosed(this),this.closed?this.ua.emit("disconnected",this.ua,{transport:this,code:this.lastTransportError.code,reason:this.lastTransportError.reason}):(this.reconnection_attempts=0,this.reConnect())):this.ua.onTransportError(this)},onMessage:function(e){var s,r,n=e.data;if("\r\n"===n)return this.ua.configuration.trace_sip===!0&&console.log(i+"received WebSocket message with CRLF Keep Alive response"),void 0;if("string"!=typeof n){try{n=String.fromCharCode.apply(null,new Uint8Array(n))}catch(o){return console.warn(i+"received WebSocket binary message failed to be converted into string, message discarded"),void 0}this.ua.configuration.trace_sip===!0&&console.log(i+"received WebSocket binary message:\n\n"+n+"\n")}else this.ua.configuration.trace_sip===!0&&console.log(i+"received WebSocket text message:\n\n"+n+"\n");if(s=t.Parser.parseMessage(n),!(this.ua.status===t.UA.C.STATUS_USER_CLOSED&&s instanceof t.IncomingRequest)&&s&&t.sanityCheck(s,this.ua,this))if(s instanceof t.IncomingRequest)s.transport=this,this.ua.receiveRequest(s);else if(s instanceof t.IncomingResponse)switch(s.method){case t.C.INVITE:r=this.ua.transactions.ict[s.via_branch],r&&r.receiveResponse(s);break;case t.C.ACK:break;default:r=this.ua.transactions.nict[s.via_branch],r&&r.receiveResponse(s)}},onError:function(e){console.warn(i+"WebSocket connection error: "+e)},reConnect:function(){var t=this;this.reconnection_attempts+=1,this.reconnection_attempts>this.ua.configuration.ws_server_max_reconnection?(console.warn(i+"maximum reconnection attempts for WebSocket "+this.server.ws_uri),this.ua.onTransportError(this)):(console.log(i+"trying to reconnect to WebSocket "+this.server.ws_uri+" (reconnection attempt "+this.reconnection_attempts+")"),this.reconnectTimer=e.setTimeout(function(){t.connect()},1e3*this.ua.configuration.ws_server_reconnection_timeout))}},s.C=r,t.Transport=s}(t),function(e){function t(e,t){var s=t,i=0,r=0;if(e.substring(s,s+2).match(/(^\r\n)/))return-2;for(;0===i;){if(r=e.indexOf("\r\n",s),-1===r)return r;!e.substring(r+2,r+4).match(/(^\r\n)/)&&e.charAt(r+2).match(/(^\s+)/)?s=r+2:i=r}return i}function s(t,s,i,r){var n,o,a,c=s.indexOf(":",i),u=s.substring(i,c).trim(),h=s.substring(c+1,r).trim();switch(u.toLowerCase()){case"via":case"v":t.addHeader("via",h),1===t.countHeader("via")?(a=t.parseHeader("Via"),a&&(t.via=a,t.via_branch=a.branch)):a=0;break;case"from":case"f":t.setHeader("from",h),a=t.parseHeader("from"),a&&(t.from=a,t.from_tag=a.getParam("tag"));break;case"to":case"t":t.setHeader("to",h),a=t.parseHeader("to"),a&&(t.to=a,t.to_tag=a.getParam("tag"));break;case"record-route":a=e.Grammar.parse(h,"Record_Route"),-1===a&&(a=void 0);for(o in a)n=a[o],t.addHeader("record-route",h.substring(n.possition,n.offset)),t.headers["Record-Route"][t.countHeader("record-route")-1].parsed=n.parsed;break;case"call-id":case"i":t.setHeader("call-id",h),a=t.parseHeader("call-id"),a&&(t.call_id=h);break;case"contact":case"m":a=e.Grammar.parse(h,"Contact"),-1===a&&(a=void 0);for(o in a)n=a[o],t.addHeader("contact",h.substring(n.possition,n.offset)),t.headers.Contact[t.countHeader("contact")-1].parsed=n.parsed;break;case"content-length":case"l":t.setHeader("content-length",h),a=t.parseHeader("content-length");break;case"content-type":case"c":t.setHeader("content-type",h),a=t.parseHeader("content-type");break;case"cseq":t.setHeader("cseq",h),a=t.parseHeader("cseq"),a&&(t.cseq=a.value),t instanceof e.IncomingResponse&&(t.method=a.method);break;case"max-forwards":t.setHeader("max-forwards",h),a=t.parseHeader("max-forwards");break;case"www-authenticate":t.setHeader("www-authenticate",h),a=t.parseHeader("www-authenticate");break;case"proxy-authenticate":t.setHeader("proxy-authenticate",h),a=t.parseHeader("proxy-authenticate");break;default:t.setHeader(u,h),a=0}return void 0===a?!1:!0}var i,r=e.name+" | "+"PARSER"+" | ";i={},i.parseMessage=function(i){var n,o,a,c,u,h=0,l=i.indexOf("\r\n");if(-1===l)return console.warn(r+"no CRLF found, not a SIP message, discarded"),void 0;if(o=i.substring(0,l),u=e.Grammar.parse(o,"Request_Response"),-1===u)return console.warn(r+'error parsing first line of SIP message: "'+o+'"'),void 0;for(u.status_code?(n=new e.IncomingResponse,n.status_code=u.status_code,n.reason_phrase=u.reason_phrase):(n=new e.IncomingRequest,n.method=u.method,n.ruri=u.uri),n.data=i,h=l+2;;){if(l=t(i,h),-2===l){c=h+2;break}if(-1===l)return;if(u=s(n,i,h,l),!u)return;h=l+2}return n.hasHeader("content-length")?(a=n.getHeader("content-length"),n.body=i.substr(c,a)):n.body=i.substring(c),n},e.Parser=i}(t),function(e){var t,s,i,r,n=e.name+" | "+"SIP MESSAGE"+" | ";t=function(t,s,i,r,n,o){var a,c,u,h;return r=r||{},t&&s&&i?(this.headers={},this.method=t,this.ruri=s,this.body=o,this.extraHeaders=n||[],r.route_set?this.setHeader("route",r.route_set):i.configuration.use_preloaded_route&&this.setHeader("route",i.transport.server.sip_uri),this.setHeader("via",""),this.setHeader("max-forwards",e.UA.C.MAX_FORWARDS),a=r.to_display_name||0===r.to_display_name?'"'+r.to_display_name+'" ':"",a+="<"+(r.to_uri||s)+">",a+=r.to_tag?";tag="+r.to_tag:"",this.to=new e.NameAddrHeader.parse(a),this.setHeader("to",a),c=r.from_display_name||0===r.from_display_name?'"'+r.from_display_name+'" ':i.configuration.display_name?'"'+i.configuration.display_name+'" ':"",c+="<"+(r.from_uri||i.configuration.uri)+">;tag=",c+=r.from_tag||e.Utils.newTag(),this.from=new e.NameAddrHeader.parse(c),this.setHeader("from",c),u=r.call_id||i.configuration.jssip_id+e.Utils.createRandomToken(15),this.call_id=u,this.setHeader("call-id",u),h=r.cseq||Math.floor(1e4*Math.random()),this.cseq=h,this.setHeader("cseq",h+" "+t),void 0):null},t.prototype={setHeader:function(t,s){this.headers[e.Utils.headerize(t)]=s instanceof Array?s:[s]},toString:function(){var t,s,i,r="";r+=this.method+" "+this.ruri+" SIP/2.0\r\n";for(t in this.headers)for(i in this.headers[t])r+=t+": "+this.headers[t][i]+"\r\n";for(s=this.extraHeaders.length,i=0;s>i;i++)r+=this.extraHeaders[i]+"\r\n";return r+="Supported: "+e.UA.C.SUPPORTED+"\r\n",r+="User-Agent: "+e.C.USER_AGENT+"\r\n",this.body?(s=e.Utils.str_utf8_length(this.body),r+="Content-Length: "+s+"\r\n\r\n",r+=this.body):r+="Content-Length: 0\r\n\r\n",r}},s=function(){this.data=null,this.headers=null,this.method=null,this.via=null,this.via_branch=null,this.call_id=null,this.cseq=null,this.from=null,this.from_tag=null,this.to=null,this.to_tag=null,this.body=null},s.prototype={addHeader:function(t,s){var i={raw:s};t=e.Utils.headerize(t),this.headers[t]?this.headers[t].push(i):this.headers[t]=[i]},countHeader:function(t){var s=this.headers[e.Utils.headerize(t)];return s?s.length:0},getHeader:function(t,s){var i=this.headers[e.Utils.headerize(t)];return s=s||0,i?i[s]?i[s].raw:void 0:void 0},getHeaderAll:function(t){var s,i=this.headers[e.Utils.headerize(t)],r=[];if(!i)return[];for(s in i)r.push(i[s].raw);return r},hasHeader:function(t){return this.headers[e.Utils.headerize(t)]?!0:!1},parseHeader:function(t,s){var i,r,o;return t=e.Utils.headerize(t),s=s||0,this.headers[t]?s>=this.headers[t].length?(console.log(n+'not so many "'+t+'" headers present'),void 0):(i=this.headers[t][s],r=i.raw,i.parsed?i.parsed:(o=e.Grammar.parse(r,t.replace(/-/g,"_")),-1===o?(this.headers[t].splice(s,1),console.warn(n+'error parsing "'+t+'" header field with value "'+r+'"'),void 0):(i.parsed=o,o))):(console.log(n+'header "'+t+'" not present'),void 0)},s:function(e,t){return this.parseHeader(e,t)},setHeader:function(t,s){var i={raw:s};this.headers[e.Utils.headerize(t)]=[i]},toString:function(){return this.data}},i=function(){this.headers={},this.ruri=null,this.transport=null,this.server_transaction=null},i.prototype=new s,i.prototype.reply=function(t,s,i,r,n,o){var a,c,u,h,l,d=this.getHeader("To"),p=0,T=0;if(t=t||null,s=s||null,!t||100>t||t>699)throw new TypeError("Invalid status_code: "+t);if(s&&"string"!=typeof s&&!(s instanceof String))throw new TypeError("Invalid reason_phrase: "+s);if(s=s||e.C.REASON_PHRASE[t]||"",i=i||[],l="SIP/2.0 "+t+" "+s+"\r\n",this.method===e.C.INVITE&&t>100&&200>=t)for(a=this.countHeader("record-route"),p;a>p;p++)l+="Record-Route: "+this.getHeader("record-route",p)+"\r\n";for(c=this.countHeader("via"),T;c>T;T++)l+="Via: "+this.getHeader("via",T)+"\r\n";for(this.to_tag?this.to_tag&&!this.s("to").hasParam("tag")&&(d+=";tag="+this.to_tag):d+=";tag="+e.Utils.newTag(),l+="To: "+d+"\r\n",l+="From: "+this.getHeader("From")+"\r\n",l+="Call-ID: "+this.call_id+"\r\n",l+="CSeq: "+this.cseq+" "+this.method+"\r\n",u=i.length,h=0;u>h;h++)l+=i[h]+"\r\n";r?(u=e.Utils.str_utf8_length(r),l+="Content-Type: application/sdp\r\n",l+="Content-Length: "+u+"\r\n\r\n",l+=r):l+="Content-Length: 0\r\n\r\n",this.server_transaction.receiveResponse(t,l,n,o)},i.prototype.reply_sl=function(t,s){var i,r,n=this.countHeader("via");if(t=t||null,s=s||null,!t||100>t||t>699)throw new TypeError("Invalid status_code: "+t);if(s&&"string"!=typeof s&&!(s instanceof String))throw new TypeError("Invalid reason_phrase: "+s);s=s||e.C.REASON_PHRASE[t]||"",r="SIP/2.0 "+t+" "+s+"\r\n";for(var o=0;n>o;o++)r+="Via: "+this.getHeader("via",o)+"\r\n";i=this.getHeader("To"),this.to_tag?this.to_tag&&!this.s("to").hasParam("tag")&&(i+=";tag="+this.to_tag):i+=";tag="+e.Utils.newTag(),r+="To: "+i+"\r\n",r+="From: "+this.getHeader("From")+"\r\n",r+="Call-ID: "+this.call_id+"\r\n",r+="CSeq: "+this.cseq+" "+this.method+"\r\n",r+="Content-Length: 0\r\n\r\n",this.transport.send(r)},r=function(){this.headers={},this.status_code=null,this.reason_phrase=null},r.prototype=new s,e.OutgoingRequest=t,e.IncomingRequest=i,e.IncomingResponse=r}(t),function(t){var s;s=function(e,s,i,r,n,o){var a,c;if(!i)throw new TypeError('missing or invalid "host" parameter');e=e||t.C.SIP,this.parameters={},this.headers={};for(a in n)this.setParam(a,n[a]);for(c in o)this.setHeader(c,o[c]);Object.defineProperties(this,{scheme:{get:function(){return e},set:function(t){e=t.toLowerCase()}},user:{get:function(){return s},set:function(e){s=e}},host:{get:function(){return i},set:function(e){i=e.toLowerCase()}},port:{get:function(){return r},set:function(e){r=0===e?e:parseInt(e,10)||null}}})},s.prototype={setParam:function(e,t){e&&(this.parameters[e.toLowerCase()]=t===void 0||null===t?null:(""+t).toLowerCase())},getParam:function(e){return e?this.parameters[e.toLowerCase()]:void 0},hasParam:function(e){return e?this.parameters.hasOwnProperty(e.toLowerCase())&&!0||!1:void 0},deleteParam:function(e){var t;return e=e.toLowerCase(),this.parameters.hasOwnProperty(e)?(t=this.parameters[e],delete this.parameters[e],t):void 0},clearParams:function(){this.parameters={}},setHeader:function(e,s){this.headers[t.Utils.headerize(e)]=s instanceof Array?s:[s]},getHeader:function(e){return e?this.headers[t.Utils.headerize(e)]:void 0},hasHeader:function(e){return e?this.headers.hasOwnProperty(t.Utils.headerize(e))&&!0||!1:void 0},deleteHeader:function(e){var s;return e=t.Utils.headerize(e),this.headers.hasOwnProperty(e)?(s=this.headers[e],delete this.headers[e],s):void 0},clearHeaders:function(){this.headers={}},clone:function(){return new s(this.scheme,this.user,this.host,this.port,e.JSON.parse(e.JSON.stringify(this.parameters)),e.JSON.parse(e.JSON.stringify(this.headers)))},toString:function(){var e,s,i,r,n=[];r=this.scheme+":",this.user&&(r+=t.Utils.escapeUser(this.user)+"@"),r+=this.host,(this.port||0===this.port)&&(r+=":"+this.port);for(s in this.parameters)r+=";"+s,null!==this.parameters[s]&&(r+="="+this.parameters[s]);for(e in this.headers)for(i in this.headers[e])n.push(e+"="+this.headers[e][i]);return n.length>0&&(r+="?"+n.join("&")),r},toAor:function(e){var s;return s=this.scheme+":",this.user&&(s+=t.Utils.escapeUser(this.user)+"@"),s+=this.host,e&&(this.port||0===this.port)&&(s+=":"+this.port),s}},s.parse=function(e){return e=t.Grammar.parse(e,"SIP_URI"),-1!==e?e:void 0},t.URI=s}(t),function(t){var s;s=function(e,s,i){var r;if(!(e&&e instanceof t.URI))throw new TypeError('missing or invalid "uri" parameter');this.uri=e,this.parameters={};for(r in i)this.setParam(r,i[r]);Object.defineProperties(this,{display_name:{get:function(){return s},set:function(e){s=0===e?"0":e}}})},s.prototype={setParam:function(e,t){e&&(this.parameters[e.toLowerCase()]=t===void 0||null===t?null:""+t)},getParam:function(e){return e?this.parameters[e.toLowerCase()]:void 0},hasParam:function(e){return e?this.parameters.hasOwnProperty(e.toLowerCase())&&!0||!1:void 0},deleteParam:function(e){var t;return e=e.toLowerCase(),this.parameters.hasOwnProperty(e)?(t=this.parameters[e],delete this.parameters[e],t):void 0},clearParams:function(){this.parameters={}},clone:function(){return new s(this.uri.clone(),this.display_name,e.JSON.parse(e.JSON.stringify(this.parameters)))},toString:function(){var e,t;e=this.display_name||0===this.display_name?'"'+this.display_name+'" ':"",e+="<"+(""+this.uri)+">";for(t in this.parameters)e+=";"+t,null!==this.parameters[t]&&(e+="="+this.parameters[t]);return e}},s.parse=function(e){return e=t.Grammar.parse(e,"Name_Addr_Header"),-1!==e?e:void 0},t.NameAddrHeader=s}(t),function(t){var s,i=t.name+" | "+"TRANSACTION"+" | ",r={STATUS_TRYING:1,STATUS_PROCEEDING:2,STATUS_CALLING:3,STATUS_ACCEPTED:4,STATUS_COMPLETED:5,STATUS_TERMINATED:6,STATUS_CONFIRMED:7};s={};var n=function(){this.init=function(e,t,s){var i;this.transport=s,this.id="z9hG4bK"+Math.floor(1e7*Math.random()),this.request_sender=e,this.request=t,i="SIP/2.0/"+(e.ua.configuration.hack_via_tcp?"TCP":s.server.scheme),i+=" "+e.ua.configuration.via_host+";branch="+this.id,this.request.setHeader("via",i)}},o=function(){this.send=function(){var s=this;this.state=r.STATUS_TRYING,this.F=e.setTimeout(function(){s.timer_F()},t.Timers.TIMER_F),this.transport.send(this.request)||this.onTransportError()},this.onTransportError=function(){console.log(i+"transport error occurred, deleting non-INVITE client transaction "+this.id),e.clearTimeout(this.F),e.clearTimeout(this.K),delete this.request_sender.ua.transactions.nict[this.id],this.request_sender.onTransportError()},this.timer_F=function(){console.log(i+"Timer F expired for non-INVITE client transaction "+this.id),this.state=r.STATUS_TERMINATED,this.request_sender.onRequestTimeout(),delete this.request_sender.ua.transactions.nict[this.id]},this.timer_K=function(){this.state=r.STATUS_TERMINATED,delete this.request_sender.ua.transactions.nict[this.id]},this.receiveResponse=function(s){var i=this,n=s.status_code;if(200>n)switch(this.state){case r.STATUS_TRYING:case r.STATUS_PROCEEDING:this.state=r.STATUS_PROCEEDING,this.request_sender.receiveResponse(s)}else switch(this.state){case r.STATUS_TRYING:case r.STATUS_PROCEEDING:this.state=r.STATUS_COMPLETED,e.clearTimeout(this.F),408===n?this.request_sender.onRequestTimeout():this.request_sender.receiveResponse(s),this.K=e.setTimeout(function(){i.timer_K()},t.Timers.TIMER_K);break;case r.STATUS_COMPLETED:}}};o.prototype=new n;var a=function(){this.send=function(){var s=this;this.state=r.STATUS_CALLING,this.B=e.setTimeout(function(){s.timer_B()},t.Timers.TIMER_B),this.transport.send(this.request)||this.onTransportError()},this.onTransportError=function(){console.log(i+"transport error occurred, deleting INVITE client transaction "+this.id),e.clearTimeout(this.B),e.clearTimeout(this.D),e.clearTimeout(this.M),delete this.request_sender.ua.transactions.ict[this.id],this.request_sender.onTransportError()},this.timer_M=function(){console.log(i+"Timer M expired for INVITE client transaction "+this.id),this.state===r.STATUS_ACCEPTED&&(this.state=r.STATUS_TERMINATED,e.clearTimeout(this.B),delete this.request_sender.ua.transactions.ict[this.id])},this.timer_B=function(){console.log(i+"Timer B expired for INVITE client transaction "+this.id),this.state===r.STATUS_CALLING&&(this.state=r.STATUS_TERMINATED,this.request_sender.onRequestTimeout(),delete this.request_sender.ua.transactions.ict[this.id])},this.timer_D=function(){console.log(i+"Timer D expired for INVITE client transaction "+this.id),this.state=r.STATUS_TERMINATED,e.clearTimeout(this.B),delete this.request_sender.ua.transactions.ict[this.id]},this.sendACK=function(s){var i=this;this.ack="ACK "+this.request.ruri+" SIP/2.0\r\n",this.ack+="Via: "+(""+this.request.headers.Via)+"\r\n",this.request.headers.Route&&(this.ack+="Route: "+(""+this.request.headers.Route)+"\r\n"),this.ack+="To: "+s.getHeader("to")+"\r\n",this.ack+="From: "+(""+this.request.headers.From)+"\r\n",this.ack+="Call-ID: "+(""+this.request.headers["Call-ID"])+"\r\n",this.ack+="CSeq: "+(""+this.request.headers.CSeq).split(" ")[0],this.ack+=" ACK\r\n\r\n",this.D=e.setTimeout(function(){i.timer_D()},t.Timers.TIMER_D),this.transport.send(this.ack)},this.cancel_request=function(e,s){var i=e.request;this.cancel=t.C.CANCEL+" "+i.ruri+" SIP/2.0\r\n",this.cancel+="Via: "+(""+i.headers.Via)+"\r\n",this.request.headers.Route&&(this.cancel+="Route: "+(""+i.headers.Route)+"\r\n"),this.cancel+="To: "+(""+i.headers.To)+"\r\n",this.cancel+="From: "+(""+i.headers.From)+"\r\n",this.cancel+="Call-ID: "+(""+i.headers["Call-ID"])+"\r\n",this.cancel+="CSeq: "+(""+i.headers.CSeq).split(" ")[0]+" CANCEL\r\n",s&&(this.cancel+="Reason: "+s+"\r\n"),this.cancel+="Content-Length: 0\r\n\r\n",this.state===r.STATUS_PROCEEDING&&this.transport.send(this.cancel)},this.receiveResponse=function(s){var i=this,n=s.status_code;if(n>=100&&199>=n)switch(this.state){case r.STATUS_CALLING:this.state=r.STATUS_PROCEEDING,this.request_sender.receiveResponse(s),this.cancel&&this.transport.send(this.cancel);break;case r.STATUS_PROCEEDING:this.request_sender.receiveResponse(s)}else if(n>=200&&299>=n)switch(this.state){case r.STATUS_CALLING:case r.STATUS_PROCEEDING:this.state=r.STATUS_ACCEPTED,this.M=e.setTimeout(function(){i.timer_M()},t.Timers.TIMER_M),this.request_sender.receiveResponse(s);break;case r.STATUS_ACCEPTED:this.request_sender.receiveResponse(s)}else if(n>=300&&699>=n)switch(this.state){case r.STATUS_CALLING:case r.STATUS_PROCEEDING:this.state=r.STATUS_COMPLETED,this.sendACK(s),this.request_sender.receiveResponse(s);break;case r.STATUS_COMPLETED:this.sendACK(s)}}};a.prototype=new n;var c=function(){this.init=function(e,t){this.id=e.via_branch,this.request=e,this.transport=e.transport,this.ua=t,this.last_response="",e.server_transaction=this}},u=function(){this.timer_J=function(){console.log(i+"Timer J expired for non-INVITE server transaction "+this.id),this.state=r.STATUS_TERMINATED,delete this.ua.transactions.nist[this.id]},this.onTransportError=function(){this.transportError||(this.transportError=!0,console.log(i+"transport error occurred, deleting non-INVITE server transaction "+this.id),e.clearTimeout(this.J),delete this.ua.transactions.nist[this.id])},this.receiveResponse=function(s,i,n,o){var a=this;if(100===s)switch(this.state){case r.STATUS_TRYING:this.state=r.STATUS_PROCEEDING,this.transport.send(i)||this.onTransportError();break;case r.STATUS_PROCEEDING:this.last_response=i,this.transport.send(i)?n&&n():(this.onTransportError(),o&&o())}else if(s>=200&&699>=s)switch(this.state){case r.STATUS_TRYING:case r.STATUS_PROCEEDING:this.state=r.STATUS_COMPLETED,this.last_response=i,this.J=e.setTimeout(function(){a.timer_J()},t.Timers.TIMER_J),this.transport.send(i)?n&&n():(this.onTransportError(),o&&o());break;case r.STATUS_COMPLETED:}}};u.prototype=new c;var h=function(){this.timer_H=function(){console.log(i+"Timer H expired for INVITE server transaction "+this.id),this.state===r.STATUS_COMPLETED&&(console.warn(i+"transactions","ACK for INVITE server transaction was never received, call will be terminated"),this.state=r.STATUS_TERMINATED),delete this.ua.transactions.ist[this.id]},this.timer_I=function(){this.state=r.STATUS_TERMINATED,delete this.ua.transactions.ist[this.id]},this.timer_L=function(){console.log(i+"Timer L expired for INVITE server transaction "+this.id),this.state===r.STATUS_ACCEPTED&&(this.state=r.STATUS_TERMINATED,delete this.ua.transactions.ist[this.id])},this.onTransportError=function(){this.transportError||(this.transportError=!0,console.log(i+"transport error occurred, deleting INVITE server transaction "+this.id),e.clearTimeout(this.reliableProvisionalTimer),e.clearTimeout(this.L),e.clearTimeout(this.H),e.clearTimeout(this.I),delete this.ua.transactions.ist[this.id])},this.timer_reliableProvisional=function(s){var i=this,r=this.last_response,n=t.Timers.T1*Math.pow(2,s+1);s>8?e.clearTimeout(this.reliableProvisionalTimer):(s+=1,this.transport.send(r)||this.onTransportError(),this.reliableProvisionalTimer=e.setTimeout(function(){i.timer_reliableProvisional(s)},n))},this.receiveResponse=function(s,i,n,o){var a=this;if(s>=100&&199>=s)switch(this.state){case r.STATUS_PROCEEDING:this.transport.send(i)||this.onTransportError(),this.last_response=i}if(s>100&&199>=s)this.reliableProvisionalTimer||(this.reliableProvisionalTimer=e.setTimeout(function(){a.timer_reliableProvisional(1)},t.Timers.T1));else if(s>=200&&299>=s)switch(this.state){case r.STATUS_PROCEEDING:this.state=r.STATUS_ACCEPTED,this.last_response=i,this.L=e.setTimeout(function(){a.timer_L()},t.Timers.TIMER_L),e.clearTimeout(this.reliableProvisionalTimer);case r.STATUS_ACCEPTED:this.transport.send(i)?n&&n():(this.onTransportError(),o&&o())}else if(s>=300&&699>=s)switch(this.state){case r.STATUS_PROCEEDING:e.clearTimeout(this.reliableProvisionalTimer),this.transport.send(i)?(this.state=r.STATUS_COMPLETED,this.H=e.setTimeout(function(){a.timer_H()},t.Timers.TIMER_H),n&&n()):(this.onTransportError(),o&&o())}}};h.prototype=new c,s.NonInviteClientTransaction=function(e,t,s){this.init(e,t,s),this.request_sender.ua.transactions.nict[this.id]=this},s.NonInviteClientTransaction.prototype=new o,s.InviteClientTransaction=function(e,t,s){var i=this;this.init(e,t,s),this.request_sender.ua.transactions.ict[this.id]=this,this.request.cancel=function(e){i.cancel_request(i,e)}},s.InviteClientTransaction.prototype=new a,s.AckClientTransaction=function(e,t,s){this.init(e,t,s),this.send=function(){this.transport.send(t)}},s.AckClientTransaction.prototype=new o,s.NonInviteServerTransaction=function(e,t){this.init(e,t),this.state=r.STATUS_TRYING,t.transactions.nist[this.id]=this},s.NonInviteServerTransaction.prototype=new u,s.InviteServerTransaction=function(e,t){this.init(e,t),this.state=r.STATUS_PROCEEDING,t.transactions.ist[this.id]=this,this.reliableProvisionalTimer=null,e.reply(100)},s.InviteServerTransaction.prototype=new h,s.checkTransaction=function(s,i){var n;switch(i.method){case t.C.INVITE:if(n=s.transactions.ist[i.via_branch]){switch(n.state){case r.STATUS_PROCEEDING:n.transport.send(n.last_response);break;case r.STATUS_ACCEPTED:}return!0}break;case t.C.ACK:if(n=s.transactions.ist[i.via_branch],!n)return!1;if(n.state===r.STATUS_ACCEPTED)return!1;if(n.state===r.STATUS_COMPLETED)return n.state=r.STATUS_CONFIRMED,n.I=e.setTimeout(function(){n.timer_I()},t.Timers.TIMER_I),!0;break;case t.C.CANCEL:return n=s.transactions.ist[i.via_branch],n?n.state===r.STATUS_PROCEEDING?!1:!0:(i.reply_sl(481),!0);default:if(n=s.transactions.nist[i.via_branch]){switch(n.state){case r.STATUS_TRYING:break;case r.STATUS_PROCEEDING:case r.STATUS_COMPLETED:n.transport.send(n.last_response)}return!0}}},s.C=r,t.Transactions=s}(t),function(e){var t,s=e.name+" | "+"DIALOG"+" | ",i={STATUS_EARLY:1,STATUS_CONFIRMED:2};t=function(t,r,n,o){var a;return r.hasHeader("contact")?(o=r instanceof e.IncomingResponse?200>r.status_code?i.STATUS_EARLY:i.STATUS_CONFIRMED:o||i.STATUS_CONFIRMED,a=r.parseHeader("contact"),"UAS"===n?(this.id={call_id:r.call_id,local_tag:r.to_tag,remote_tag:r.from_tag,toString:function(){return this.call_id+this.local_tag+this.remote_tag}},this.state=o,this.remote_seqnum=r.cseq,this.local_uri=r.parseHeader("to").uri,this.remote_uri=r.parseHeader("from").uri,this.remote_target=a.uri,this.route_set=r.getHeaderAll("record-route")):"UAC"===n&&(this.id={call_id:r.call_id,local_tag:r.from_tag,remote_tag:r.to_tag,toString:function(){return this.call_id+this.local_tag+this.remote_tag}},this.state=o,this.local_seqnum=r.cseq,this.local_uri=r.parseHeader("from").uri,this.remote_uri=r.parseHeader("to").uri,this.remote_target=a.uri,this.route_set=r.getHeaderAll("record-route").reverse()),this.session=t,t.ua.dialogs[""+this.id]=this,console.log(s+"new "+n+" dialog created with status "+(this.state===i.STATUS_EARLY?"EARLY":"CONFIRMED")),void 0):(console.error(s+"unable to create a Dialog without Contact header field"),!1)},t.prototype={update:function(e,t){this.state=i.STATUS_CONFIRMED,console.log(s+"dialog "+(""+this.id)+"  changed to CONFIRMED state"),"UAC"===t&&(this.route_set=e.getHeaderAll("record-route").reverse())},terminate:function(){console.log(s+"dialog "+(""+this.id)+" deleted"),delete this.session.ua.dialogs[""+this.id]},createRequest:function(t,s){var i,r;return s=s||[],this.local_seqnum||(this.local_seqnum=Math.floor(1e4*Math.random())),i=t===e.C.CANCEL||t===e.C.ACK?this.local_seqnum:this.local_seqnum+=1,r=new e.OutgoingRequest(t,this.remote_target,this.session.ua,{cseq:i,call_id:this.id.call_id,from_uri:this.local_uri,from_tag:this.id.local_tag,to_uri:this.remote_uri,to_tag:this.id.remote_tag,route_set:this.route_set},s),r.dialog=this,r
},checkInDialogRequest:function(t){if(this.remote_seqnum){if(t.method!==e.C.INVITE&&t.cseq<this.remote_seqnum)return t.method!==e.C.ACK&&t.reply(500),!1;t.cseq>this.remote_seqnum&&(this.remote_seqnum=t.cseq)}else this.remote_seqnum=t.cseq;switch(t.method){case e.C.INVITE:if(t.cseq<this.remote_seqnum){if(this.state===i.STATUS_EARLY){var s=(0|10*Math.random())+1;t.reply(500,null,["Retry-After:"+s])}else t.reply(500);return!1}if(this.state===i.STATUS_EARLY)return t.reply(491),!1;t.hasHeader("contact")&&(this.remote_target=t.parseHeader("contact").uri);break;case e.C.NOTIFY:t.hasHeader("contact")&&(this.remote_target=t.parseHeader("contact").uri)}return!0},receiveRequest:function(e){this.checkInDialogRequest(e)&&this.session.receiveRequest(e)}},t.C=i,e.Dialog=t}(t),function(e){var t,s=e.name+" | "+"REQUEST SENDER"+" | ";t=function(t,s){this.ua=s,this.applicant=t,this.method=t.request.method,this.request=t.request,this.credentials=null,this.challenged=!1,this.staled=!1,s.status!==e.UA.C.STATUS_USER_CLOSED||this.method===e.C.BYE&&this.method===e.C.ACK||this.onTransportError()},t.prototype={send:function(){switch(this.method){case"INVITE":this.clientTransaction=new e.Transactions.InviteClientTransaction(this,this.request,this.ua.transport);break;case"ACK":this.clientTransaction=new e.Transactions.AckClientTransaction(this,this.request,this.ua.transport);break;default:this.clientTransaction=new e.Transactions.NonInviteClientTransaction(this,this.request,this.ua.transport)}this.clientTransaction.send()},onRequestTimeout:function(){this.applicant.onRequestTimeout()},onTransportError:function(){this.applicant.onTransportError()},receiveResponse:function(t){var i,r,n,o=t.status_code;if(401!==o&&407!==o||null===this.ua.configuration.password)this.applicant.receiveResponse(t);else{if(401===t.status_code?(r=t.parseHeader("www-authenticate"),n="authorization"):(r=t.parseHeader("proxy-authenticate"),n="proxy-authorization"),!r)return console.warn(s+t.status_code+" with wrong or missing challenge, cannot authenticate"),this.applicant.receiveResponse(t),void 0;if(!this.challenged||!this.staled&&r.stale===!0){if(this.credentials||(this.credentials=new e.DigestAuthentication(this.ua)),!this.credentials.authenticate(this.request,r))return this.applicant.receiveResponse(t),void 0;this.challenged=!0,r.stale&&(this.staled=!0),t.method===e.C.REGISTER?i=this.applicant.cseq+=1:this.request.dialog?i=this.request.dialog.local_seqnum+=1:(i=this.request.cseq+1,this.request.cseq=i),this.request.setHeader("cseq",i+" "+this.method),this.request.setHeader(n,""+this.credentials),this.send()}else this.applicant.receiveResponse(t)}}},e.RequestSender=t}(t),function(e){var t;t=function(e){this.applicant=e,this.request=e.request},t.prototype={send:function(){var t=new e.RequestSender(this,this.applicant.session.ua);t.send()},onRequestTimeout:function(){this.applicant.session.onRequestTimeout(),this.applicant.onRequestTimeout()},onTransportError:function(){this.applicant.session.onTransportError(),this.applicant.onTransportError()},receiveResponse:function(t){(408===t.status_code||481===t.status_code)&&this.applicant.session.ended("remote",t,e.C.causes.DIALOG_ERROR),this.applicant.receiveResponse(t)}},e.InDialogRequestSender=t}(t),function(t){var s,i=t.name+" | "+"REGISTRATOR"+" | ";s=function(e,s){var i=1;this.ua=e,this.transport=s,this.registrar=e.configuration.registrar_server,this.expires=e.configuration.register_expires,this.min_expires=e.configuration.register_min_expires,this.call_id=t.Utils.createRandomToken(22),this.cseq=80,this.to_uri=e.configuration.uri,this.registrationTimer=null,this.registered=this.registered_before=!1,this.ua.registrator=this,this.contact=""+this.ua.contact,i&&(this.contact+=";reg-id="+i,this.contact+=';+sip.instance="<urn:uuid:'+this.ua.configuration.instance_id+'>"')},s.prototype={register:function(s){var r,n,o,a=this;s=s||{},o=s.extraHeaders||[],o.push("Contact: "+this.contact+";expires="+this.expires),o.push("Allow: "+t.Utils.getAllowedMethods(this.ua)),this.request=new t.OutgoingRequest(t.C.REGISTER,this.registrar,this.ua,{to_uri:this.to_uri,call_id:this.call_id,cseq:this.cseq+=1},o),r=new t.RequestSender(this,this.ua),this.receiveResponse=function(s){var r,o,c,u=s.countHeader("contact");if(s.cseq===this.cseq)switch(!0){case/^1[0-9]{2}$/.test(s.status_code):break;case/^2[0-9]{2}$/.test(s.status_code):if(s.hasHeader("expires")&&(o=s.getHeader("expires")),!u){console.warn(i+"no Contact header in response to REGISTER, response ignored");break}for(;u--;){if(r=s.parseHeader("contact",u),r.uri.user===this.ua.contact.uri.user){o=r.getParam("expires");break}r=null}if(!r){console.warn(i+"no Contact header pointing to us, response ignored");break}o||(o=this.expires),this.registrationTimer=e.setTimeout(function(){a.register()},1e3*o-3e3),r.hasParam("temp-gruu")&&(this.ua.contact.temp_gruu=r.getParam("temp-gruu").replace(/"/g,"")),r.hasParam("pub-gruu")&&(this.ua.contact.pub_gruu=r.getParam("pub-gruu").replace(/"/g,"")),this.registered=!0,this.ua.emit("registered",this.ua,{response:s});break;case/^423$/.test(s.status_code):s.hasHeader("min-expires")?(c=s.getHeader("min-expires"),o=c-this.expires,this.registrationTimer=e.setTimeout(function(){a.register()},1e3*this.expires)):(console.warn(i+"423 response received for REGISTER without Min-Expires"),this.registrationFailure(s,t.C.causes.SIP_FAILURE_CODE));break;default:n=t.Utils.sipErrorCause(s.status_code),this.registrationFailure(s,n)}},this.onRequestTimeout=function(){this.registrationFailure(null,t.C.causes.REQUEST_TIMEOUT)},this.onTransportError=function(){this.registrationFailure(null,t.C.causes.CONNECTION_ERROR)},r.send()},unregister:function(s){var r;if(!this.registered)return console.warn(i+"already unregistered"),void 0;s=s||{},r=s.extraHeaders||[],this.registered=!1,e.clearTimeout(this.registrationTimer),s.all?(r.push("Contact: *"),r.push("Expires: 0"),this.request=new t.OutgoingRequest(t.C.REGISTER,this.registrar,this.ua,{to_uri:this.to_uri,call_id:this.call_id,cseq:this.cseq+=1},r)):(r.push("Contact: "+this.contact+";expires=0"),this.request=new t.OutgoingRequest(t.C.REGISTER,this.registrar,this.ua,{to_uri:this.to_uri,call_id:this.call_id,cseq:this.cseq+=1},r));var n=new t.RequestSender(this,this.ua);this.receiveResponse=function(e){var s;switch(!0){case/^1[0-9]{2}$/.test(e.status_code):break;case/^2[0-9]{2}$/.test(e.status_code):this.unregistered(e);break;default:s=t.Utils.sipErrorCause(e.status_code),this.unregistered(e,s)}},this.onRequestTimeout=function(){this.unregistered(null,t.C.causes.REQUEST_TIMEOUT)},this.onTransportError=function(){this.unregistered(null,t.C.causes.CONNECTION_ERROR)},n.send()},registrationFailure:function(e,t){this.ua.emit("registrationFailed",this.ua,{response:e||null,cause:t}),this.registered&&(this.registered=!1,this.ua.emit("unregistered",this.ua,{response:e||null,cause:t}))},unregistered:function(e,t){this.registered=!1,this.ua.emit("unregistered",this.ua,{response:e||null,cause:t||null})},onTransportClosed:function(){this.registered_before=this.registered,e.clearTimeout(this.registrationTimer),this.registered&&(this.registered=!1,this.ua.emit("unregistered",this.ua))},onTransportConnected:function(){this.register()},close:function(){this.registered_before=this.registered,this.unregister()}},t.Registrator=s}(t),function(t){var s,i=function(t){var s=function(e,s){this.applicant=e,this.request=s||e.request,this.session=e instanceof t.RTCSession?e:e.session,this.reattempt=!1,this.reatemptTimer=null,this.request_sender=new t.InDialogRequestSender(this)};return s.prototype={receiveResponse:function(s){var i=this,r=s.status_code;s.method===t.C.INVITE&&491===r?this.reattempt?this.applicant.receiveResponse(s):(this.request.cseq.value=this.request.dialog.local_seqnum+=1,this.reatemptTimer=e.setTimeout(function(){i.session.status!==t.RTCSession.C.STATUS_TERMINATED&&(i.reattempt=!0,i.request_sender.send())},this.getReattemptTimeout())):this.applicant.receiveResponse(s)},send:function(){this.request_sender.send()},onRequestTimeout:function(){this.applicant.onRequestTimeout()},onTransportError:function(){this.applicant.onTransportError()},getReattemptTimeout:function(){return"outgoing"===this.session.direction?(1.9*Math.random()+2.1).toFixed(2):(2*Math.random()).toFixed(2)}},s}(t),r=function(e){var t=function(e,t){t=t||{},this.session=e,this.localMedia=null,this.peerConnection=null,this.init(t)};return t.prototype={createOffer:function(e,t){var s=this,i=!1;this.onIceCompleted=function(){i||(i=!0,e(s.peerConnection.localDescription.sdp))},this.peerConnection.createOffer(function(e){s.setLocalDescription(e,t)},function(e){console.error(o+"unable to create offer"),console.error(e),t()})},createAnswer:function(e,t){var s=this,i=!1;this.onIceCompleted=function(){i||(i=!0,e(s.peerConnection.localDescription.sdp))},this.peerConnection.createAnswer(function(e){s.setLocalDescription(e,t)},function(e){console.error(o+"unable to create answer"),console.error(e),t()})},setLocalDescription:function(e,t){this.peerConnection.setLocalDescription(e,null,function(e){console.error(o+"unable to set local description"),console.error(e),t()})},addStream:function(e,t,s,i){try{this.peerConnection.addStream(e,i)}catch(r){return console.error(o+"error adding stream"),console.error(r),s(),void 0}t()},init:function(t){var s,i,r,n,a=this,c=[];for(s in this.session.ua.configuration.stun_servers)i=this.session.ua.configuration.stun_servers[s],c.push({url:i});for(s in this.session.ua.configuration.turn_servers)i=this.session.ua.configuration.turn_servers[s],n=i.server,r=n.substr(0,n.indexOf(":")),c.push({url:r+":"+i.username+"@"+n.substr(r.length+1),credential:i.password});this.peerConnection=new e.WebRTC.RTCPeerConnection({iceServers:c},t),this.peerConnection.onaddstream=function(e){console.log(o+"stream added: "+e.stream.id)},this.peerConnection.onremovestream=function(e){console.log(o+"stream removed: "+e.stream.id)},this.peerConnection.onicecandidate=function(e){e.candidate?console.log(o+"ICE candidate received: "+e.candidate.candidate):a.onIceCompleted()},this.peerConnection.ongatheringchange=function(e){"complete"===e.currentTarget.iceGatheringState&&"closed"!==this.iceConnectionState&&a.onIceCompleted()},this.peerConnection.onicechange=function(){console.log(o+'ICE connection state changed to "'+this.iceConnectionState+'"')},this.peerConnection.onstatechange=function(){console.log(o+'PeerConnection state changed to "'+this.readyState+'"')}},close:function(){console.log(o+"closing PeerConnection"),this.peerConnection&&(this.peerConnection.close(),this.localMedia&&this.localMedia.stop())},getUserMedia:function(t,s,i){var r=this;console.log(o+"requesting access to local media"),e.WebRTC.getUserMedia(i,function(e){console.log(o+"got local media stream"),r.localMedia=e,t(e)},function(e){console.error(o+"unable to get user media"),console.error(e),s()})},onMessage:function(t,s,i,r){this.peerConnection.setRemoteDescription(new e.WebRTC.RTCSessionDescription({type:t,sdp:s}),i,r)}},t}(t),n=function(e){var t,s={MIN_DURATION:70,MAX_DURATION:6e3,DEFAULT_DURATION:100,MIN_INTER_TONE_GAP:50,DEFAULT_INTER_TONE_GAP:500};return t=function(e){var t=["succeeded","failed"];this.session=e,this.direction=null,this.tone=null,this.duration=null,this.initEvents(t)},t.prototype=new e.EventEmitter,t.prototype.send=function(t,r){var n,a,c,u;if(void 0===t)throw new TypeError("Not enough arguments");if(this.direction="outgoing",this.session.status!==e.RTCSession.C.STATUS_CONFIRMED&&this.session.status!==e.RTCSession.C.STATUS_WAITING_FOR_ACK)throw new e.Exceptions.InvalidStateError(this.session.status);if(r=r||{},u=r.extraHeaders?r.extraHeaders.slice():[],c=r.eventHandlers||{},"string"==typeof t)t=t.toUpperCase();else{if("number"!=typeof t)throw new TypeError("Invalid tone: "+t);t=""+t}if(!t.match(/^[0-9A-D#*]$/))throw new TypeError("Invalid tone: "+t);if(this.tone=t,r.duration&&!e.Utils.isDecimal(r.duration))throw new TypeError("Invalid tone duration: "+r.duration);r.duration?r.duration<s.MIN_DURATION?(console.warn(o+'"duration" value is lower than the minimum allowed, setting it to '+s.MIN_DURATION+" milliseconds"),r.duration=s.MIN_DURATION):r.duration>s.MAX_DURATION?(console.warn(o+'"duration" value is greater than the maximum allowed, setting it to '+s.MAX_DURATION+" milliseconds"),r.duration=s.MAX_DURATION):r.duration=Math.abs(r.duration):r.duration=s.DEFAULT_DURATION,this.duration=r.duration;for(a in c)this.on(a,c[a]);u.push("Content-Type: application/dtmf-relay"),this.request=this.session.dialog.createRequest(e.C.INFO,u),this.request.body="Signal= "+this.tone+"\r\n",this.request.body+="Duration= "+this.duration,n=new i(this),this.session.emit("newDTMF",this.session,{originator:"local",dtmf:this,request:this.request}),n.send()},t.prototype.receiveResponse=function(t){var s;switch(!0){case/^1[0-9]{2}$/.test(t.status_code):break;case/^2[0-9]{2}$/.test(t.status_code):this.emit("succeeded",this,{originator:"remote",response:t});break;default:s=e.Utils.sipErrorCause(t.status_code),this.emit("failed",this,{originator:"remote",response:t,cause:s})}},t.prototype.onRequestTimeout=function(){this.emit("failed",this,{originator:"system",cause:e.C.causes.REQUEST_TIMEOUT})},t.prototype.onTransportError=function(){this.emit("failed",this,{originator:"system",cause:e.C.causes.CONNECTION_ERROR})},t.prototype.init_incoming=function(e){var t,s=/^(Signal\s*?=\s*?)([0-9A-D#*]{1})(\s)?.*/,i=/^(Duration\s?=\s?)([0-9]{1,4})(\s)?.*/;this.direction="incoming",this.request=e,e.reply(200),e.body&&(t=e.body.split("\r\n"),2===t.length&&(s.test(t[0])&&(this.tone=t[0].replace(s,"$2")),i.test(t[1])&&(this.duration=parseInt(t[1].replace(i,"$2"),10)))),this.tone&&this.duration?this.session.emit("newDTMF",this.session,{originator:"remote",dtmf:this,request:e}):console.warn(o+"invalid INFO DTMF received, discarded")},t.C=s,t}(t),o=t.name+" | "+"RTC SESSION"+" | ",a={STATUS_NULL:0,STATUS_INVITE_SENT:1,STATUS_1XX_RECEIVED:2,STATUS_INVITE_RECEIVED:3,STATUS_WAITING_FOR_ANSWER:4,STATUS_WAITING_FOR_ACK:5,STATUS_CANCELED:6,STATUS_TERMINATED:7,STATUS_CONFIRMED:8};s=function(e){var t=["progress","failed","started","ended","newDTMF"];this.ua=e,this.status=a.STATUS_NULL,this.dialog=null,this.earlyDialogs=[],this.rtcMediaHandler=null,this.timers={ackTimer:null,expiresTimer:null,invite2xxTimer:null,userNoAnswerTimer:null},this.direction=null,this.local_identity=null,this.remote_identity=null,this.start_time=null,this.end_time=null,this.data={},this.initEvents(t)},s.prototype=new t.EventEmitter,s.prototype.terminate=function(e){e=e||{};var s,i=e.status_code,r=e.reason_phrase,n=e.extraHeaders||[],c=e.body;if(this.status===a.STATUS_TERMINATED)throw new t.Exceptions.InvalidStateError(this.status);switch(this.status){case a.STATUS_NULL:case a.STATUS_INVITE_SENT:case a.STATUS_1XX_RECEIVED:if(console.log(o+"canceling RTCSession"),i&&(200>i||i>=700))throw new TypeError("Invalid status_code: "+i);i&&(r=r||t.C.REASON_PHRASE[i]||"",s="SIP ;cause="+i+' ;text="'+r+'"'),this.status===a.STATUS_NULL?(this.isCanceled=!0,this.cancelReason=s):this.status===a.STATUS_INVITE_SENT?this.received_100?this.request.cancel(s):(this.isCanceled=!0,this.cancelReason=s):this.status===a.STATUS_1XX_RECEIVED&&this.request.cancel(s),this.failed("local",null,t.C.causes.CANCELED);break;case a.STATUS_WAITING_FOR_ANSWER:if(console.log(o+"rejecting RTCSession"),i=i||480,300>i||i>=700)throw new TypeError("Invalid status_code: "+i);this.request.reply(i,r,n,c),this.failed("local",null,t.C.causes.REJECTED);break;case a.STATUS_WAITING_FOR_ACK:case a.STATUS_CONFIRMED:console.log(o+"terminating RTCSession"),this.sendBye(e),this.ended("local",null,t.C.causes.BYE)}this.close()},s.prototype.answer=function(s){s=s||{};var i=this,r=this.request,n=s.extraHeaders||[],c=s.mediaConstraints||{audio:!0,video:!0},u=function(e){i.rtcMediaHandler.addStream(e,l,d)},h=function(){r.reply(480),i.failed("local",null,t.C.causes.USER_DENIED_MEDIA_ACCESS)},l=function(){i.rtcMediaHandler.createAnswer(p,T)},d=function(){i.status!==a.STATUS_TERMINATED&&i.failed("local",null,t.C.causes.WEBRTC_ERROR)},p=function(s){var c=function(){i.status=a.STATUS_WAITING_FOR_ACK,i.timers.invite2xxTimer=e.setTimeout(function n(o){o=o||1;var a=t.Timers.T1*Math.pow(2,o);o*t.Timers.T1<=t.Timers.T2?(o+=1,r.reply(200,null,["Contact: "+i.contact],s),i.timers.invite2xxTimer=e.setTimeout(n(o),a)):e.clearTimeout(i.timers.invite2xxTimer)},t.Timers.T1),i.timers.ackTimer=e.setTimeout(function(){i.status===a.STATUS_WAITING_FOR_ACK&&(console.log(o+"no ACK received, terminating the call"),e.clearTimeout(i.timers.invite2xxTimer),i.sendBye(),i.ended("remote",null,t.C.causes.NO_ACK))},t.Timers.TIMER_H),i.started("local")},u=function(){i.failed("system",null,t.C.causes.CONNECTION_ERROR)};n.push("Contact: "+i.contact),r.reply(200,null,n,s,c,u)},T=function(){i.status!==a.STATUS_TERMINATED&&i.failed("local",null,t.C.causes.WEBRTC_ERROR)};if("incoming"!==this.direction)throw new TypeError('Invalid method "answer" for an outgoing call');if(this.status!==a.STATUS_WAITING_FOR_ANSWER)throw new t.Exceptions.InvalidStateError(this.status);return this.createDialog(r,"UAS")?(e.clearTimeout(this.timers.userNoAnswerTimer),this.rtcMediaHandler.getUserMedia(u,h,c),void 0):(r.reply(500,"Missing Contact header field"),void 0)},s.prototype.sendDTMF=function(s,i){function r(){var e,t=new n(l);t.on("failed",function(){d=!1}),e=s[h],h+=1,t.send(e,i)}var c,u,h=0,l=this,d=!0;if(i=i||{},u=i.interToneGap||null,void 0===s)throw new TypeError("Not enough arguments");if(this.status!==a.STATUS_CONFIRMED&&this.status!==a.STATUS_WAITING_FOR_ACK)throw new t.Exceptions.InvalidStateError(this.status);if(!s||"string"!=typeof s&&"number"!=typeof s||!(""+s).match(/^[0-9A-D#*]+$/i))throw new TypeError("Invalid tones: "+s);if(s=""+s,u&&!t.Utils.isDecimal(u))throw new TypeError("Invalid interToneGap: "+u);u?n.C.MIN_INTER_TONE_GAP>u?(console.warn(o+'"interToneGap" value is lower than the minimum allowed, setting it to '+n.C.MIN_INTER_TONE_GAP+" milliseconds"),u=n.C.MIN_INTER_TONE_GAP):u=Math.abs(u):u=n.C.DEFAULT_INTER_TONE_GAP,r(),c=e.setInterval(function(){l.status!==a.STATUS_TERMINATED&&d&&s.length>h?r():e.clearInterval(c)},u)},s.prototype.getLocalStreams=function(){return this.rtcMediaHandler&&this.rtcMediaHandler.peerConnection&&this.rtcMediaHandler.peerConnection.getLocalStreams()||[]},s.prototype.getRemoteStreams=function(){return this.rtcMediaHandler&&this.rtcMediaHandler.peerConnection&&this.rtcMediaHandler.peerConnection.getRemoteStreams()||[]},s.prototype.init_incoming=function(s){var i,n=this,c=s.getHeader("Content-Type");return s.body&&"application/sdp"===c?(this.status=a.STATUS_INVITE_RECEIVED,this.from_tag=s.from_tag,this.id=s.call_id+this.from_tag,this.request=s,this.contact=""+this.ua.contact,this.ua.sessions[this.id]=this,s.hasHeader("expires")&&(i=1e3*s.getHeader("expires")),s.to_tag=t.Utils.newTag(),this.createDialog(s,"UAS",!0)?(this.rtcMediaHandler=new r(this),this.rtcMediaHandler.onMessage("offer",s.body,function(){s.reply(180,null,["Contact: "+n.contact]),n.status=a.STATUS_WAITING_FOR_ANSWER,n.timers.userNoAnswerTimer=e.setTimeout(function(){s.reply(408),n.failed("local",null,t.C.causes.NO_ANSWER)},n.ua.configuration.no_answer_timeout),i&&(n.timers.expiresTimer=e.setTimeout(function(){n.status===a.STATUS_WAITING_FOR_ANSWER&&(s.reply(487),n.failed("system",null,t.C.causes.EXPIRES))},i)),n.newRTCSession("remote",s)},function(e){console.warn(o+"invalid SDP"),console.warn(e),s.reply(488)}),void 0):(s.reply(500,"Missing Contact header field"),void 0)):(s.reply(415),void 0)},s.prototype.connect=function(e,s){s=s||{};var i,n,o=!1,c=s.eventHandlers||{},u=s.extraHeaders||[],h=s.mediaConstraints||{audio:!0,video:!0},l=s.RTCConstraints||{};if(void 0===e)throw new TypeError("Not enough arguments");if(this.status!==a.STATUS_NULL)throw new t.Exceptions.InvalidStateError(this.status);for(i in c)this.on(i,c[i]);try{e=t.Utils.normalizeURI(e,this.ua.configuration.hostport_params)}catch(d){e=t.URI.parse(t.C.INVALID_TARGET_URI),o=!0}this.from_tag=t.Utils.newTag(),this.rtcMediaHandler=new r(this,l),this.anonymous=s.anonymous,this.isCanceled=!1,this.received_100=!1,n={from_tag:this.from_tag},this.contact=this.ua.contact.toString({anonymous:this.anonymous,outbound:!0}),this.anonymous&&(n.from_display_name="Anonymous",n.from_uri="sip:anonymous@anonymous.invalid",u.push("P-Preferred-Identity: "+(""+this.ua.configuration.uri)),u.push("Privacy: id")),u.push("Contact: "+this.contact),u.push("Allow: "+t.Utils.getAllowedMethods(this.ua)),u.push("Content-Type: application/sdp"),this.request=new t.OutgoingRequest(t.C.INVITE,e,this.ua,n,u),this.id=this.request.call_id+this.from_tag,this.ua.sessions[this.id]=this,this.newRTCSession("local",this.request),o?this.failed("local",null,t.C.causes.INVALID_TARGET):t.WebRTC.isSupported?this.sendInitialRequest(h):this.failed("local",null,t.C.causes.WEBRTC_NOT_SUPPORTED)},s.prototype.close=function(){var t;if(this.status!==a.STATUS_TERMINATED){console.log(o+"closing INVITE session "+this.id),this.rtcMediaHandler&&this.rtcMediaHandler.close();for(t in this.timers)e.clearTimeout(this.timers[t]);this.dialog&&(this.dialog.terminate(),delete this.dialog);for(t in this.earlyDialogs)this.earlyDialogs[t].terminate(),delete this.earlyDialogs[t];this.status=a.STATUS_TERMINATED,delete this.ua.sessions[this.id]}},s.prototype.createDialog=function(e,s,i){var r,n,o="UAS"===s?e.to_tag:e.from_tag,a="UAS"===s?e.from_tag:e.to_tag,c=e.call_id+o+a;return n=this.earlyDialogs[c],i?n?!0:(n=new t.Dialog(this,e,s,t.Dialog.C.STATUS_EARLY),n.id?(this.earlyDialogs[c]=n,!0):(this.failed("remote",e,t.C.causes.INTERNAL_ERROR),!1)):n?(n.update(e,s),this.dialog=n,delete this.earlyDialogs[c],!0):(r=new t.Dialog(this,e,s),r.id?(this.to_tag=e.to_tag,this.dialog=r,!0):(this.failed("remote",e,t.C.causes.INTERNAL_ERROR),!1))},s.prototype.receiveRequest=function(s){var i;if(s.method===t.C.CANCEL)this.request.reply(487),this.status===a.STATUS_WAITING_FOR_ANSWER&&(this.status=a.STATUS_CANCELED,this.failed("remote",s,t.C.causes.CANCELED));else switch(s.method){case t.C.ACK:this.status===a.STATUS_WAITING_FOR_ACK&&(e.clearTimeout(this.timers.ackTimer),e.clearTimeout(this.timers.invite2xxTimer),this.status=a.STATUS_CONFIRMED);break;case t.C.BYE:this.status===a.STATUS_CONFIRMED&&(s.reply(200),this.ended("remote",s,t.C.causes.BYE));break;case t.C.INVITE:this.status===a.STATUS_CONFIRMED&&console.log(o+"re-INVITE received");break;case t.C.INFO:(this.status===a.STATUS_CONFIRMED||this.status===a.STATUS_WAITING_FOR_ACK)&&(i=s.getHeader("content-type"),i&&i.match(/^application\/dtmf-relay/i)&&new n(this).init_incoming(s))}},s.prototype.sendInitialRequest=function(e){var s=this,i=new t.RequestSender(s,this.ua),r=function(e){s.rtcMediaHandler.addStream(e,o,c)},n=function(){s.status!==a.STATUS_TERMINATED&&s.failed("local",null,t.C.causes.USER_DENIED_MEDIA_ACCESS)},o=function(){s.rtcMediaHandler.createOffer(u,h)},c=function(){s.status!==a.STATUS_TERMINATED&&s.failed("local",null,t.C.causes.WEBRTC_ERROR)},u=function(e){s.isCanceled||s.status===a.STATUS_TERMINATED||(s.request.body=e,s.status=a.STATUS_INVITE_SENT,i.send())},h=function(){s.status!==a.STATUS_TERMINATED&&s.failed("local",null,t.C.causes.WEBRTC_ERROR)};this.rtcMediaHandler.getUserMedia(r,n,e)},s.prototype.receiveResponse=function(e){var s,i=this;if(this.status===a.STATUS_INVITE_SENT||this.status===a.STATUS_1XX_RECEIVED){if(this.isCanceled)return e.status_code>=100&&200>e.status_code?this.request.cancel(this.cancelReason):e.status_code>=200&&299>e.status_code&&this.acceptAndTerminate(e),void 0;switch(!0){case/^100$/.test(e.status_code):this.received_100=!0;break;case/^1[0-9]{2}$/.test(e.status_code):if(!e.to_tag){console.warn(o+"1xx response received without to tag");break}e.hasHeader("contact")&&this.createDialog(e,"UAC",!0),this.status=a.STATUS_1XX_RECEIVED,this.progress("remote",e);break;case/^2[0-9]{2}$/.test(e.status_code):if(this.dialog)break;if(!e.body){this.acceptAndTerminate(e,400,"Missing session description"),this.failed("remote",e,t.C.causes.BAD_MEDIA_DESCRIPTION);break}this.rtcMediaHandler.onMessage("answer",e.body,function(){i.createDialog(e,"UAC")&&(i.sendACK(),i.status=a.STATUS_CONFIRMED,i.started("remote",e))},function(s){console.warn(s),i.acceptAndTerminate(e,488,"Not Acceptable Here"),i.failed("remote",e,t.C.causes.BAD_MEDIA_DESCRIPTION)});break;default:s=t.Utils.sipErrorCause(e.status_code),this.failed("remote",e,s)}}},s.prototype.acceptAndTerminate=function(e,t,s){(this.dialog||this.createDialog(e,"UAC"))&&(this.sendACK(),this.sendBye({status_code:t,reason_phrase:s}))},s.prototype.sendACK=function(){var e=this.dialog.createRequest(t.C.ACK);this.sendRequest(e)},s.prototype.sendBye=function(e){e=e||{};var s,i,r=e.status_code,n=e.reason_phrase||t.C.REASON_PHRASE[r]||"",o=e.extraHeaders||[],a=e.body;if(r&&(200>r||r>=700))throw new TypeError("Invalid status_code: "+r);r&&(i="SIP ;cause="+r+'; text="'+n+'"',o.push("Reason: "+i)),s=this.dialog.createRequest(t.C.BYE,o),s.body=a,this.sendRequest(s)},s.prototype.sendRequest=function(e){var t=new i(this,e);t.send()},s.prototype.onTransportError=function(){this.status!==a.STATUS_TERMINATED&&(this.status===a.STATUS_CONFIRMED?this.ended("system",null,t.C.causes.CONNECTION_ERROR):this.failed("system",null,t.C.causes.CONNECTION_ERROR))},s.prototype.onRequestTimeout=function(){this.status!==a.STATUS_TERMINATED&&(this.status===a.STATUS_CONFIRMED?this.ended("system",null,t.C.causes.REQUEST_TIMEOUT):this.failed("system",null,t.C.causes.CONNECTION_ERROR))},s.prototype.newRTCSession=function(e,t){var s=this,i="newRTCSession";"remote"===e?(s.direction="incoming",s.local_identity=t.to,s.remote_identity=t.from):"local"===e&&(s.direction="outgoing",s.local_identity=t.from,s.remote_identity=t.to),s.ua.emit(i,s.ua,{originator:e,session:s,request:t})},s.prototype.connecting=function(e,t){var s=this,i="connecting";s.emit(i,s,{originator:"local",request:t})},s.prototype.progress=function(e,t){var s=this,i="progress";s.emit(i,s,{originator:e,response:t||null})},s.prototype.started=function(e,t){var s=this,i="started";s.start_time=new Date,s.emit(i,s,{response:t||null})},s.prototype.ended=function(e,t,s){var i=this,r="ended";i.end_time=new Date,i.close(),i.emit(r,i,{originator:e,message:t||null,cause:s})},s.prototype.failed=function(e,t,s){var i=this,r="failed";i.close(),i.emit(r,i,{originator:e,message:t||null,cause:s})},s.C=a,t.RTCSession=s}(t),function(e){var t;t=function(e){this.ua=e,this.direction=null,this.local_identity=null,this.remote_identity=null,this.data={}},t.prototype=new e.EventEmitter,t.prototype.send=function(t,s,i){var r,n,o,a,c,u=["succeeded","failed"],h=!1;if(void 0===t||void 0===s)throw new TypeError("Not enough arguments");this.initEvents(u),i=i||{},c=i.extraHeaders||[],a=i.eventHandlers||{},o=i.contentType||"text/plain";for(n in a)this.on(n,a[n]);try{t=e.Utils.normalizeURI(t,this.ua.configuration.hostport_params)}catch(l){t=e.URI.parse(e.C.INVALID_TARGET_URI),h=!0}this.direction="outgoing",this.local_identity=this.ua.configuration.uri,this.remote_identity=t,this.closed=!1,this.ua.applicants[this]=this,c.push("Content-Type: "+o),this.request=new e.OutgoingRequest(e.C.MESSAGE,t,this.ua,null,c),s&&(this.request.body=s),r=new e.RequestSender(this,this.ua),this.ua.emit("newMessage",this.ua,{originator:"local",message:this,request:this.request}),h?this.emit("failed",this,{originator:"local",cause:e.C.causes.INVALID_TARGET}):r.send()},t.prototype.receiveResponse=function(t){var s;if(!this.closed)switch(!0){case/^1[0-9]{2}$/.test(t.status_code):break;case/^2[0-9]{2}$/.test(t.status_code):delete this.ua.applicants[this],this.emit("succeeded",this,{originator:"remote",response:t});break;default:delete this.ua.applicants[this],s=e.Utils.sipErrorCause(t.status_code),this.emit("failed",this,{originator:"remote",response:t,cause:s})}},t.prototype.onRequestTimeout=function(){this.closed||this.emit("failed",this,{originator:"system",cause:e.C.causes.REQUEST_TIMEOUT})},t.prototype.onTransportError=function(){this.closed||this.emit("failed",this,{originator:"system",cause:e.C.causes.CONNECTION_ERROR})},t.prototype.close=function(){this.closed=!0,delete this.ua.applicants[this]},t.prototype.init_incoming=function(t){var s,i=t.getHeader("content-type");this.direction="incoming",this.request=t,this.local_identity=t.to.uri,this.remote_identity=t.from.uri,i&&(i.match(/^text\/plain(\s*;\s*.+)*$/i)||i.match(/^text\/html(\s*;\s*.+)*$/i))?(this.ua.emit("newMessage",this.ua,{originator:"remote",message:this,request:t}),s=this.ua.transactions.nist[t.via_branch],!s||s.state!==e.Transactions.C.STATUS_TRYING&&s.state!==e.Transactions.C.STATUS_PROCEEDING||t.reply(200)):t.reply(415,null,["Accept: text/plain, text/html"])},t.prototype.accept=function(e){e=e||{};var t=e.extraHeaders||[],s=e.body;if("incoming"!==this.direction)throw new TypeError('Invalid method "accept" for an outgoing message');this.request.reply(200,null,t,s)},t.prototype.reject=function(e){e=e||{};var t=e.status_code||480,s=e.reason_phrase,i=e.extraHeaders||[],r=e.body;if("incoming"!==this.direction)throw new TypeError('Invalid method "reject" for an outgoing message');if(300>t||t>=700)throw new TypeError("Invalid status_code: "+t);this.request.reply(t,s,i,r)},e.Message=t}(t),function(t){var s,i=t.name+" | "+"UA"+" | ",r={STATUS_INIT:0,STATUS_READY:1,STATUS_USER_CLOSED:2,STATUS_NOT_READY:3,CONFIGURATION_ERROR:1,NETWORK_ERROR:2,EVENT_METHODS:{newRTCSession:"INVITE",newMessage:"MESSAGE"},ALLOWED_METHODS:["ACK","CANCEL","BYE","OPTIONS"],ACCEPTED_BODY_TYPES:["application/sdp","application/dtmf-relay"],SUPPORTED:"path, outbound, gruu",MAX_FORWARDS:69,TAG_LENGTH:10};s=function(e){var t=["connected","disconnected","registered","unregistered","registrationFailed","newRTCSession","newMessage"];if(r.ACCEPTED_BODY_TYPES=""+r.ACCEPTED_BODY_TYPES,this.cache={credentials:{}},this.configuration={},this.dialogs={},this.registrator=null,this.applicants={},this.sessions={},this.transport=null,this.contact=null,this.status=r.STATUS_INIT,this.error=null,this.transactions={nist:{},nict:{},ist:{},ict:{}},this.transportRecoverAttempts=0,void 0===e)throw new TypeError("Not enough arguments");try{this.loadConfig(e),this.initEvents(t)}catch(s){throw this.status=r.STATUS_NOT_READY,this.error=r.CONFIGURATION_ERROR,s}},s.prototype=new t.EventEmitter,s.prototype.register=function(e){this.configuration.register=!0,this.registrator.register(e)},s.prototype.unregister=function(e){this.configuration.register=!1,this.registrator.unregister(e)},s.prototype.isRegistered=function(){return this.registrator&&this.registrator.registered?!0:!1},s.prototype.isConnected=function(){return this.transport?this.transport.connected:!1},s.prototype.call=function(e,s){var i;i=new t.RTCSession(this),i.connect(e,s)},s.prototype.sendMessage=function(e,s,i){var r;r=new t.Message(this),r.send(e,s,i)},s.prototype.stop=function(){var t,s,n=this;if(console.log(i+"user requested closure..."),this.status===r.STATUS_USER_CLOSED)return console.warn("UA already closed"),void 0;this.registrator&&(console.log(i+"closing registrator"),this.registrator.close());for(t in this.sessions)console.log(i+"closing session "+t),this.sessions[t].terminate();for(s in this.applicants)this.applicants[s].close();this.status=r.STATUS_USER_CLOSED,this.shutdownGraceTimer=e.setTimeout(function(){n.transport.disconnect()},"5000")},s.prototype.start=function(){var e;console.log(i+"user requested startup..."),this.status===r.STATUS_INIT?(e=this.getNextWsServer(),new t.Transport(this,e)):this.status===r.STATUS_USER_CLOSED?(console.log(i+"resuming"),this.status=r.STATUS_READY,this.transport.connect()):this.status===r.STATUS_READY?console.log(i+"UA is in READY status, not resuming"):console.error("Connection is down. Auto-Recovery system is trying to connect")},s.prototype.saveCredentials=function(e){this.cache.credentials[e.realm]=this.cache.credentials[e.realm]||{},this.cache.credentials[e.realm][e.uri]=e},s.prototype.getCredentials=function(e){var t,s;
return t=e.ruri.host,this.cache.credentials[t]&&this.cache.credentials[t][e.ruri]&&(s=this.cache.credentials[t][e.ruri],s.method=e.method),s},s.prototype.onTransportClosed=function(e){var s,r,n=["nict","ict","nist","ist"];e.server.status=t.Transport.C.STATUS_DISCONNECTED,console.log(i+"connection state set to "+t.Transport.C.STATUS_DISCONNECTED);for(s in n)for(r in this.transactions[n[s]])this.transactions[n[s]][r].onTransportError();this.contact.pub_gruu||this.closeSessionsOnTransportError()},s.prototype.onTransportError=function(e){var s;console.log(i+"transport "+e.server.ws_uri+" failed | connection state set to "+t.Transport.C.STATUS_ERROR),e.server.status=t.Transport.C.STATUS_ERROR,this.emit("disconnected",this,{transport:e,code:e.lastTransportError.code,reason:e.lastTransportError.reason}),s=this.getNextWsServer(),s?new t.Transport(this,s):(this.closeSessionsOnTransportError(),this.error&&this.error===r.NETWORK_ERROR||(this.status=r.STATUS_NOT_READY,this.error=r.NETWORK_ERROR),this.recoverTransport())},s.prototype.onTransportConnected=function(e){this.transport=e,this.transportRecoverAttempts=0,e.server.status=t.Transport.C.STATUS_READY,console.log(i+"connection state set to "+t.Transport.C.STATUS_READY),this.status!==r.STATUS_USER_CLOSED&&(this.status=r.STATUS_READY,this.error=null,this.emit("connected",this,{transport:e}),this.configuration.register?this.registrator?this.registrator.onTransportConnected():(this.registrator=new t.Registrator(this,e),this.register()):this.registrator=new t.Registrator(this,e))},s.prototype.receiveRequest=function(e){var s,n,o,a=e.method;if(e.ruri.user!==this.configuration.uri.user&&e.ruri.user!==this.contact.uri.user)return console.warn(i+"Request-URI does not point to us"),e.method!==t.C.ACK&&e.reply_sl(404),void 0;if(!t.Transactions.checkTransaction(this,e)){if(a===t.C.INVITE?new t.Transactions.InviteServerTransaction(e,this):a!==t.C.ACK&&new t.Transactions.NonInviteServerTransaction(e,this),a===t.C.OPTIONS)e.reply(200,null,["Allow: "+t.Utils.getAllowedMethods(this),"Accept: "+r.ACCEPTED_BODY_TYPES]);else if(a===t.C.MESSAGE){if(!this.checkEvent("newMessage")||0===this.listeners("newMessage").length)return e.reply(405,null,["Allow: "+t.Utils.getAllowedMethods(this)]),void 0;o=new t.Message(this),o.init_incoming(e)}if(e.to_tag)s=this.findDialog(e),s?s.receiveRequest(e):a===t.C.NOTIFY?(n=this.findSession(e),n?n.receiveRequest(e):(console.warn(i+"received NOTIFY request for a non existent session"),e.reply(481,"Subscription does not exist"))):a!==t.C.ACK&&e.reply(481);else{if(!this.isRegistered())return e.reply(410),void 0;switch(a){case t.C.INVITE:t.WebRTC.isSupported?(n=new t.RTCSession(this),n.init_incoming(e)):(console.warn(i+"INVITE received but WebRTC is not supported"),e.reply(488));break;case t.C.BYE:e.reply(481);break;case t.C.CANCEL:e.reply(200),n=this.findSession(e),n?n.receiveRequest(e):console.warn(i+"received CANCEL request for a non existent session");break;case t.C.ACK:break;default:e.reply(405)}}}},s.prototype.findSession=function(e){var t=e.call_id+e.from_tag,s=this.sessions[t],i=e.call_id+e.to_tag,r=this.sessions[i];return s?s:r?r:null},s.prototype.findDialog=function(e){var t=e.call_id+e.from_tag+e.to_tag,s=this.dialogs[t];return s?s:(t=e.call_id+e.to_tag+e.from_tag,s=this.dialogs[t],s?s:null)},s.prototype.getNextWsServer=function(){var e,s,i=[];for(e in this.configuration.ws_servers)s=this.configuration.ws_servers[e],s.status!==t.Transport.C.STATUS_ERROR&&(0===i.length?i.push(s):s.weight>i[0].weight?i=[s]:s.weight===i[0].weight&&i.push(s));return e=Math.floor(Math.random()*i.length),i[e]},s.prototype.closeSessionsOnTransportError=function(){var e;for(e in this.sessions)this.sessions[e].onTransportError();this.registrator&&this.registrator.onTransportClosed()},s.prototype.recoverTransport=function(s){var r,n,o,a,c;s=s||this,a=s.transportRecoverAttempts;for(r in s.configuration.ws_servers)s.configuration.ws_servers[r].status=0;c=s.getNextWsServer(),n=Math.floor(Math.random()*Math.pow(2,a)+1),o=n*s.configuration.connection_recovery_min_interval,o>s.configuration.connection_recovery_max_interval&&(console.log(i+"time for next connection attempt exceeds connection_recovery_max_interval, resetting counter"),o=s.configuration.connection_recovery_min_interval,a=0),console.log(i+"next connection attempt in "+o+" seconds"),e.setTimeout(function(){s.transportRecoverAttempts=a+1,new t.Transport(s,c)},1e3*o)},s.prototype.loadConfig=function(r){var n,o,a,c,u,h={via_host:t.Utils.createRandomToken(12)+".invalid",password:null,register_expires:600,register_min_expires:120,register:!0,registrar_server:null,ws_server_max_reconnection:3,ws_server_reconnection_timeout:4,connection_recovery_min_interval:2,connection_recovery_max_interval:30,use_preloaded_route:!1,no_answer_timeout:60,stun_servers:["stun:stun.l.google.com:19302"],turn_servers:[],trace_sip:!1,hack_via_tcp:!1,hack_ip_in_contact:!1};for(n in s.configuration_check.mandatory){if(!r.hasOwnProperty(n))throw new t.Exceptions.ConfigurationError(n);if(o=r[n],a=s.configuration_check.mandatory[n](o),void 0===a)throw new t.Exceptions.ConfigurationError(n,o);h[n]=a}for(n in s.configuration_check.optional)if(r.hasOwnProperty(n)){if(o=r[n],null===o||""===o||void 0===o)continue;if("number"==typeof o&&e.isNaN(o))continue;if(a=s.configuration_check.optional[n](o),void 0===a)throw new t.Exceptions.ConfigurationError(n,o);h[n]=a}if(h.connection_recovery_max_interval<h.connection_recovery_min_interval)throw new t.Exceptions.ConfigurationError("connection_recovery_max_interval",h.connection_recovery_max_interval);0===h.display_name&&(h.display_name="0"),h.instance_id=t.Utils.newUUID(),h.jssip_id=t.Utils.createRandomToken(5),c=h.uri.clone(),c.user=null,h.hostport_params=(""+c).replace(/^sip:/i,""),h.authorization_user||(h.authorization_user=h.uri.user),h.registrar_server||(u=h.uri.clone(),u.user=null,h.registrar_server=u),h.no_answer_timeout=1e3*h.no_answer_timeout,h.hack_ip_in_contact&&(h.via_host=t.Utils.getRandomTestNetIP()),this.contact={pub_gruu:null,temp_gruu:null,uri:new t.URI("sip",t.Utils.createRandomToken(8),h.via_host,null,{transport:"ws"}),toString:function(e){e=e||{};var t=e.anonymous||null,s=e.outbound||null,i="<";return i+=t?this.temp_gruu||"sip:anonymous@anonymous.invalid;transport=ws":this.pub_gruu||""+this.uri,s&&(i+=";ob"),i+=">"}},console.log(i+"configuration parameters after validation:");for(n in h){switch(n){case"uri":case"registrar_server":console.log("· "+n+": "+h[n]);break;default:console.log("· "+n+": "+e.JSON.stringify(h[n]))}s.configuration_skeleton[n].value=h[n]}Object.defineProperties(this.configuration,s.configuration_skeleton);for(n in h)s.configuration_skeleton[n].value=""},s.configuration_skeleton=function(){var e,t,s={},i=["instance_id","jssip_id","register_min_expires","ws_server_max_reconnection","ws_server_reconnection_timeout","hostport_params","uri","ws_servers","authorization_user","connection_recovery_max_interval","connection_recovery_min_interval","display_name","hack_via_tcp","hack_ip_in_contact","no_answer_timeout","password","register_expires","registrar_server","stun_servers","trace_sip","turn_servers","use_preloaded_route","via_core_value","via_host"];for(e in i)t=i[e],s[t]={value:"",writable:!1,configurable:!1};return s.register={value:"",writable:!0,configurable:!1},s}(),s.configuration_check={mandatory:{uri:function(e){var s;return/^sip:/i.test(e)||(e=t.C.SIP+":"+e),s=t.URI.parse(e),s?s.user?s:void 0:void 0},ws_servers:function(e){var s,r;if("string"==typeof e)e=[{ws_uri:e}];else{if(!(e instanceof Array))return;for(s in e)"string"==typeof e[s]&&(e[s]={ws_uri:e[s]})}if(0===e.length)return!1;for(s in e){if(!e[s].ws_uri)return console.error(i+'missing "ws_uri" attribute in ws_servers parameter'),void 0;if(e[s].weight&&!Number(e[s].weight))return console.error(i+'"weight" attribute in ws_servers parameter must be a Number'),void 0;if(r=t.Grammar.parse(e[s].ws_uri,"absoluteURI"),-1===r)return console.error(i+'invalid "ws_uri" attribute in ws_servers parameter: '+e[s].ws_uri),void 0;if("wss"!==r.scheme&&"ws"!==r.scheme)return console.error(i+"invalid URI scheme in ws_servers parameter: "+r.scheme),void 0;e[s].sip_uri="<sip:"+r.host+(r.port?":"+r.port:"")+";transport=ws;lr>",e[s].weight||(e[s].weight=0),e[s].status=0,e[s].scheme=r.scheme.toUpperCase()}return e}},optional:{authorization_user:function(e){return-1===t.Grammar.parse('"'+e+'"',"quoted_string")?void 0:e},connection_recovery_max_interval:function(s){var i;return t.Utils.isDecimal(s)&&(i=e.Number(s),i>0)?i:void 0},connection_recovery_min_interval:function(s){var i;return t.Utils.isDecimal(s)&&(i=e.Number(s),i>0)?i:void 0},display_name:function(e){return-1===t.Grammar.parse('"'+e+'"',"display_name")?void 0:e},hack_via_tcp:function(e){return"boolean"==typeof e?e:void 0},hack_ip_in_contact:function(e){return"boolean"==typeof e?e:void 0},no_answer_timeout:function(s){var i;return t.Utils.isDecimal(s)&&(i=e.Number(s),i>0)?i:void 0},password:function(e){return e+""},register:function(e){return"boolean"==typeof e?e:void 0},register_expires:function(s){var i;return t.Utils.isDecimal(s)&&(i=e.Number(s),i>0)?i:void 0},registrar_server:function(e){var s;return/^sip:/i.test(e)||(e=t.C.SIP+":"+e),s=t.URI.parse(e),s?s.user?void 0:s:void 0},stun_servers:function(e){var s,i;if("string"==typeof e)e=[e];else if(!(e instanceof Array))return;for(s in e){if(i=e[s],/^stuns?:/.test(i)||(i="stun:"+i),-1===t.Grammar.parse(i,"stun_URI"))return;e[s]=i}return e},trace_sip:function(e){return"boolean"==typeof e?e:void 0},turn_servers:function(e){var s,i;e instanceof Array||(e=[e]);for(s in e){if(i=e[s],!(i.server&&i.username&&i.password))return;if(/^turns?:/.test(i.server)||(i.server="turn:"+i.server),-1===t.Grammar.parse(i.server,"turn_URI"))return;if(-1===t.Grammar.parse(i.username,"user"))return;if(-1===t.Grammar.parse(i.password,"password"))return}return e},use_preloaded_route:function(e){return"boolean"==typeof e?e:void 0}}},s.C=r,t.UA=s}(t),function(t){var s;s={str_utf8_length:function(t){return e.unescape(encodeURIComponent(t)).length},isFunction:function(e){return void 0!==e?"[object Function]"===Object.prototype.toString.call(e)?!0:!1:!1},isDecimal:function(e){return!isNaN(e)&&parseFloat(e)===parseInt(e,10)},createRandomToken:function(e,t){var s,i,r="";for(t=t||32,s=0;e>s;s++)i=0|Math.random()*t,r+=i.toString(t);return r},newTag:function(){return t.Utils.createRandomToken(t.UA.C.TAG_LENGTH)},newUUID:function(){var e="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=0|16*Math.random(),s="x"===e?t:8|3&t;return s.toString(16)});return e},hostType:function(e){return e?(e=t.Grammar.parse(e,"host"),-1!==e?e.host_type:void 0):void 0},normalizeURI:function(e,s){var i,r,n,o,a=e;if(e){if(e instanceof t.URI)return e;if("string"==typeof e){switch(r=e.split("@"),r.length){case 1:if(!s)throw new t.Exceptions.InvalidTargetError(a);n=e,o=s;break;case 2:n=r[0],o=r[1];break;default:n=r.slice(0,r.length-1).join("@"),o=r[r.length-1]}if(n=n.replace(/^(sips?|tel):/i,""),/^[\-\.\(\)]*\+?[0-9\-\.\(\)]+$/.test(n)&&(n=n.replace(/[\-\.\(\)]/g,"")),e=t.C.SIP+":"+t.Utils.escapeUser(n)+"@"+o,i=t.URI.parse(e))return i;throw new t.Exceptions.InvalidTargetError(a)}throw new t.Exceptions.InvalidTargetError(a)}throw new t.Exceptions.InvalidTargetError(a)},escapeUser:function(t){return e.encodeURIComponent(e.decodeURIComponent(t)).replace(/%3A/gi,":").replace(/%2B/gi,"+").replace(/%3F/gi,"?").replace(/%2F/gi,"/")},headerize:function(e){var t,s={"Call-Id":"Call-ID",Cseq:"CSeq","Www-Authenticate":"WWW-Authenticate"},i=e.toLowerCase().replace(/_/g,"-").split("-"),r="";for(t in i)"0"!==t&&(r+="-"),r+=i[t].charAt(0).toUpperCase()+i[t].substring(1);return s[r]&&(r=s[r]),r},sipErrorCause:function(e){var s;for(s in t.C.SIP_ERROR_CAUSES)if(-1!==t.C.SIP_ERROR_CAUSES[s].indexOf(e))return t.C.causes[s];return t.C.causes.SIP_FAILURE_CODE},getRandomTestNetIP:function(){function t(t,s){return e.Math.floor(e.Math.random()*(s-t+1)+t)}return"192.0.2."+t(1,254)},getAllowedMethods:function(e){var s,i=""+t.UA.C.ALLOWED_METHODS;for(s in t.UA.C.EVENT_METHODS)e.checkEvent(s)&&e.listeners(s).length>0&&(i+=","+t.UA.C.EVENT_METHODS[s]);return i},calculateMD5:function(e){function t(e,t){return e<<t|e>>>32-t}function s(e,t){var s,i,r,n,o;return r=2147483648&e,n=2147483648&t,s=1073741824&e,i=1073741824&t,o=(1073741823&e)+(1073741823&t),s&i?2147483648^o^r^n:s|i?1073741824&o?3221225472^o^r^n:1073741824^o^r^n:o^r^n}function i(e,t,s){return e&t|~e&s}function r(e,t,s){return e&s|t&~s}function n(e,t,s){return e^t^s}function o(e,t,s){return t^(e|~s)}function a(e,r,n,o,a,c,u){return e=s(e,s(s(i(r,n,o),a),u)),s(t(e,c),r)}function c(e,i,n,o,a,c,u){return e=s(e,s(s(r(i,n,o),a),u)),s(t(e,c),i)}function u(e,i,r,o,a,c,u){return e=s(e,s(s(n(i,r,o),a),u)),s(t(e,c),i)}function h(e,i,r,n,a,c,u){return e=s(e,s(s(o(i,r,n),a),u)),s(t(e,c),i)}function l(e){for(var t,s=e.length,i=s+8,r=(i-i%64)/64,n=16*(r+1),o=Array(n-1),a=0,c=0;s>c;)t=(c-c%4)/4,a=8*(c%4),o[t]=o[t]|e.charCodeAt(c)<<a,c++;return t=(c-c%4)/4,a=8*(c%4),o[t]=o[t]|128<<a,o[n-2]=s<<3,o[n-1]=s>>>29,o}function d(e){var t,s,i="",r="";for(s=0;3>=s;s++)t=255&e>>>8*s,r="0"+t.toString(16),i+=r.substr(r.length-2,2);return i}function p(e){e=e.replace(/\r\n/g,"\n");for(var t="",s=0;e.length>s;s++){var i=e.charCodeAt(s);128>i?t+=String.fromCharCode(i):i>127&&2048>i?(t+=String.fromCharCode(192|i>>6),t+=String.fromCharCode(128|63&i)):(t+=String.fromCharCode(224|i>>12),t+=String.fromCharCode(128|63&i>>6),t+=String.fromCharCode(128|63&i))}return t}var T,_,f,m,g,E,S,v,R,C=[],A=7,I=12,w=17,N=22,y=5,U=9,D=14,O=20,q=4,b=11,M=16,P=23,x=6,H=10,L=15,k=21;for(e=p(e),C=l(e),E=1732584193,S=4023233417,v=2562383102,R=271733878,T=0;C.length>T;T+=16)_=E,f=S,m=v,g=R,E=a(E,S,v,R,C[T+0],A,3614090360),R=a(R,E,S,v,C[T+1],I,3905402710),v=a(v,R,E,S,C[T+2],w,606105819),S=a(S,v,R,E,C[T+3],N,3250441966),E=a(E,S,v,R,C[T+4],A,4118548399),R=a(R,E,S,v,C[T+5],I,1200080426),v=a(v,R,E,S,C[T+6],w,2821735955),S=a(S,v,R,E,C[T+7],N,4249261313),E=a(E,S,v,R,C[T+8],A,1770035416),R=a(R,E,S,v,C[T+9],I,2336552879),v=a(v,R,E,S,C[T+10],w,4294925233),S=a(S,v,R,E,C[T+11],N,2304563134),E=a(E,S,v,R,C[T+12],A,1804603682),R=a(R,E,S,v,C[T+13],I,4254626195),v=a(v,R,E,S,C[T+14],w,2792965006),S=a(S,v,R,E,C[T+15],N,1236535329),E=c(E,S,v,R,C[T+1],y,4129170786),R=c(R,E,S,v,C[T+6],U,3225465664),v=c(v,R,E,S,C[T+11],D,643717713),S=c(S,v,R,E,C[T+0],O,3921069994),E=c(E,S,v,R,C[T+5],y,3593408605),R=c(R,E,S,v,C[T+10],U,38016083),v=c(v,R,E,S,C[T+15],D,3634488961),S=c(S,v,R,E,C[T+4],O,3889429448),E=c(E,S,v,R,C[T+9],y,568446438),R=c(R,E,S,v,C[T+14],U,3275163606),v=c(v,R,E,S,C[T+3],D,4107603335),S=c(S,v,R,E,C[T+8],O,1163531501),E=c(E,S,v,R,C[T+13],y,2850285829),R=c(R,E,S,v,C[T+2],U,4243563512),v=c(v,R,E,S,C[T+7],D,1735328473),S=c(S,v,R,E,C[T+12],O,2368359562),E=u(E,S,v,R,C[T+5],q,4294588738),R=u(R,E,S,v,C[T+8],b,2272392833),v=u(v,R,E,S,C[T+11],M,1839030562),S=u(S,v,R,E,C[T+14],P,4259657740),E=u(E,S,v,R,C[T+1],q,2763975236),R=u(R,E,S,v,C[T+4],b,1272893353),v=u(v,R,E,S,C[T+7],M,4139469664),S=u(S,v,R,E,C[T+10],P,3200236656),E=u(E,S,v,R,C[T+13],q,681279174),R=u(R,E,S,v,C[T+0],b,3936430074),v=u(v,R,E,S,C[T+3],M,3572445317),S=u(S,v,R,E,C[T+6],P,76029189),E=u(E,S,v,R,C[T+9],q,3654602809),R=u(R,E,S,v,C[T+12],b,3873151461),v=u(v,R,E,S,C[T+15],M,530742520),S=u(S,v,R,E,C[T+2],P,3299628645),E=h(E,S,v,R,C[T+0],x,4096336452),R=h(R,E,S,v,C[T+7],H,1126891415),v=h(v,R,E,S,C[T+14],L,2878612391),S=h(S,v,R,E,C[T+5],k,4237533241),E=h(E,S,v,R,C[T+12],x,1700485571),R=h(R,E,S,v,C[T+3],H,2399980690),v=h(v,R,E,S,C[T+10],L,4293915773),S=h(S,v,R,E,C[T+1],k,2240044497),E=h(E,S,v,R,C[T+8],x,1873313359),R=h(R,E,S,v,C[T+15],H,4264355552),v=h(v,R,E,S,C[T+6],L,2734768916),S=h(S,v,R,E,C[T+13],k,1309151649),E=h(E,S,v,R,C[T+4],x,4149444226),R=h(R,E,S,v,C[T+11],H,3174756917),v=h(v,R,E,S,C[T+2],L,718787259),S=h(S,v,R,E,C[T+9],k,3951481745),E=s(E,_),S=s(S,f),v=s(v,m),R=s(R,g);var G=d(E)+d(S)+d(v)+d(R);return G.toLowerCase()}},t.Utils=s}(t),function(e){function t(){return"sip"!==l.s("to").uri.scheme?(u(416),!1):void 0}function s(){return l.to_tag||l.call_id.substr(0,5)!==d.configuration.jssip_id?void 0:(u(482),!1)}function i(){var t=e.Utils.str_utf8_length(l.body),s=l.getHeader("content-length");return s>t?(u(400),!1):void 0}function r(){var t,s,i=l.from_tag,r=l.call_id,n=l.cseq;if(!l.to_tag)if(l.method===e.C.INVITE){if(t=d.transactions.ist[l.via_branch],!t)return;for(s in d.transactions.ist)if(t=d.transactions.ist[s],t.request.from_tag===i&&t.request.call_id===r&&t.request.cseq===n)return u(482),!1}else{if(t=d.transactions.nist[l.via_branch],!t)return;for(s in d.transactions.nist)if(t=d.transactions.nist[s],t.request.from_tag===i&&t.request.call_id===r&&t.request.cseq===n)return u(482),!1}}function n(){return l.countHeader("via")>1?(console.warn(T+"More than one Via header field present in the response. Dropping the response"),!1):void 0}function o(){var e=d.configuration.via_host;return l.via.host!==e?(console.warn(T+"Via host in the response does not match UA Via host value. Dropping the response"),!1):void 0}function a(){var t=e.Utils.str_utf8_length(l.body),s=l.getHeader("content-length");return s>t?(console.warn(T+"Message body length is lower than the value in Content-Length header field. Dropping the response"),!1):void 0}function c(){for(var e=["from","to","call_id","cseq","via"],t=e.length;t--;)if(!l.hasHeader(e[t]))return console.warn(T+"Missing mandatory header field : "+e[t]+". Dropping the response"),!1}function u(t){var s,i="SIP/2.0 "+t+" "+e.C.REASON_PHRASE[t]+"\r\n",r=l.countHeader("via"),n=0;for(n;r>n;n++)i+="Via: "+l.getHeader("via",n)+"\r\n";s=l.getHeader("To"),l.to_tag||(s+=";tag="+e.Utils.newTag()),i+="To: "+s+"\r\n",i+="From: "+l.getHeader("From")+"\r\n",i+="Call-ID: "+l.call_id+"\r\n",i+="CSeq: "+l.cseq+" "+l.method+"\r\n",i+="\r\n",p.send(i)}var h,l,d,p,T=e.name+" | "+"SANITY CHECK"+" | ",_=[],f=[],m=[];_.push(t),_.push(s),_.push(i),_.push(r),f.push(n),f.push(o),f.push(a),m.push(c),h=function(t,s,i){var r,n;for(l=t,d=s,p=i,r=m.length;r--;)if(n=m[r](l),n===!1)return!1;if(l instanceof e.IncomingRequest){for(r=_.length;r--;)if(n=_[r](l),n===!1)return!1}else if(l instanceof e.IncomingResponse)for(r=f.length;r--;)if(n=f[r](l),n===!1)return!1;return!0},e.sanityCheck=h}(t),function(e){var t,s=e.name+" | "+"DIGEST AUTHENTICATION"+" | ";t=function(e){this.username=e.configuration.authorization_user,this.password=e.configuration.password,this.cnonce=null,this.nc=0,this.ncHex="00000000",this.response=null},t.prototype.authenticate=function(t,i){if(this.algorithm=i.algorithm,this.realm=i.realm,this.nonce=i.nonce,this.opaque=i.opaque,this.stale=i.stale,this.algorithm){if("MD5"!==this.algorithm)return console.warn(s+'challenge with Digest algorithm different than "MD5", authentication aborted'),!1}else this.algorithm="MD5";if(!this.realm)return console.warn(s+"challenge without Digest realm, authentication aborted"),!1;if(!this.nonce)return console.warn(s+"challenge without Digest nonce, authentication aborted"),!1;if(i.qop)if(i.qop.indexOf("auth")>-1)this.qop="auth";else{if(!(i.qop.indexOf("auth-int")>-1))return console.warn(s+'challenge without Digest qop different than "auth" or "auth-int", authentication aborted'),!1;this.qop="auth-int"}else this.qop=null;return this.method=t.method,this.uri=t.ruri,this.cnonce=e.Utils.createRandomToken(12),this.nc+=1,this.updateNcHex(),4294967296===this.nc&&(this.nc=1,this.ncHex="00000001"),this.calculateResponse(),!0},t.prototype.calculateResponse=function(){var t,s;t=e.Utils.calculateMD5(this.username+":"+this.realm+":"+this.password),"auth"===this.qop?(s=e.Utils.calculateMD5(this.method+":"+this.uri),this.response=e.Utils.calculateMD5(t+":"+this.nonce+":"+this.ncHex+":"+this.cnonce+":auth:"+s)):"auth-int"===this.qop?(s=e.Utils.calculateMD5(this.method+":"+this.uri+":"+e.Utils.calculateMD5(this.body?this.body:"")),this.response=e.Utils.calculateMD5(t+":"+this.nonce+":"+this.ncHex+":"+this.cnonce+":auth-int:"+s)):null===this.qop&&(s=e.Utils.calculateMD5(this.method+":"+this.uri),this.response=e.Utils.calculateMD5(t+":"+this.nonce+":"+s))},t.prototype.toString=function(){var e=[];if(!this.response)throw Error("response field does not exist, cannot generate Authorization header");return e.push("algorithm="+this.algorithm),e.push('username="'+this.username+'"'),e.push('realm="'+this.realm+'"'),e.push('nonce="'+this.nonce+'"'),e.push('uri="'+this.uri+'"'),e.push('response="'+this.response+'"'),this.opaque&&e.push('opaque="'+this.opaque+'"'),this.qop&&(e.push("qop="+this.qop),e.push('cnonce="'+this.cnonce+'"'),e.push("nc="+this.ncHex)),"Digest "+e.join(", ")},t.prototype.updateNcHex=function(){var e=Number(this.nc).toString(16);this.ncHex="00000000".substr(0,8-e.length)+e},e.DigestAuthentication=t}(t),function(t){var s;s={},e.navigator.webkitGetUserMedia?s.getUserMedia=e.navigator.webkitGetUserMedia.bind(navigator):e.navigator.mozGetUserMedia?s.getUserMedia=e.navigator.mozGetUserMedia.bind(navigator):e.navigator.getUserMedia&&(s.getUserMedia=e.navigator.getUserMedia.bind(navigator)),e.webkitRTCPeerConnection?s.RTCPeerConnection=e.webkitRTCPeerConnection:e.mozRTCPeerConnection?s.RTCPeerConnection=e.mozRTCPeerConnection:e.RTCPeerConnection&&(s.RTCPeerConnection=e.RTCPeerConnection),e.webkitRTCSessionDescription?s.RTCSessionDescription=e.webkitRTCSessionDescription:e.mozRTCSessionDescription?s.RTCSessionDescription=e.mozRTCSessionDescription:e.RTCSessionDescription&&(s.RTCSessionDescription=e.RTCSessionDescription),s.RTCPeerConnection&&s.RTCPeerConnection.prototype&&(s.RTCPeerConnection.prototype.getLocalStreams||(s.RTCPeerConnection.prototype.getLocalStreams=function(){return this.localStreams},s.RTCPeerConnection.prototype.getRemoteStreams=function(){return this.remoteStreams})),s.isSupported=s.getUserMedia&&s.RTCPeerConnection&&s.RTCSessionDescription?!0:!1,t.WebRTC=s}(t),e.JsSIP=t})(window);
JsSIP.Grammar=function(){function pb(e){return'"'+e.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\x08/g,"\\b").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\f/g,"\\f").replace(/\r/g,"\\r").replace(/[\x00-\x07\x0B\x0E-\x1F\x80-\uFFFF]/g,escape)+'"'}var L={parse:function(e,E){var qb,ga;function g(a){b<Q||(b>Q&&(Q=b,Ha=[]),Ha.push(a))}function L(){var a;"\r\n"===e.substr(b,2)?(a="\r\n",b+=2):(a=null,0===f&&g('"\\r\\n"'));return a}function s(){var a;/^[0-9]/.test(e.charAt(b))?(a=e.charAt(b),
b++):(a=null,0===f&&g("[0-9]"));return a}function R(){var a;/^[a-zA-Z]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[a-zA-Z]"));return a}function H(){var a;/^[0-9a-fA-F]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[0-9a-fA-F]"));return a}function S(){var a;a=B();null===a&&(a=I());return a}function Ia(){var a;/^[\0-\xFF]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[\\0-\\xFF]"));return a}function F(){var a;/^["]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===
f&&g('["]'));return a}function B(){var a;32===e.charCodeAt(b)?(a=" ",b++):(a=null,0===f&&g('" "'));return a}function I(){var a;9===e.charCodeAt(b)?(a="\t",b++):(a=null,0===f&&g('"\\t"'));return a}function G(){var a;/^[a-zA-Z0-9]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[a-zA-Z0-9]"));return a}function ha(){var a;59===e.charCodeAt(b)?(a=";",b++):(a=null,0===f&&g('";"'));null===a&&(47===e.charCodeAt(b)?(a="/",b++):(a=null,0===f&&g('"/"')),null===a&&(63===e.charCodeAt(b)?(a="?",b++):
(a=null,0===f&&g('"?"')),null===a&&(58===e.charCodeAt(b)?(a=":",b++):(a=null,0===f&&g('":"')),null===a&&(64===e.charCodeAt(b)?(a="@",b++):(a=null,0===f&&g('"@"')),null===a&&(38===e.charCodeAt(b)?(a="&",b++):(a=null,0===f&&g('"&"')),null===a&&(61===e.charCodeAt(b)?(a="=",b++):(a=null,0===f&&g('"="')),null===a&&(43===e.charCodeAt(b)?(a="+",b++):(a=null,0===f&&g('"+"')),null===a&&(36===e.charCodeAt(b)?(a="$",b++):(a=null,0===f&&g('"$"')),null===a&&(44===e.charCodeAt(b)?(a=",",b++):(a=null,0===f&&g('","')))))))))));
return a}function y(){var a;a=G();null===a&&(a=rb());return a}function rb(){var a;45===e.charCodeAt(b)?(a="-",b++):(a=null,0===f&&g('"-"'));null===a&&(95===e.charCodeAt(b)?(a="_",b++):(a=null,0===f&&g('"_"')),null===a&&(46===e.charCodeAt(b)?(a=".",b++):(a=null,0===f&&g('"."')),null===a&&(33===e.charCodeAt(b)?(a="!",b++):(a=null,0===f&&g('"!"')),null===a&&(126===e.charCodeAt(b)?(a="~",b++):(a=null,0===f&&g('"~"')),null===a&&(42===e.charCodeAt(b)?(a="*",b++):(a=null,0===f&&g('"*"')),null===a&&(39===
e.charCodeAt(b)?(a="'",b++):(a=null,0===f&&g('"\'"')),null===a&&(40===e.charCodeAt(b)?(a="(",b++):(a=null,0===f&&g('"("')),null===a&&(41===e.charCodeAt(b)?(a=")",b++):(a=null,0===f&&g('")"'))))))))));return a}function z(){var a,c,d,h;h=b;37===e.charCodeAt(b)?(a="%",b++):(a=null,0===f&&g('"%"'));null!==a?(c=H(),null!==c?(d=H(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function A(){var a,c,d,h,e;d=e=h=b;a=[];for(c=S();null!==c;)a.push(c),c=S();null!==a?(c=L(),null!==c?a=[a,
c]:(a=null,b=d)):(a=null,b=d);a=null!==a?a:"";if(null!==a){d=S();if(null!==d)for(c=[];null!==d;)c.push(d),d=S();else c=null;null!==c?a=[a,c]:(a=null,b=e)}else a=null,b=e;null!==a&&(a=" ");null===a&&(b=h);return a}function u(){var a;a=A();return null!==a?a:""}function sb(){var a,c,d,h,j;j=h=b;a=[];c=B();for(null===c&&(c=I());null!==c;)a.push(c),c=B(),null===c&&(c=I());null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):
(a=null,b=j);null!==a&&(a=":");null===a&&(b=h);return a}function tb(){var a,c,d,h,j,g,f;g=j=b;c=J();if(null!==c)for(a=[];null!==c;)a.push(c),c=J();else a=null;if(null!==a){c=[];f=b;d=[];for(h=A();null!==h;)d.push(h),h=A();null!==d?(h=J(),null!==h?d=[d,h]:(d=null,b=f)):(d=null,b=f);for(;null!==d;){c.push(d);f=b;d=[];for(h=A();null!==h;)d.push(h),h=A();null!==d?(h=J(),null!==h?d=[d,h]:(d=null,b=f)):(d=null,b=f)}null!==c?a=[a,c]:(a=null,b=g)}else a=null,b=g;null!==a&&(a=e.substring(b,j));null===a&&(b=
j);return a}function J(){var a;/^[!-~]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[!-~]"));null===a&&(a=M());return a}function M(){var a;/^[\x80-\uFFFF]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[\\x80-\\uFFFF]"));return a}function T(){var a;/^[\x80-\xBF]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[\\x80-\\xBF]"));return a}function t(){var a,c,d;d=b;c=G();null===c&&(45===e.charCodeAt(b)?(c="-",b++):(c=null,0===f&&g('"-"')),null===c&&(46===e.charCodeAt(b)?
(c=".",b++):(c=null,0===f&&g('"."')),null===c&&(33===e.charCodeAt(b)?(c="!",b++):(c=null,0===f&&g('"!"')),null===c&&(37===e.charCodeAt(b)?(c="%",b++):(c=null,0===f&&g('"%"')),null===c&&(42===e.charCodeAt(b)?(c="*",b++):(c=null,0===f&&g('"*"')),null===c&&(95===e.charCodeAt(b)?(c="_",b++):(c=null,0===f&&g('"_"')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=null,0===f&&g('"+"')),null===c&&(96===e.charCodeAt(b)?(c="`",b++):(c=null,0===f&&g('"`"')),null===c&&(39===e.charCodeAt(b)?(c="'",b++):(c=null,
0===f&&g('"\'"')),null===c&&(126===e.charCodeAt(b)?(c="~",b++):(c=null,0===f&&g('"~"'))))))))))));if(null!==c)for(a=[];null!==c;)a.push(c),c=G(),null===c&&(45===e.charCodeAt(b)?(c="-",b++):(c=null,0===f&&g('"-"')),null===c&&(46===e.charCodeAt(b)?(c=".",b++):(c=null,0===f&&g('"."')),null===c&&(33===e.charCodeAt(b)?(c="!",b++):(c=null,0===f&&g('"!"')),null===c&&(37===e.charCodeAt(b)?(c="%",b++):(c=null,0===f&&g('"%"')),null===c&&(42===e.charCodeAt(b)?(c="*",b++):(c=null,0===f&&g('"*"')),null===c&&(95===
e.charCodeAt(b)?(c="_",b++):(c=null,0===f&&g('"_"')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=null,0===f&&g('"+"')),null===c&&(96===e.charCodeAt(b)?(c="`",b++):(c=null,0===f&&g('"`"')),null===c&&(39===e.charCodeAt(b)?(c="'",b++):(c=null,0===f&&g('"\'"')),null===c&&(126===e.charCodeAt(b)?(c="~",b++):(c=null,0===f&&g('"~"'))))))))))));else a=null;null!==a&&(a=e.substring(b,d));null===a&&(b=d);return a}function ia(){var a,c,d;d=b;c=G();null===c&&(45===e.charCodeAt(b)?(c="-",b++):(c=null,0===f&&
g('"-"')),null===c&&(33===e.charCodeAt(b)?(c="!",b++):(c=null,0===f&&g('"!"')),null===c&&(37===e.charCodeAt(b)?(c="%",b++):(c=null,0===f&&g('"%"')),null===c&&(42===e.charCodeAt(b)?(c="*",b++):(c=null,0===f&&g('"*"')),null===c&&(95===e.charCodeAt(b)?(c="_",b++):(c=null,0===f&&g('"_"')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=null,0===f&&g('"+"')),null===c&&(96===e.charCodeAt(b)?(c="`",b++):(c=null,0===f&&g('"`"')),null===c&&(39===e.charCodeAt(b)?(c="'",b++):(c=null,0===f&&g('"\'"')),null===
c&&(126===e.charCodeAt(b)?(c="~",b++):(c=null,0===f&&g('"~"')))))))))));if(null!==c)for(a=[];null!==c;)a.push(c),c=G(),null===c&&(45===e.charCodeAt(b)?(c="-",b++):(c=null,0===f&&g('"-"')),null===c&&(33===e.charCodeAt(b)?(c="!",b++):(c=null,0===f&&g('"!"')),null===c&&(37===e.charCodeAt(b)?(c="%",b++):(c=null,0===f&&g('"%"')),null===c&&(42===e.charCodeAt(b)?(c="*",b++):(c=null,0===f&&g('"*"')),null===c&&(95===e.charCodeAt(b)?(c="_",b++):(c=null,0===f&&g('"_"')),null===c&&(43===e.charCodeAt(b)?(c="+",
b++):(c=null,0===f&&g('"+"')),null===c&&(96===e.charCodeAt(b)?(c="`",b++):(c=null,0===f&&g('"`"')),null===c&&(39===e.charCodeAt(b)?(c="'",b++):(c=null,0===f&&g('"\'"')),null===c&&(126===e.charCodeAt(b)?(c="~",b++):(c=null,0===f&&g('"~"')))))))))));else a=null;null!==a&&(a=e.substring(b,d));null===a&&(b=d);return a}function Ja(){var a,c,d;d=b;c=G();null===c&&(45===e.charCodeAt(b)?(c="-",b++):(c=null,0===f&&g('"-"')),null===c&&(46===e.charCodeAt(b)?(c=".",b++):(c=null,0===f&&g('"."')),null===c&&(33===
e.charCodeAt(b)?(c="!",b++):(c=null,0===f&&g('"!"')),null===c&&(37===e.charCodeAt(b)?(c="%",b++):(c=null,0===f&&g('"%"')),null===c&&(42===e.charCodeAt(b)?(c="*",b++):(c=null,0===f&&g('"*"')),null===c&&(95===e.charCodeAt(b)?(c="_",b++):(c=null,0===f&&g('"_"')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=null,0===f&&g('"+"')),null===c&&(96===e.charCodeAt(b)?(c="`",b++):(c=null,0===f&&g('"`"')),null===c&&(39===e.charCodeAt(b)?(c="'",b++):(c=null,0===f&&g('"\'"')),null===c&&(126===e.charCodeAt(b)?
(c="~",b++):(c=null,0===f&&g('"~"')),null===c&&(40===e.charCodeAt(b)?(c="(",b++):(c=null,0===f&&g('"("')),null===c&&(41===e.charCodeAt(b)?(c=")",b++):(c=null,0===f&&g('")"')),null===c&&(60===e.charCodeAt(b)?(c="<",b++):(c=null,0===f&&g('"<"')),null===c&&(62===e.charCodeAt(b)?(c=">",b++):(c=null,0===f&&g('">"')),null===c&&(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null===c&&(92===e.charCodeAt(b)?(c="\\",b++):(c=null,0===f&&g('"\\\\"')),null===c&&(c=F(),null===c&&(47===e.charCodeAt(b)?
(c="/",b++):(c=null,0===f&&g('"/"')),null===c&&(91===e.charCodeAt(b)?(c="[",b++):(c=null,0===f&&g('"["')),null===c&&(93===e.charCodeAt(b)?(c="]",b++):(c=null,0===f&&g('"]"')),null===c&&(63===e.charCodeAt(b)?(c="?",b++):(c=null,0===f&&g('"?"')),null===c&&(123===e.charCodeAt(b)?(c="{",b++):(c=null,0===f&&g('"{"')),null===c&&(125===e.charCodeAt(b)?(c="}",b++):(c=null,0===f&&g('"}"')))))))))))))))))))))))));if(null!==c)for(a=[];null!==c;)a.push(c),c=G(),null===c&&(45===e.charCodeAt(b)?(c="-",b++):(c=
null,0===f&&g('"-"')),null===c&&(46===e.charCodeAt(b)?(c=".",b++):(c=null,0===f&&g('"."')),null===c&&(33===e.charCodeAt(b)?(c="!",b++):(c=null,0===f&&g('"!"')),null===c&&(37===e.charCodeAt(b)?(c="%",b++):(c=null,0===f&&g('"%"')),null===c&&(42===e.charCodeAt(b)?(c="*",b++):(c=null,0===f&&g('"*"')),null===c&&(95===e.charCodeAt(b)?(c="_",b++):(c=null,0===f&&g('"_"')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=null,0===f&&g('"+"')),null===c&&(96===e.charCodeAt(b)?(c="`",b++):(c=null,0===f&&g('"`"')),
null===c&&(39===e.charCodeAt(b)?(c="'",b++):(c=null,0===f&&g('"\'"')),null===c&&(126===e.charCodeAt(b)?(c="~",b++):(c=null,0===f&&g('"~"')),null===c&&(40===e.charCodeAt(b)?(c="(",b++):(c=null,0===f&&g('"("')),null===c&&(41===e.charCodeAt(b)?(c=")",b++):(c=null,0===f&&g('")"')),null===c&&(60===e.charCodeAt(b)?(c="<",b++):(c=null,0===f&&g('"<"')),null===c&&(62===e.charCodeAt(b)?(c=">",b++):(c=null,0===f&&g('">"')),null===c&&(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null===c&&(92===
e.charCodeAt(b)?(c="\\",b++):(c=null,0===f&&g('"\\\\"')),null===c&&(c=F(),null===c&&(47===e.charCodeAt(b)?(c="/",b++):(c=null,0===f&&g('"/"')),null===c&&(91===e.charCodeAt(b)?(c="[",b++):(c=null,0===f&&g('"["')),null===c&&(93===e.charCodeAt(b)?(c="]",b++):(c=null,0===f&&g('"]"')),null===c&&(63===e.charCodeAt(b)?(c="?",b++):(c=null,0===f&&g('"?"')),null===c&&(123===e.charCodeAt(b)?(c="{",b++):(c=null,0===f&&g('"{"')),null===c&&(125===e.charCodeAt(b)?(c="}",b++):(c=null,0===f&&g('"}"')))))))))))))))))))))))));
else a=null;null!==a&&(a=e.substring(b,d));null===a&&(b=d);return a}function ub(){var a,c,d,h,j;j=h=b;a=u();null!==a?(42===e.charCodeAt(b)?(c="*",b++):(c=null,0===f&&g('"*"')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a="*");null===a&&(b=h);return a}function ja(){var a,c,d,h,j;j=h=b;a=u();null!==a?(47===e.charCodeAt(b)?(c="/",b++):(c=null,0===f&&g('"/"')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a="/");null===
a&&(b=h);return a}function v(){var a,c,d,h,j;j=h=b;a=u();null!==a?(61===e.charCodeAt(b)?(c="=",b++):(c=null,0===f&&g('"="')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a="=");null===a&&(b=h);return a}function vb(){var a,c,d,h,j;j=h=b;a=u();null!==a?(40===e.charCodeAt(b)?(c="(",b++):(c=null,0===f&&g('"("')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a="(");null===a&&(b=h);return a}function wb(){var a,c,d,h,j;j=
h=b;a=u();null!==a?(41===e.charCodeAt(b)?(c=")",b++):(c=null,0===f&&g('")"')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a=")");null===a&&(b=h);return a}function Ka(){var a,c,d,h;h=d=b;62===e.charCodeAt(b)?(a=">",b++):(a=null,0===f&&g('">"'));null!==a?(c=u(),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==a&&(a=">");null===a&&(b=d);return a}function La(){var a,c,d,h;h=d=b;a=u();null!==a?(60===e.charCodeAt(b)?(c="<",b++):(c=null,0===f&&g('"<"')),null!==
c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==a&&(a="<");null===a&&(b=d);return a}function w(){var a,c,d,h,j;j=h=b;a=u();null!==a?(44===e.charCodeAt(b)?(c=",",b++):(c=null,0===f&&g('","')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a=",");null===a&&(b=h);return a}function x(){var a,c,d,h,j;j=h=b;a=u();null!==a?(59===e.charCodeAt(b)?(c=";",b++):(c=null,0===f&&g('";"')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a=
";");null===a&&(b=h);return a}function xb(){var a,c,d,h,j;j=h=b;a=u();null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=u(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a=":");null===a&&(b=h);return a}function Ma(){var a,c,d,h;h=d=b;a=u();null!==a?(c=F(),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==a&&(a='"');null===a&&(b=d);return a}function Na(){var a,c,d,h;h=d=b;a=F();null!==a?(c=u(),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==
a&&(a='"');null===a&&(b=d);return a}function Oa(){var a,c,d,h;h=b;a=vb();if(null!==a){c=[];d=Pa();null===d&&(d=K(),null===d&&(d=Oa()));for(;null!==d;)c.push(d),d=Pa(),null===d&&(d=K(),null===d&&(d=Oa()));null!==c?(d=wb(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)}else a=null,b=h;return a}function Pa(){var a;/^[!-']/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[!-']"));null===a&&(/^[*-[]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[*-[]")),null===a&&(/^[\]-~]/.test(e.charAt(b))?
(a=e.charAt(b),b++):(a=null,0===f&&g("[\\]-~]")),null===a&&(a=M(),null===a&&(a=A()))));return a}function U(){var a,c,d,h,j,f;f=j=b;a=u();if(null!==a)if(c=F(),null!==c){d=[];h=V();for(null===h&&(h=K());null!==h;)d.push(h),h=V(),null===h&&(h=K());null!==d?(h=F(),null!==h?a=[a,c,d,h]:(a=null,b=f)):(a=null,b=f)}else a=null,b=f;else a=null,b=f;null!==a&&(a=e.substring(b,j));null===a&&(b=j);return a}function ka(){var a,c,d,h,j,f;f=j=b;a=u();if(null!==a)if(c=F(),null!==c){d=[];h=V();for(null===h&&(h=K());null!==
h;)d.push(h),h=V(),null===h&&(h=K());null!==d?(h=F(),null!==h?a=[a,c,d,h]:(a=null,b=f)):(a=null,b=f)}else a=null,b=f;else a=null,b=f;null!==a&&(a=e.substring(b-1,j+1));null===a&&(b=j);return a}function V(){var a;a=A();null===a&&(33===e.charCodeAt(b)?(a="!",b++):(a=null,0===f&&g('"!"')),null===a&&(/^[#-[]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[#-[]")),null===a&&(/^[\]-~]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[\\]-~]")),null===a&&(a=M()))));return a}function K(){var a,
c,d;d=b;92===e.charCodeAt(b)?(a="\\",b++):(a=null,0===f&&g('"\\\\"'));null!==a?(/^[\0-\t]/.test(e.charAt(b))?(c=e.charAt(b),b++):(c=null,0===f&&g("[\\0-\\t]")),null===c&&(/^[\x0B-\f]/.test(e.charAt(b))?(c=e.charAt(b),b++):(c=null,0===f&&g("[\\x0B-\\f]")),null===c&&(/^[\x0E-\u007f]/.test(e.charAt(b))?(c=e.charAt(b),b++):(c=null,0===f&&g("[\\x0E-\u007f]")))),null!==c?a=[a,c]:(a=null,b=d)):(a=null,b=d);return a}function la(){var a,c,d,h,j,l;l=j=b;a=Qa();null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=
null,0===f&&g('":"')),null!==c?(d=ma(),d=null!==d?d:"",null!==d?(h=na(),null!==h?a=[a,c,d,h]:(a=null,b=l)):(a=null,b=l)):(a=null,b=l)):(a=null,b=l);if(null!==a){try{k.uri=new JsSIP.URI(k.scheme,k.user,k.host,k.port),delete k.scheme,delete k.user,delete k.host,delete k.host_type,delete k.port}catch(m){k=-1}a=void 0}null===a&&(b=j);return a}function oa(){var a,c,d,h,j,l,m,q;q=m=b;a=Qa();null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=ma(),d=null!==d?d:"",null!==d?(h=
na(),null!==h?(j=yb(),null!==j?(l=zb(),l=null!==l?l:"",null!==l?a=[a,c,d,h,j,l]:(a=null,b=q)):(a=null,b=q)):(a=null,b=q)):(a=null,b=q)):(a=null,b=q)):(a=null,b=q);if(null!==a){try{k.uri=new JsSIP.URI(k.scheme,k.user,k.host,k.port,k.uri_params,k.uri_headers),delete k.scheme,delete k.user,delete k.host,delete k.host_type,delete k.port,delete k.uri_params,"SIP_URI"===E&&(k=k.uri)}catch(p){k=-1}a=void 0}null===a&&(b=m);return a}function Qa(){var a,c;c=b;"sip"===e.substr(b,3).toLowerCase()?(a=e.substr(b,
3),b+=3):(a=null,0===f&&g('"sip"'));null!==a&&(k.scheme=a.toLowerCase(),a=void 0);null===a&&(b=c);return a}function ma(){var a,c,d,h,j,l;j=h=b;a=Ab();null!==a?(l=b,58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=Bb(),null!==d?c=[c,d]:(c=null,b=l)):(c=null,b=l),c=null!==c?c:"",null!==c?(64===e.charCodeAt(b)?(d="@",b++):(d=null,0===f&&g('"@"')),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.user=window.decodeURIComponent(e.substring(b-1,h)),a=void 0);
null===a&&(b=h);return a}function Ab(){var a,b;b=y();null===b&&(b=z(),null===b&&(b=Ra()));if(null!==b)for(a=[];null!==b;)a.push(b),b=y(),null===b&&(b=z(),null===b&&(b=Ra()));else a=null;return a}function Ra(){var a;38===e.charCodeAt(b)?(a="&",b++):(a=null,0===f&&g('"&"'));null===a&&(61===e.charCodeAt(b)?(a="=",b++):(a=null,0===f&&g('"="')),null===a&&(43===e.charCodeAt(b)?(a="+",b++):(a=null,0===f&&g('"+"')),null===a&&(36===e.charCodeAt(b)?(a="$",b++):(a=null,0===f&&g('"$"')),null===a&&(44===e.charCodeAt(b)?
(a=",",b++):(a=null,0===f&&g('","')),null===a&&(59===e.charCodeAt(b)?(a=";",b++):(a=null,0===f&&g('";"')),null===a&&(63===e.charCodeAt(b)?(a="?",b++):(a=null,0===f&&g('"?"')),null===a&&(47===e.charCodeAt(b)?(a="/",b++):(a=null,0===f&&g('"/"')))))))));return a}function Bb(){var a,c,d;d=b;a=[];c=y();null===c&&(c=z(),null===c&&(38===e.charCodeAt(b)?(c="&",b++):(c=null,0===f&&g('"&"')),null===c&&(61===e.charCodeAt(b)?(c="=",b++):(c=null,0===f&&g('"="')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=
null,0===f&&g('"+"')),null===c&&(36===e.charCodeAt(b)?(c="$",b++):(c=null,0===f&&g('"$"')),null===c&&(44===e.charCodeAt(b)?(c=",",b++):(c=null,0===f&&g('","'))))))));for(;null!==c;)a.push(c),c=y(),null===c&&(c=z(),null===c&&(38===e.charCodeAt(b)?(c="&",b++):(c=null,0===f&&g('"&"')),null===c&&(61===e.charCodeAt(b)?(c="=",b++):(c=null,0===f&&g('"="')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=null,0===f&&g('"+"')),null===c&&(36===e.charCodeAt(b)?(c="$",b++):(c=null,0===f&&g('"$"')),null===c&&(44===
e.charCodeAt(b)?(c=",",b++):(c=null,0===f&&g('","'))))))));null!==a&&(k.password=e.substring(b,d),a=void 0);null===a&&(b=d);return a}function na(){var a,c,d,h,j;h=b;a=W();null!==a?(j=b,58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=Sa(),null!==d?c=[c,d]:(c=null,b=j)):(c=null,b=j),c=null!==c?c:"",null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);return a}function W(){var a,c;c=b;a=Ta();null===a&&(a=N(),null===a&&(a=pa()));null!==a&&(k.host=e.substring(b,c).toLowerCase(),a=k.host);
null===a&&(b=c);return a}function Ta(){var a,c,d,h,j,l;j=h=b;a=[];l=b;c=Ua();null!==c?(46===e.charCodeAt(b)?(d=".",b++):(d=null,0===f&&g('"."')),null!==d?c=[c,d]:(c=null,b=l)):(c=null,b=l);for(;null!==c;)a.push(c),l=b,c=Ua(),null!==c?(46===e.charCodeAt(b)?(d=".",b++):(d=null,0===f&&g('"."')),null!==d?c=[c,d]:(c=null,b=l)):(c=null,b=l);null!==a?(c=Cb(),null!==c?(46===e.charCodeAt(b)?(d=".",b++):(d=null,0===f&&g('"."')),d=null!==d?d:"",null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==
a&&(k.host_type="domain",a=e.substring(b,h));null===a&&(b=h);return a}function Ua(){var a,c;/^[a-zA-Z0-9_\-]/.test(e.charAt(b))?(c=e.charAt(b),b++):(c=null,0===f&&g("[a-zA-Z0-9_\\-]"));if(null!==c)for(a=[];null!==c;)a.push(c),/^[a-zA-Z0-9_\-]/.test(e.charAt(b))?(c=e.charAt(b),b++):(c=null,0===f&&g("[a-zA-Z0-9_\\-]"));else a=null;return a}function Cb(){var a,c;/^[a-zA-Z_\-]/.test(e.charAt(b))?(c=e.charAt(b),b++):(c=null,0===f&&g("[a-zA-Z_\\-]"));if(null!==c)for(a=[];null!==c;)a.push(c),/^[a-zA-Z_\-]/.test(e.charAt(b))?
(c=e.charAt(b),b++):(c=null,0===f&&g("[a-zA-Z_\\-]"));else a=null;return a}function pa(){var a,c,d,h,j;j=h=b;91===e.charCodeAt(b)?(a="[",b++):(a=null,0===f&&g('"["'));null!==a?(c=Va(),null!==c?(93===e.charCodeAt(b)?(d="]",b++):(d=null,0===f&&g('"]"')),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.host_type="IPv6",a=e.substring(b,h));null===a&&(b=h);return a}function Va(){var a,c,d,h,j,l,m,q,p,s,t,u,v,w,n;n=w=b;a=r();null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===
f&&g('":"')),null!==c?(d=r(),null!==d?(58===e.charCodeAt(b)?(h=":",b++):(h=null,0===f&&g('":"')),null!==h?(j=r(),null!==j?(58===e.charCodeAt(b)?(l=":",b++):(l=null,0===f&&g('":"')),null!==l?(m=r(),null!==m?(58===e.charCodeAt(b)?(q=":",b++):(q=null,0===f&&g('":"')),null!==q?(p=r(),null!==p?(58===e.charCodeAt(b)?(s=":",b++):(s=null,0===f&&g('":"')),null!==s?(t=r(),null!==t?(58===e.charCodeAt(b)?(u=":",b++):(u=null,0===f&&g('":"')),null!==u?(v=D(),null!==v?a=[a,c,d,h,j,l,m,q,p,s,t,u,v]:(a=null,b=n)):
(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n);null===a&&(n=b,"::"===e.substr(b,2)?(a="::",b+=2):(a=null,0===f&&g('"::"')),null!==a?(c=r(),null!==c?(58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?(58===e.charCodeAt(b)?(j=":",b++):(j=null,0===f&&g('":"')),null!==j?(l=r(),null!==l?(58===e.charCodeAt(b)?(m=":",b++):(m=null,0===f&&g('":"')),null!==
m?(q=r(),null!==q?(58===e.charCodeAt(b)?(p=":",b++):(p=null,0===f&&g('":"')),null!==p?(s=r(),null!==s?(58===e.charCodeAt(b)?(t=":",b++):(t=null,0===f&&g('":"')),null!==t?(u=D(),null!==u?a=[a,c,d,h,j,l,m,q,p,s,t,u]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,"::"===e.substr(b,2)?(a="::",b+=2):(a=null,0===f&&g('"::"')),null!==a?(c=r(),null!==c?(58===e.charCodeAt(b)?
(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?(58===e.charCodeAt(b)?(j=":",b++):(j=null,0===f&&g('":"')),null!==j?(l=r(),null!==l?(58===e.charCodeAt(b)?(m=":",b++):(m=null,0===f&&g('":"')),null!==m?(q=r(),null!==q?(58===e.charCodeAt(b)?(p=":",b++):(p=null,0===f&&g('":"')),null!==p?(s=D(),null!==s?a=[a,c,d,h,j,l,m,q,p,s]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,"::"===e.substr(b,
2)?(a="::",b+=2):(a=null,0===f&&g('"::"')),null!==a?(c=r(),null!==c?(58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?(58===e.charCodeAt(b)?(j=":",b++):(j=null,0===f&&g('":"')),null!==j?(l=r(),null!==l?(58===e.charCodeAt(b)?(m=":",b++):(m=null,0===f&&g('":"')),null!==m?(q=D(),null!==q?a=[a,c,d,h,j,l,m,q]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,"::"===e.substr(b,2)?(a="::",b+=2):
(a=null,0===f&&g('"::"')),null!==a?(c=r(),null!==c?(58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?(58===e.charCodeAt(b)?(j=":",b++):(j=null,0===f&&g('":"')),null!==j?(l=D(),null!==l?a=[a,c,d,h,j,l]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,"::"===e.substr(b,2)?(a="::",b+=2):(a=null,0===f&&g('"::"')),null!==a?(c=r(),null!==c?(58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=D(),null!==
h?a=[a,c,d,h]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,"::"===e.substr(b,2)?(a="::",b+=2):(a=null,0===f&&g('"::"')),null!==a?(c=D(),null!==c?a=[a,c]:(a=null,b=n)):(a=null,b=n),null===a&&(n=b,"::"===e.substr(b,2)?(a="::",b+=2):(a=null,0===f&&g('"::"')),null!==a?(c=r(),null!==c?a=[a,c]:(a=null,b=n)):(a=null,b=n),null===a&&(n=b,a=r(),null!==a?("::"===e.substr(b,2)?(c="::",b+=2):(c=null,0===f&&g('"::"')),null!==c?(d=r(),null!==d?(58===e.charCodeAt(b)?(h=":",b++):(h=null,0===
f&&g('":"')),null!==h?(j=r(),null!==j?(58===e.charCodeAt(b)?(l=":",b++):(l=null,0===f&&g('":"')),null!==l?(m=r(),null!==m?(58===e.charCodeAt(b)?(q=":",b++):(q=null,0===f&&g('":"')),null!==q?(p=r(),null!==p?(58===e.charCodeAt(b)?(s=":",b++):(s=null,0===f&&g('":"')),null!==s?(t=D(),null!==t?a=[a,c,d,h,j,l,m,q,p,s,t]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,a=r(),null!==a?(p=
b,58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=r(),null!==d?c=[c,d]:(c=null,b=p)):(c=null,b=p),c=null!==c?c:"",null!==c?("::"===e.substr(b,2)?(d="::",b+=2):(d=null,0===f&&g('"::"')),null!==d?(h=r(),null!==h?(58===e.charCodeAt(b)?(j=":",b++):(j=null,0===f&&g('":"')),null!==j?(l=r(),null!==l?(58===e.charCodeAt(b)?(m=":",b++):(m=null,0===f&&g('":"')),null!==m?(q=r(),null!==q?(58===e.charCodeAt(b)?(p=":",b++):(p=null,0===f&&g('":"')),null!==p?(s=D(),null!==s?a=[a,c,d,h,j,l,m,
q,p,s]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,a=r(),null!==a?(p=b,58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=r(),null!==d?c=[c,d]:(c=null,b=p)):(c=null,b=p),c=null!==c?c:"",null!==c?(p=b,58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?d=[d,h]:(d=null,b=p)):(d=null,b=p),d=null!==d?d:"",null!==d?("::"===e.substr(b,2)?(h="::",
b+=2):(h=null,0===f&&g('"::"')),null!==h?(j=r(),null!==j?(58===e.charCodeAt(b)?(l=":",b++):(l=null,0===f&&g('":"')),null!==l?(m=r(),null!==m?(58===e.charCodeAt(b)?(q=":",b++):(q=null,0===f&&g('":"')),null!==q?(p=D(),null!==p?a=[a,c,d,h,j,l,m,q,p]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,a=r(),null!==a?(p=b,58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=r(),null!==d?c=[c,d]:(c=
null,b=p)):(c=null,b=p),c=null!==c?c:"",null!==c?(p=b,58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?d=[d,h]:(d=null,b=p)):(d=null,b=p),d=null!==d?d:"",null!==d?(p=b,58===e.charCodeAt(b)?(h=":",b++):(h=null,0===f&&g('":"')),null!==h?(j=r(),null!==j?h=[h,j]:(h=null,b=p)):(h=null,b=p),h=null!==h?h:"",null!==h?("::"===e.substr(b,2)?(j="::",b+=2):(j=null,0===f&&g('"::"')),null!==j?(l=r(),null!==l?(58===e.charCodeAt(b)?(m=":",b++):(m=null,0===f&&g('":"')),null!==m?(q=
D(),null!==q?a=[a,c,d,h,j,l,m,q]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,a=r(),null!==a?(p=b,58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=r(),null!==d?c=[c,d]:(c=null,b=p)):(c=null,b=p),c=null!==c?c:"",null!==c?(p=b,58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?d=[d,h]:(d=null,b=p)):(d=null,b=p),d=null!==d?d:"",null!==d?(p=b,58===e.charCodeAt(b)?(h=":",
b++):(h=null,0===f&&g('":"')),null!==h?(j=r(),null!==j?h=[h,j]:(h=null,b=p)):(h=null,b=p),h=null!==h?h:"",null!==h?(p=b,58===e.charCodeAt(b)?(j=":",b++):(j=null,0===f&&g('":"')),null!==j?(l=r(),null!==l?j=[j,l]:(j=null,b=p)):(j=null,b=p),j=null!==j?j:"",null!==j?("::"===e.substr(b,2)?(l="::",b+=2):(l=null,0===f&&g('"::"')),null!==l?(m=D(),null!==m?a=[a,c,d,h,j,l,m]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,a=r(),null!==a?(p=b,58===
e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=r(),null!==d?c=[c,d]:(c=null,b=p)):(c=null,b=p),c=null!==c?c:"",null!==c?(p=b,58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?d=[d,h]:(d=null,b=p)):(d=null,b=p),d=null!==d?d:"",null!==d?(p=b,58===e.charCodeAt(b)?(h=":",b++):(h=null,0===f&&g('":"')),null!==h?(j=r(),null!==j?h=[h,j]:(h=null,b=p)):(h=null,b=p),h=null!==h?h:"",null!==h?(p=b,58===e.charCodeAt(b)?(j=":",b++):(j=null,0===f&&g('":"')),null!==
j?(l=r(),null!==l?j=[j,l]:(j=null,b=p)):(j=null,b=p),j=null!==j?j:"",null!==j?(p=b,58===e.charCodeAt(b)?(l=":",b++):(l=null,0===f&&g('":"')),null!==l?(m=r(),null!==m?l=[l,m]:(l=null,b=p)):(l=null,b=p),l=null!==l?l:"",null!==l?("::"===e.substr(b,2)?(m="::",b+=2):(m=null,0===f&&g('"::"')),null!==m?(q=r(),null!==q?a=[a,c,d,h,j,l,m,q]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n),null===a&&(n=b,a=r(),null!==a?(p=b,58===e.charCodeAt(b)?(c=
":",b++):(c=null,0===f&&g('":"')),null!==c?(d=r(),null!==d?c=[c,d]:(c=null,b=p)):(c=null,b=p),c=null!==c?c:"",null!==c?(p=b,58===e.charCodeAt(b)?(d=":",b++):(d=null,0===f&&g('":"')),null!==d?(h=r(),null!==h?d=[d,h]:(d=null,b=p)):(d=null,b=p),d=null!==d?d:"",null!==d?(p=b,58===e.charCodeAt(b)?(h=":",b++):(h=null,0===f&&g('":"')),null!==h?(j=r(),null!==j?h=[h,j]:(h=null,b=p)):(h=null,b=p),h=null!==h?h:"",null!==h?(p=b,58===e.charCodeAt(b)?(j=":",b++):(j=null,0===f&&g('":"')),null!==j?(l=r(),null!==
l?j=[j,l]:(j=null,b=p)):(j=null,b=p),j=null!==j?j:"",null!==j?(p=b,58===e.charCodeAt(b)?(l=":",b++):(l=null,0===f&&g('":"')),null!==l?(m=r(),null!==m?l=[l,m]:(l=null,b=p)):(l=null,b=p),l=null!==l?l:"",null!==l?(p=b,58===e.charCodeAt(b)?(m=":",b++):(m=null,0===f&&g('":"')),null!==m?(q=r(),null!==q?m=[m,q]:(m=null,b=p)):(m=null,b=p),m=null!==m?m:"",null!==m?("::"===e.substr(b,2)?(q="::",b+=2):(q=null,0===f&&g('"::"')),null!==q?a=[a,c,d,h,j,l,m,q]:(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=
n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)):(a=null,b=n)))))))))))))));null!==a&&(k.host_type="IPv6",a=e.substring(b,w));null===a&&(b=w);return a}function r(){var a,c,d,h,e;e=b;a=H();null!==a?(c=H(),c=null!==c?c:"",null!==c?(d=H(),d=null!==d?d:"",null!==d?(h=H(),h=null!==h?h:"",null!==h?a=[a,c,d,h]:(a=null,b=e)):(a=null,b=e)):(a=null,b=e)):(a=null,b=e);return a}function D(){var a,c,d,h;h=b;a=r();null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=r(),null!==d?a=[a,c,
d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);null===a&&(a=N());return a}function N(){var a,c,d,h,j,l,m,q,p;p=q=b;a=X();null!==a?(46===e.charCodeAt(b)?(c=".",b++):(c=null,0===f&&g('"."')),null!==c?(d=X(),null!==d?(46===e.charCodeAt(b)?(h=".",b++):(h=null,0===f&&g('"."')),null!==h?(j=X(),null!==j?(46===e.charCodeAt(b)?(l=".",b++):(l=null,0===f&&g('"."')),null!==l?(m=X(),null!==m?a=[a,c,d,h,j,l,m]:(a=null,b=p)):(a=null,b=p)):(a=null,b=p)):(a=null,b=p)):(a=null,b=p)):(a=null,b=p)):(a=null,b=p);null!==
a&&(k.host_type="IPv4",a=e.substring(b,q));null===a&&(b=q);return a}function X(){var a,c,d,h;h=b;"25"===e.substr(b,2)?(a="25",b+=2):(a=null,0===f&&g('"25"'));null!==a?(/^[0-5]/.test(e.charAt(b))?(c=e.charAt(b),b++):(c=null,0===f&&g("[0-5]")),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null===a&&(h=b,50===e.charCodeAt(b)?(a="2",b++):(a=null,0===f&&g('"2"')),null!==a?(/^[0-4]/.test(e.charAt(b))?(c=e.charAt(b),b++):(c=null,0===f&&g("[0-4]")),null!==c?(d=s(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=
h)):(a=null,b=h),null===a&&(h=b,49===e.charCodeAt(b)?(a="1",b++):(a=null,0===f&&g('"1"')),null!==a?(c=s(),null!==c?(d=s(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h),null===a&&(h=b,/^[1-9]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[1-9]")),null!==a?(c=s(),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h),null===a&&(a=s()))));return a}function Sa(){var a,c,d,h,e,f,g;g=f=b;a=s();a=null!==a?a:"";null!==a?(c=s(),c=null!==c?c:"",null!==c?(d=s(),d=null!==d?d:"",null!==d?(h=s(),
h=null!==h?h:"",null!==h?(e=s(),e=null!==e?e:"",null!==e?a=[a,c,d,h,e]:(a=null,b=g)):(a=null,b=g)):(a=null,b=g)):(a=null,b=g)):(a=null,b=g);null!==a&&(a=parseInt(a.join("")),k.port=a);null===a&&(b=f);return a}function yb(){var a,c,d,h;a=[];h=b;59===e.charCodeAt(b)?(c=";",b++):(c=null,0===f&&g('";"'));null!==c?(d=Wa(),null!==d?c=[c,d]:(c=null,b=h)):(c=null,b=h);for(;null!==c;)a.push(c),h=b,59===e.charCodeAt(b)?(c=";",b++):(c=null,0===f&&g('";"')),null!==c?(d=Wa(),null!==d?c=[c,d]:(c=null,b=h)):(c=
null,b=h);return a}function Wa(){var a;a=Db();null===a&&(a=Eb(),null===a&&(a=Fb(),null===a&&(a=Gb(),null===a&&(a=Hb(),null===a&&(a=Ib(),null===a&&(a=Jb()))))));return a}function Db(){var a,c,d,h;h=d=b;"transport="===e.substr(b,10).toLowerCase()?(a=e.substr(b,10),b+=10):(a=null,0===f&&g('"transport="'));null!==a?("udp"===e.substr(b,3).toLowerCase()?(c=e.substr(b,3),b+=3):(c=null,0===f&&g('"udp"')),null===c&&("tcp"===e.substr(b,3).toLowerCase()?(c=e.substr(b,3),b+=3):(c=null,0===f&&g('"tcp"')),null===
c&&("sctp"===e.substr(b,4).toLowerCase()?(c=e.substr(b,4),b+=4):(c=null,0===f&&g('"sctp"')),null===c&&("tls"===e.substr(b,3).toLowerCase()?(c=e.substr(b,3),b+=3):(c=null,0===f&&g('"tls"')),null===c&&(c=t())))),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==a&&(a=a[1],k.uri_params||(k.uri_params={}),k.uri_params.transport=a.toLowerCase(),a=void 0);null===a&&(b=d);return a}function Eb(){var a,c,d,h;h=d=b;"user="===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"user="'));null!==
a?("phone"===e.substr(b,5).toLowerCase()?(c=e.substr(b,5),b+=5):(c=null,0===f&&g('"phone"')),null===c&&("ip"===e.substr(b,2).toLowerCase()?(c=e.substr(b,2),b+=2):(c=null,0===f&&g('"ip"')),null===c&&(c=t())),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==a&&(a=a[1],k.uri_params||(k.uri_params={}),k.uri_params.user=a.toLowerCase(),a=void 0);null===a&&(b=d);return a}function Fb(){var a,c,d,h;h=d=b;"method="===e.substr(b,7).toLowerCase()?(a=e.substr(b,7),b+=7):(a=null,0===f&&g('"method="'));null!==
a?(c=qa(),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==a&&(a=a[1],k.uri_params||(k.uri_params={}),k.uri_params.method=a,a=void 0);null===a&&(b=d);return a}function Gb(){var a,c,d,h;h=d=b;"ttl="===e.substr(b,4).toLowerCase()?(a=e.substr(b,4),b+=4):(a=null,0===f&&g('"ttl="'));null!==a?(c=Xa(),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==a&&(a=a[1],k.params||(k.params={}),k.params.ttl=a,a=void 0);null===a&&(b=d);return a}function Hb(){var a,c,d,h;h=d=b;"maddr="===e.substr(b,6).toLowerCase()?
(a=e.substr(b,6),b+=6):(a=null,0===f&&g('"maddr="'));null!==a?(c=W(),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);null!==a&&(a=a[1],k.uri_params||(k.uri_params={}),k.uri_params.maddr=a,a=void 0);null===a&&(b=d);return a}function Ib(){var a,c,d,h,j,l;j=h=b;"lr"===e.substr(b,2).toLowerCase()?(a=e.substr(b,2),b+=2):(a=null,0===f&&g('"lr"'));null!==a?(l=b,61===e.charCodeAt(b)?(c="=",b++):(c=null,0===f&&g('"="')),null!==c?(d=t(),null!==d?c=[c,d]:(c=null,b=l)):(c=null,b=l),c=null!==c?c:"",null!==c?a=[a,
c]:(a=null,b=j)):(a=null,b=j);null!==a&&(k.uri_params||(k.uri_params={}),a=k.uri_params.lr=void 0);null===a&&(b=h);return a}function Jb(){var a,c,d,h,j,l;j=h=b;a=Kb();null!==a?(l=b,61===e.charCodeAt(b)?(c="=",b++):(c=null,0===f&&g('"="')),null!==c?(d=Lb(),null!==d?c=[c,d]:(c=null,b=l)):(c=null,b=l),c=null!==c?c:"",null!==c?a=[a,c]:(a=null,b=j)):(a=null,b=j);null!==a&&(c=a[0],a=a[1],k.uri_params||(k.uri_params={}),a="undefined"===typeof a?void 0:a[1],k.uri_params[c.toLowerCase()]=a&&a.toLowerCase(),
a=void 0);null===a&&(b=h);return a}function Kb(){var a,c,d;d=b;c=Y();if(null!==c)for(a=[];null!==c;)a.push(c),c=Y();else a=null;null!==a&&(a=a.join(""));null===a&&(b=d);return a}function Lb(){var a,c,d;d=b;c=Y();if(null!==c)for(a=[];null!==c;)a.push(c),c=Y();else a=null;null!==a&&(a=a.join(""));null===a&&(b=d);return a}function Y(){var a;a=Mb();null===a&&(a=y(),null===a&&(a=z()));return a}function Mb(){var a;91===e.charCodeAt(b)?(a="[",b++):(a=null,0===f&&g('"["'));null===a&&(93===e.charCodeAt(b)?
(a="]",b++):(a=null,0===f&&g('"]"')),null===a&&(47===e.charCodeAt(b)?(a="/",b++):(a=null,0===f&&g('"/"')),null===a&&(58===e.charCodeAt(b)?(a=":",b++):(a=null,0===f&&g('":"')),null===a&&(38===e.charCodeAt(b)?(a="&",b++):(a=null,0===f&&g('"&"')),null===a&&(43===e.charCodeAt(b)?(a="+",b++):(a=null,0===f&&g('"+"')),null===a&&(36===e.charCodeAt(b)?(a="$",b++):(a=null,0===f&&g('"$"'))))))));return a}function zb(){var a,c,d,h,j,l,m;l=b;63===e.charCodeAt(b)?(a="?",b++):(a=null,0===f&&g('"?"'));if(null!==
a)if(c=ra(),null!==c){d=[];m=b;38===e.charCodeAt(b)?(h="&",b++):(h=null,0===f&&g('"&"'));null!==h?(j=ra(),null!==j?h=[h,j]:(h=null,b=m)):(h=null,b=m);for(;null!==h;)d.push(h),m=b,38===e.charCodeAt(b)?(h="&",b++):(h=null,0===f&&g('"&"')),null!==h?(j=ra(),null!==j?h=[h,j]:(h=null,b=m)):(h=null,b=m);null!==d?a=[a,c,d]:(a=null,b=l)}else a=null,b=l;else a=null,b=l;return a}function ra(){var a,c,d,h,j;j=h=b;a=Nb();null!==a?(61===e.charCodeAt(b)?(c="=",b++):(c=null,0===f&&g('"="')),null!==c?(d=Ob(),null!==
d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(c=a[0],a=a[2],c=c.join("").toLowerCase(),a=a.join(""),k.uri_headers||(k.uri_headers={}),k.uri_headers[c]?k.uri_headers[c].push(a):k.uri_headers[c]=[a],a=void 0);null===a&&(b=h);return a}function Nb(){var a,b;b=Z();null===b&&(b=y(),null===b&&(b=z()));if(null!==b)for(a=[];null!==b;)a.push(b),b=Z(),null===b&&(b=y(),null===b&&(b=z()));else a=null;return a}function Ob(){var a,b;a=[];b=Z();null===b&&(b=y(),null===b&&(b=z()));for(;null!==b;)a.push(b),
b=Z(),null===b&&(b=y(),null===b&&(b=z()));return a}function Z(){var a;91===e.charCodeAt(b)?(a="[",b++):(a=null,0===f&&g('"["'));null===a&&(93===e.charCodeAt(b)?(a="]",b++):(a=null,0===f&&g('"]"')),null===a&&(47===e.charCodeAt(b)?(a="/",b++):(a=null,0===f&&g('"/"')),null===a&&(63===e.charCodeAt(b)?(a="?",b++):(a=null,0===f&&g('"?"')),null===a&&(58===e.charCodeAt(b)?(a=":",b++):(a=null,0===f&&g('":"')),null===a&&(43===e.charCodeAt(b)?(a="+",b++):(a=null,0===f&&g('"+"')),null===a&&(36===e.charCodeAt(b)?
(a="$",b++):(a=null,0===f&&g('"$"'))))))));return a}function Pb(){var a,c,d,h,e,f;f=b;a=qa();null!==a?(c=B(),null!==c?(d=Qb(),null!==d?(h=B(),null!==h?(e=Ya(),null!==e?a=[a,c,d,h,e]:(a=null,b=f)):(a=null,b=f)):(a=null,b=f)):(a=null,b=f)):(a=null,b=f);return a}function Qb(){var a;a=oa();null===a&&(a=Za());return a}function Za(){var a,c,d,h;h=b;a=Rb();null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=Sb(),null===d&&(d=Tb()),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):
(a=null,b=h);return a}function Sb(){var a,c,d,h,j;h=b;a=Ub();null===a&&(a=sa());null!==a?(j=b,63===e.charCodeAt(b)?(c="?",b++):(c=null,0===f&&g('"?"')),null!==c?(d=Vb(),null!==d?c=[c,d]:(c=null,b=j)):(c=null,b=j),c=null!==c?c:"",null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);return a}function Ub(){var a,c,d,h;h=b;"//"===e.substr(b,2)?(a="//",b+=2):(a=null,0===f&&g('"//"'));null!==a?(c=Wb(),null!==c?(d=sa(),d=null!==d?d:"",null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function sa(){var a,
c,d;d=b;47===e.charCodeAt(b)?(a="/",b++):(a=null,0===f&&g('"/"'));null!==a?(c=Xb(),null!==c?a=[a,c]:(a=null,b=d)):(a=null,b=d);return a}function Tb(){var a,c,d,h;h=b;a=Yb();if(null!==a){c=[];for(d=$();null!==d;)c.push(d),d=$();null!==c?a=[a,c]:(a=null,b=h)}else a=null,b=h;return a}function $(){var a;a=ha();null===a&&(a=y(),null===a&&(a=z()));return a}function Yb(){var a;a=y();null===a&&(a=z(),null===a&&(59===e.charCodeAt(b)?(a=";",b++):(a=null,0===f&&g('";"')),null===a&&(63===e.charCodeAt(b)?(a="?",
b++):(a=null,0===f&&g('"?"')),null===a&&(58===e.charCodeAt(b)?(a=":",b++):(a=null,0===f&&g('":"')),null===a&&(64===e.charCodeAt(b)?(a="@",b++):(a=null,0===f&&g('"@"')),null===a&&(38===e.charCodeAt(b)?(a="&",b++):(a=null,0===f&&g('"&"')),null===a&&(61===e.charCodeAt(b)?(a="=",b++):(a=null,0===f&&g('"="')),null===a&&(43===e.charCodeAt(b)?(a="+",b++):(a=null,0===f&&g('"+"')),null===a&&(36===e.charCodeAt(b)?(a="$",b++):(a=null,0===f&&g('"$"')),null===a&&(44===e.charCodeAt(b)?(a=",",b++):(a=null,0===f&&
g('","'))))))))))));return a}function Xb(){var a,c,d,h,j,l;j=b;a=ta();if(null!==a){c=[];l=b;47===e.charCodeAt(b)?(d="/",b++):(d=null,0===f&&g('"/"'));null!==d?(h=ta(),null!==h?d=[d,h]:(d=null,b=l)):(d=null,b=l);for(;null!==d;)c.push(d),l=b,47===e.charCodeAt(b)?(d="/",b++):(d=null,0===f&&g('"/"')),null!==d?(h=ta(),null!==h?d=[d,h]:(d=null,b=l)):(d=null,b=l);null!==c?a=[a,c]:(a=null,b=j)}else a=null,b=j;return a}function ta(){var a,c,d,h,j,l;j=b;a=[];for(c=aa();null!==c;)a.push(c),c=aa();if(null!==
a){c=[];l=b;59===e.charCodeAt(b)?(d=";",b++):(d=null,0===f&&g('";"'));null!==d?(h=$a(),null!==h?d=[d,h]:(d=null,b=l)):(d=null,b=l);for(;null!==d;)c.push(d),l=b,59===e.charCodeAt(b)?(d=";",b++):(d=null,0===f&&g('";"')),null!==d?(h=$a(),null!==h?d=[d,h]:(d=null,b=l)):(d=null,b=l);null!==c?a=[a,c]:(a=null,b=j)}else a=null,b=j;return a}function $a(){var a,b;a=[];for(b=aa();null!==b;)a.push(b),b=aa();return a}function aa(){var a;a=y();null===a&&(a=z(),null===a&&(58===e.charCodeAt(b)?(a=":",b++):(a=null,
0===f&&g('":"')),null===a&&(64===e.charCodeAt(b)?(a="@",b++):(a=null,0===f&&g('"@"')),null===a&&(38===e.charCodeAt(b)?(a="&",b++):(a=null,0===f&&g('"&"')),null===a&&(61===e.charCodeAt(b)?(a="=",b++):(a=null,0===f&&g('"="')),null===a&&(43===e.charCodeAt(b)?(a="+",b++):(a=null,0===f&&g('"+"')),null===a&&(36===e.charCodeAt(b)?(a="$",b++):(a=null,0===f&&g('"$"')),null===a&&(44===e.charCodeAt(b)?(a=",",b++):(a=null,0===f&&g('","'))))))))));return a}function Rb(){var a,c,d,h,j;j=h=b;a=R();if(null!==a){c=
[];d=R();null===d&&(d=s(),null===d&&(43===e.charCodeAt(b)?(d="+",b++):(d=null,0===f&&g('"+"')),null===d&&(45===e.charCodeAt(b)?(d="-",b++):(d=null,0===f&&g('"-"')),null===d&&(46===e.charCodeAt(b)?(d=".",b++):(d=null,0===f&&g('"."'))))));for(;null!==d;)c.push(d),d=R(),null===d&&(d=s(),null===d&&(43===e.charCodeAt(b)?(d="+",b++):(d=null,0===f&&g('"+"')),null===d&&(45===e.charCodeAt(b)?(d="-",b++):(d=null,0===f&&g('"-"')),null===d&&(46===e.charCodeAt(b)?(d=".",b++):(d=null,0===f&&g('"."'))))));null!==
c?a=[a,c]:(a=null,b=j)}else a=null,b=j;null!==a&&(k.scheme=e.substring(b,h),a=void 0);null===a&&(b=h);return a}function Wb(){var a;a=Zb();null===a&&(a=ba());return a}function Zb(){var a,c,d,h;h=d=b;a=ma();null!==a?(64===e.charCodeAt(b)?(c="@",b++):(c=null,0===f&&g('"@"')),null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);a=null!==a?a:"";null!==a?(c=na(),null!==c?a=[a,c]:(a=null,b=d)):(a=null,b=d);return null!==a?a:""}function ba(){var a,c;c=y();null===c&&(c=z(),null===c&&(36===e.charCodeAt(b)?(c="$",b++):
(c=null,0===f&&g('"$"')),null===c&&(44===e.charCodeAt(b)?(c=",",b++):(c=null,0===f&&g('","')),null===c&&(59===e.charCodeAt(b)?(c=";",b++):(c=null,0===f&&g('";"')),null===c&&(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null===c&&(64===e.charCodeAt(b)?(c="@",b++):(c=null,0===f&&g('"@"')),null===c&&(38===e.charCodeAt(b)?(c="&",b++):(c=null,0===f&&g('"&"')),null===c&&(61===e.charCodeAt(b)?(c="=",b++):(c=null,0===f&&g('"="')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=null,0===f&&g('"+"')))))))))));
if(null!==c)for(a=[];null!==c;)a.push(c),c=y(),null===c&&(c=z(),null===c&&(36===e.charCodeAt(b)?(c="$",b++):(c=null,0===f&&g('"$"')),null===c&&(44===e.charCodeAt(b)?(c=",",b++):(c=null,0===f&&g('","')),null===c&&(59===e.charCodeAt(b)?(c=";",b++):(c=null,0===f&&g('";"')),null===c&&(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null===c&&(64===e.charCodeAt(b)?(c="@",b++):(c=null,0===f&&g('"@"')),null===c&&(38===e.charCodeAt(b)?(c="&",b++):(c=null,0===f&&g('"&"')),null===c&&(61===e.charCodeAt(b)?
(c="=",b++):(c=null,0===f&&g('"="')),null===c&&(43===e.charCodeAt(b)?(c="+",b++):(c=null,0===f&&g('"+"')))))))))));else a=null;return a}function Vb(){var a,b;a=[];for(b=$();null!==b;)a.push(b),b=$();return a}function Ya(){var a,c,d,h,j,l,m,q;q=m=b;"sip"===e.substr(b,3).toLowerCase()?(a=e.substr(b,3),b+=3):(a=null,0===f&&g('"SIP"'));if(null!==a)if(47===e.charCodeAt(b)?(c="/",b++):(c=null,0===f&&g('"/"')),null!==c){h=s();if(null!==h)for(d=[];null!==h;)d.push(h),h=s();else d=null;if(null!==d)if(46===
e.charCodeAt(b)?(h=".",b++):(h=null,0===f&&g('"."')),null!==h){l=s();if(null!==l)for(j=[];null!==l;)j.push(l),l=s();else j=null;null!==j?a=[a,c,d,h,j]:(a=null,b=q)}else a=null,b=q;else a=null,b=q}else a=null,b=q;else a=null,b=q;null!==a&&(k.sip_version=e.substring(b,m),a=void 0);null===a&&(b=m);return a}function $b(){var a;"INVITE"===e.substr(b,6)?(a="INVITE",b+=6):(a=null,0===f&&g('"INVITE"'));return a}function ac(){var a;"ACK"===e.substr(b,3)?(a="ACK",b+=3):(a=null,0===f&&g('"ACK"'));return a}function bc(){var a;
"OPTIONS"===e.substr(b,7)?(a="OPTIONS",b+=7):(a=null,0===f&&g('"OPTIONS"'));return a}function cc(){var a;"BYE"===e.substr(b,3)?(a="BYE",b+=3):(a=null,0===f&&g('"BYE"'));return a}function dc(){var a;"CANCEL"===e.substr(b,6)?(a="CANCEL",b+=6):(a=null,0===f&&g('"CANCEL"'));return a}function ec(){var a;"REGISTER"===e.substr(b,8)?(a="REGISTER",b+=8):(a=null,0===f&&g('"REGISTER"'));return a}function fc(){var a;"SUBSCRIBE"===e.substr(b,9)?(a="SUBSCRIBE",b+=9):(a=null,0===f&&g('"SUBSCRIBE"'));return a}function gc(){var a;
"NOTIFY"===e.substr(b,6)?(a="NOTIFY",b+=6):(a=null,0===f&&g('"NOTIFY"'));return a}function qa(){var a,c;c=b;a=$b();null===a&&(a=ac(),null===a&&(a=bc(),null===a&&(a=cc(),null===a&&(a=dc(),null===a&&(a=ec(),null===a&&(a=fc(),null===a&&(a=gc(),null===a&&(a=t()))))))));null!==a&&(k.method=e.substring(b,c),a=k.method);null===a&&(b=c);return a}function hc(){var a,c,d,h,e,f;f=b;a=Ya();null!==a?(c=B(),null!==c?(d=ic(),null!==d?(h=B(),null!==h?(e=jc(),null!==e?a=[a,c,d,h,e]:(a=null,b=f)):(a=null,b=f)):(a=
null,b=f)):(a=null,b=f)):(a=null,b=f);return a}function ic(){var a,c;c=b;a=kc();null!==a&&(k.status_code=parseInt(a.join("")),a=void 0);null===a&&(b=c);return a}function kc(){var a,c,d,h;h=b;a=s();null!==a?(c=s(),null!==c?(d=s(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function jc(){var a,c,d;d=b;a=[];c=ha();null===c&&(c=y(),null===c&&(c=z(),null===c&&(c=M(),null===c&&(c=T(),null===c&&(c=B(),null===c&&(c=I()))))));for(;null!==c;)a.push(c),c=ha(),null===c&&(c=y(),null===
c&&(c=z(),null===c&&(c=M(),null===c&&(c=T(),null===c&&(c=B(),null===c&&(c=I()))))));null!==a&&(k.reason_phrase=e.substring(b,d),a=void 0);null===a&&(b=d);return a}function ua(){var a,c,d,h,e,f,g;f=e=b;a=la();null===a&&(a=O());if(null!==a){c=[];g=b;d=x();null!==d?(h=ab(),null!==h?d=[d,h]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=x(),null!==d?(h=ab(),null!==h?d=[d,h]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;if(null!==a){var q;k.multi_header||(k.multi_header=
[]);try{q=new JsSIP.NameAddrHeader(k.uri,k.display_name,k.params),delete k.uri,delete k.display_name,delete k.params}catch(p){q=null}k.multi_header.push({possition:b,offset:e,parsed:q});a=void 0}null===a&&(b=e);return a}function O(){var a,c,d,h,e;e=b;a=va();a=null!==a?a:"";null!==a?(c=La(),null!==c?(d=oa(),null!==d?(h=Ka(),null!==h?a=[a,c,d,h]:(a=null,b=e)):(a=null,b=e)):(a=null,b=e)):(a=null,b=e);return a}function va(){var a,c,d,h,f,g,m;g=f=b;a=t();if(null!==a){c=[];m=b;d=A();null!==d?(h=t(),null!==
h?d=[d,h]:(d=null,b=m)):(d=null,b=m);for(;null!==d;)c.push(d),m=b,d=A(),null!==d?(h=t(),null!==h?d=[d,h]:(d=null,b=m)):(d=null,b=m);null!==c?a=[a,c]:(a=null,b=g)}else a=null,b=g;null===a&&(a=U());null!==a&&(a=e.substring(b,f).trim(),'"'===a[0]&&(a=a.substring(1,a.length-1)),k.display_name=a,a=void 0);null===a&&(b=f);return a}function ab(){var a;a=lc();null===a&&(a=mc(),null===a&&(a=C()));return a}function lc(){var a,c,d,h,j;j=h=b;"q"===e.substr(b,1).toLowerCase()?(a=e.substr(b,1),b++):(a=null,0===
f&&g('"q"'));null!==a?(c=v(),null!==c?(d=nc(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a=a[2],k.params||(k.params={}),k.params.q=a,a=void 0);null===a&&(b=h);return a}function mc(){var a,c,d,h,j;j=h=b;"expires"===e.substr(b,7).toLowerCase()?(a=e.substr(b,7),b+=7):(a=null,0===f&&g('"expires"'));null!==a?(c=v(),null!==c?(d=P(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a=a[2],k.params||(k.params={}),k.params.expires=a,a=void 0);null===a&&(b=h);
return a}function P(){var a,c,d;d=b;c=s();if(null!==c)for(a=[];null!==c;)a.push(c),c=s();else a=null;null!==a&&(a=parseInt(a.join("")));null===a&&(b=d);return a}function nc(){var a,c,d,h,j,l,m,k;m=l=b;48===e.charCodeAt(b)?(a="0",b++):(a=null,0===f&&g('"0"'));null!==a?(k=b,46===e.charCodeAt(b)?(c=".",b++):(c=null,0===f&&g('"."')),null!==c?(d=s(),d=null!==d?d:"",null!==d?(h=s(),h=null!==h?h:"",null!==h?(j=s(),j=null!==j?j:"",null!==j?c=[c,d,h,j]:(c=null,b=k)):(c=null,b=k)):(c=null,b=k)):(c=null,b=k),
c=null!==c?c:"",null!==c?a=[a,c]:(a=null,b=m)):(a=null,b=m);null!==a&&(a=parseFloat(e.substring(b,l)));null===a&&(b=l);return a}function C(){var a,c,d,h,e,f;e=h=b;a=t();null!==a?(f=b,c=v(),null!==c?(d=oc(),null!==d?c=[c,d]:(c=null,b=f)):(c=null,b=f),c=null!==c?c:"",null!==c?a=[a,c]:(a=null,b=e)):(a=null,b=e);null!==a&&(c=a[0],a=a[1],k.params||(k.params={}),a="undefined"===typeof a?void 0:a[1],k.params[c.toLowerCase()]=a,a=void 0);null===a&&(b=h);return a}function oc(){var a;a=t();null===a&&(a=W(),
null===a&&(a=U()));return a}function pc(){var a;"render"===e.substr(b,6).toLowerCase()?(a=e.substr(b,6),b+=6):(a=null,0===f&&g('"render"'));null===a&&("session"===e.substr(b,7).toLowerCase()?(a=e.substr(b,7),b+=7):(a=null,0===f&&g('"session"')),null===a&&("icon"===e.substr(b,4).toLowerCase()?(a=e.substr(b,4),b+=4):(a=null,0===f&&g('"icon"')),null===a&&("alert"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"alert"')),null===a&&(a=t()))));return a}function bb(){var a;a=qc();
null===a&&(a=C());return a}function qc(){var a,c,d,h;h=b;"handling"===e.substr(b,8).toLowerCase()?(a=e.substr(b,8),b+=8):(a=null,0===f&&g('"handling"'));null!==a?(c=v(),null!==c?("optional"===e.substr(b,8).toLowerCase()?(d=e.substr(b,8),b+=8):(d=null,0===f&&g('"optional"')),null===d&&("required"===e.substr(b,8).toLowerCase()?(d=e.substr(b,8),b+=8):(d=null,0===f&&g('"required"')),null===d&&(d=t())),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function rc(){var a,c,d,h,e,f,g,
k;g=b;a=sc();if(null!==a)if(c=ja(),null!==c)if(d=tc(),null!==d){h=[];k=b;e=x();null!==e?(f=cb(),null!==f?e=[e,f]:(e=null,b=k)):(e=null,b=k);for(;null!==e;)h.push(e),k=b,e=x(),null!==e?(f=cb(),null!==f?e=[e,f]:(e=null,b=k)):(e=null,b=k);null!==h?a=[a,c,d,h]:(a=null,b=g)}else a=null,b=g;else a=null,b=g;else a=null,b=g;return a}function sc(){var a;a=uc();null===a&&(a=vc());return a}function uc(){var a;"text"===e.substr(b,4).toLowerCase()?(a=e.substr(b,4),b+=4):(a=null,0===f&&g('"text"'));null===a&&("image"===
e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"image"')),null===a&&("audio"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"audio"')),null===a&&("video"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"video"')),null===a&&("application"===e.substr(b,11).toLowerCase()?(a=e.substr(b,11),b+=11):(a=null,0===f&&g('"application"')),null===a&&(a=wa())))));return a}function vc(){var a;"message"===e.substr(b,7).toLowerCase()?(a=e.substr(b,
7),b+=7):(a=null,0===f&&g('"message"'));null===a&&("multipart"===e.substr(b,9).toLowerCase()?(a=e.substr(b,9),b+=9):(a=null,0===f&&g('"multipart"')),null===a&&(a=wa()));return a}function wa(){var a;a=t();null===a&&(a=wc());return a}function wc(){var a,c,d;d=b;"x-"===e.substr(b,2).toLowerCase()?(a=e.substr(b,2),b+=2):(a=null,0===f&&g('"x-"'));null!==a?(c=t(),null!==c?a=[a,c]:(a=null,b=d)):(a=null,b=d);return a}function tc(){var a;a=wa();null===a&&(a=t());return a}function cb(){var a,c,d,h;h=b;a=t();
null!==a?(c=v(),null!==c?(d=xc(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function xc(){var a;a=t();null===a&&(a=U());return a}function yc(){var a,c,d;d=b;c=s();if(null!==c)for(a=[];null!==c;)a.push(c),c=s();else a=null;null!==a&&(k.value=parseInt(a.join("")),a=void 0);null===a&&(b=d);return a}function ca(){var a,c,d,h,j,l;j=b;a=ia();if(null!==a){c=[];l=b;46===e.charCodeAt(b)?(d=".",b++):(d=null,0===f&&g('"."'));null!==d?(h=ia(),null!==h?d=[d,h]:(d=null,b=l)):(d=null,b=
l);for(;null!==d;)c.push(d),l=b,46===e.charCodeAt(b)?(d=".",b++):(d=null,0===f&&g('"."')),null!==d?(h=ia(),null!==h?d=[d,h]:(d=null,b=l)):(d=null,b=l);null!==c?a=[a,c]:(a=null,b=j)}else a=null,b=j;return a}function db(){var a;a=eb();null===a&&(a=C());return a}function eb(){var a,c,d,h,j;j=h=b;"tag"===e.substr(b,3).toLowerCase()?(a=e.substr(b,3),b+=3):(a=null,0===f&&g('"tag"'));null!==a?(c=v(),null!==c?(d=t(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.tag=a[2],a=void 0);
null===a&&(b=h);return a}function fb(){var a,c,d,h,j,l,m,k;m=b;"digest"===e.substr(b,6).toLowerCase()?(a=e.substr(b,6),b+=6):(a=null,0===f&&g('"Digest"'));if(null!==a)if(c=A(),null!==c)if(d=xa(),null!==d){h=[];k=b;j=w();null!==j?(l=xa(),null!==l?j=[j,l]:(j=null,b=k)):(j=null,b=k);for(;null!==j;)h.push(j),k=b,j=w(),null!==j?(l=xa(),null!==l?j=[j,l]:(j=null,b=k)):(j=null,b=k);null!==h?a=[a,c,d,h]:(a=null,b=m)}else a=null,b=m;else a=null,b=m;else a=null,b=m;null===a&&(a=zc());return a}function zc(){var a,
c,d,h,e,f,g,k;g=b;a=t();if(null!==a)if(c=A(),null!==c)if(d=da(),null!==d){h=[];k=b;e=w();null!==e?(f=da(),null!==f?e=[e,f]:(e=null,b=k)):(e=null,b=k);for(;null!==e;)h.push(e),k=b,e=w(),null!==e?(f=da(),null!==f?e=[e,f]:(e=null,b=k)):(e=null,b=k);null!==h?a=[a,c,d,h]:(a=null,b=g)}else a=null,b=g;else a=null,b=g;else a=null,b=g;return a}function da(){var a,c,d,h;h=b;a=t();null!==a?(c=v(),null!==c?(d=t(),null===d&&(d=U()),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function xa(){var a;
a=Ac();null===a&&(a=Bc(),null===a&&(a=Cc(),null===a&&(a=Dc(),null===a&&(a=Ec(),null===a&&(a=Fc(),null===a&&(a=Gc(),null===a&&(a=da())))))));return a}function Ac(){var a,c,d,h;h=b;"realm"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"realm"'));null!==a?(c=v(),null!==c?(d=Hc(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function Hc(){var a,c;c=b;a=ka();null!==a&&(k.realm=a,a=void 0);null===a&&(b=c);return a}function Bc(){var a,c,d,h,j,l,k,q,p;q=b;"domain"===
e.substr(b,6).toLowerCase()?(a=e.substr(b,6),b+=6):(a=null,0===f&&g('"domain"'));if(null!==a)if(c=v(),null!==c)if(d=Ma(),null!==d)if(h=ya(),null!==h){j=[];p=b;k=B();if(null!==k)for(l=[];null!==k;)l.push(k),k=B();else l=null;null!==l?(k=ya(),null!==k?l=[l,k]:(l=null,b=p)):(l=null,b=p);for(;null!==l;){j.push(l);p=b;k=B();if(null!==k)for(l=[];null!==k;)l.push(k),k=B();else l=null;null!==l?(k=ya(),null!==k?l=[l,k]:(l=null,b=p)):(l=null,b=p)}null!==j?(l=Na(),null!==l?a=[a,c,d,h,j,l]:(a=null,b=q)):(a=null,
b=q)}else a=null,b=q;else a=null,b=q;else a=null,b=q;else a=null,b=q;return a}function ya(){var a;a=Za();null===a&&(a=sa());return a}function Cc(){var a,c,d,h;h=b;"nonce"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"nonce"'));null!==a?(c=v(),null!==c?(d=Ic(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function Ic(){var a,c;c=b;a=ka();null!==a&&(k.nonce=a,a=void 0);null===a&&(b=c);return a}function Dc(){var a,c,d,h,j;j=h=b;"opaque"===e.substr(b,6).toLowerCase()?
(a=e.substr(b,6),b+=6):(a=null,0===f&&g('"opaque"'));null!==a?(c=v(),null!==c?(d=ka(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.opaque=a[2],a=void 0);null===a&&(b=h);return a}function Ec(){var a,c,d,h,j;h=b;"stale"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"stale"'));null!==a?(c=v(),null!==c?(j=b,"true"===e.substr(b,4).toLowerCase()?(d=e.substr(b,4),b+=4):(d=null,0===f&&g('"true"')),null!==d&&(k.stale=!0,d=void 0),null===d&&(b=j),null===
d&&(j=b,"false"===e.substr(b,5).toLowerCase()?(d=e.substr(b,5),b+=5):(d=null,0===f&&g('"false"')),null!==d&&(k.stale=!1,d=void 0),null===d&&(b=j)),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a}function Fc(){var a,c,d,h,j;j=h=b;"algorithm"===e.substr(b,9).toLowerCase()?(a=e.substr(b,9),b+=9):(a=null,0===f&&g('"algorithm"'));null!==a?(c=v(),null!==c?("md5"===e.substr(b,3).toLowerCase()?(d=e.substr(b,3),b+=3):(d=null,0===f&&g('"MD5"')),null===d&&("md5-sess"===e.substr(b,8).toLowerCase()?
(d=e.substr(b,8),b+=8):(d=null,0===f&&g('"MD5-sess"')),null===d&&(d=t())),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.algorithm=a[2].toUpperCase(),a=void 0);null===a&&(b=h);return a}function Gc(){var a,c,d,h,j,l,k,q,p,r;q=b;"qop"===e.substr(b,3).toLowerCase()?(a=e.substr(b,3),b+=3):(a=null,0===f&&g('"qop"'));if(null!==a)if(c=v(),null!==c)if(d=Ma(),null!==d){p=b;h=za();if(null!==h){j=[];r=b;44===e.charCodeAt(b)?(l=",",b++):(l=null,0===f&&g('","'));null!==l?(k=za(),null!==
k?l=[l,k]:(l=null,b=r)):(l=null,b=r);for(;null!==l;)j.push(l),r=b,44===e.charCodeAt(b)?(l=",",b++):(l=null,0===f&&g('","')),null!==l?(k=za(),null!==k?l=[l,k]:(l=null,b=r)):(l=null,b=r);null!==j?h=[h,j]:(h=null,b=p)}else h=null,b=p;null!==h?(j=Na(),null!==j?a=[a,c,d,h,j]:(a=null,b=q)):(a=null,b=q)}else a=null,b=q;else a=null,b=q;else a=null,b=q;return a}function za(){var a,c;c=b;"auth-int"===e.substr(b,8).toLowerCase()?(a=e.substr(b,8),b+=8):(a=null,0===f&&g('"auth-int"'));null===a&&("auth"===e.substr(b,
4).toLowerCase()?(a=e.substr(b,4),b+=4):(a=null,0===f&&g('"auth"')),null===a&&(a=t()));null!==a&&(k.qop||(k.qop=[]),k.qop.push(a.toLowerCase()),a=void 0);null===a&&(b=c);return a}function Aa(){var a,c,d,h,e,f,g;f=e=b;a=O();if(null!==a){c=[];g=b;d=x();null!==d?(h=C(),null!==h?d=[d,h]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=x(),null!==d?(h=C(),null!==h?d=[d,h]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;if(null!==a){var q;k.multi_header||(k.multi_header=
[]);try{q=new JsSIP.NameAddrHeader(k.uri,k.display_name,k.params),delete k.uri,delete k.display_name,delete k.params}catch(p){q=null}k.multi_header.push({possition:b,offset:e,parsed:q});a=void 0}null===a&&(b=e);return a}function Ba(){var a,c,d,h,e,f;e=b;a=O();if(null!==a){c=[];f=b;d=x();null!==d?(h=C(),null!==h?d=[d,h]:(d=null,b=f)):(d=null,b=f);for(;null!==d;)c.push(d),f=b,d=x(),null!==d?(h=C(),null!==h?d=[d,h]:(d=null,b=f)):(d=null,b=f);null!==c?a=[a,c]:(a=null,b=e)}else a=null,b=e;return a}function Jc(){var a,
c;c=b;"active"===e.substr(b,6).toLowerCase()?(a=e.substr(b,6),b+=6):(a=null,0===f&&g('"active"'));null===a&&("pending"===e.substr(b,7).toLowerCase()?(a=e.substr(b,7),b+=7):(a=null,0===f&&g('"pending"')),null===a&&("terminated"===e.substr(b,10).toLowerCase()?(a=e.substr(b,10),b+=10):(a=null,0===f&&g('"terminated"')),null===a&&(a=t())));null!==a&&(k.state=e.substring(b,c),a=void 0);null===a&&(b=c);return a}function gb(){var a,c,d,h,j;j=h=b;"reason"===e.substr(b,6).toLowerCase()?(a=e.substr(b,6),b+=
6):(a=null,0===f&&g('"reason"'));null!==a?(c=v(),null!==c?(d=Kc(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(a=a[2],"undefined"!==typeof a&&(k.reason=a),a=void 0);null===a&&(b=h);null===a&&(j=h=b,"expires"===e.substr(b,7).toLowerCase()?(a=e.substr(b,7),b+=7):(a=null,0===f&&g('"expires"')),null!==a?(c=v(),null!==c?(d=P(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j),null!==a&&(a=a[2],"undefined"!==typeof a&&(k.expires=a),a=void 0),null===a&&(b=h),null===a&&
(j=h=b,"retry_after"===e.substr(b,11).toLowerCase()?(a=e.substr(b,11),b+=11):(a=null,0===f&&g('"retry_after"')),null!==a?(c=v(),null!==c?(d=P(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j),null!==a&&(a=a[2],"undefined"!==typeof a&&(k.retry_after=a),a=void 0),null===a&&(b=h),null===a&&(a=C())));return a}function Kc(){var a;"deactivated"===e.substr(b,11).toLowerCase()?(a=e.substr(b,11),b+=11):(a=null,0===f&&g('"deactivated"'));null===a&&("probation"===e.substr(b,9).toLowerCase()?(a=e.substr(b,
9),b+=9):(a=null,0===f&&g('"probation"')),null===a&&("rejected"===e.substr(b,8).toLowerCase()?(a=e.substr(b,8),b+=8):(a=null,0===f&&g('"rejected"')),null===a&&("timeout"===e.substr(b,7).toLowerCase()?(a=e.substr(b,7),b+=7):(a=null,0===f&&g('"timeout"')),null===a&&("giveup"===e.substr(b,6).toLowerCase()?(a=e.substr(b,6),b+=6):(a=null,0===f&&g('"giveup"')),null===a&&("noresource"===e.substr(b,10).toLowerCase()?(a=e.substr(b,10),b+=10):(a=null,0===f&&g('"noresource"')),null===a&&("invariant"===e.substr(b,
9).toLowerCase()?(a=e.substr(b,9),b+=9):(a=null,0===f&&g('"invariant"')),null===a&&(a=t())))))));return a}function hb(){var a;a=eb();null===a&&(a=C());return a}function Ca(){var a,c,d,h,e,f,g,k;g=b;a=Lc();if(null!==a)if(c=A(),null!==c)if(d=Mc(),null!==d){h=[];k=b;e=x();null!==e?(f=ib(),null!==f?e=[e,f]:(e=null,b=k)):(e=null,b=k);for(;null!==e;)h.push(e),k=b,e=x(),null!==e?(f=ib(),null!==f?e=[e,f]:(e=null,b=k)):(e=null,b=k);null!==h?a=[a,c,d,h]:(a=null,b=g)}else a=null,b=g;else a=null,b=g;else a=null,
b=g;return a}function ib(){var a;a=Nc();null===a&&(a=Oc(),null===a&&(a=Pc(),null===a&&(a=Qc(),null===a&&(a=Rc(),null===a&&(a=C())))));return a}function Nc(){var a,c,d,h,j;j=h=b;"ttl"===e.substr(b,3).toLowerCase()?(a=e.substr(b,3),b+=3):(a=null,0===f&&g('"ttl"'));null!==a?(c=v(),null!==c?(d=Xa(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.ttl=a[2],a=void 0);null===a&&(b=h);return a}function Oc(){var a,c,d,h,j;j=h=b;"maddr"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),
b+=5):(a=null,0===f&&g('"maddr"'));null!==a?(c=v(),null!==c?(d=W(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.maddr=a[2],a=void 0);null===a&&(b=h);return a}function Pc(){var a,c,d,h,j;j=h=b;"received"===e.substr(b,8).toLowerCase()?(a=e.substr(b,8),b+=8):(a=null,0===f&&g('"received"'));null!==a?(c=v(),null!==c?(d=N(),null===d&&(d=Va()),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.received=a[2],a=void 0);null===a&&(b=h);return a}function Qc(){var a,
c,d,h,j;j=h=b;"branch"===e.substr(b,6).toLowerCase()?(a=e.substr(b,6),b+=6):(a=null,0===f&&g('"branch"'));null!==a?(c=v(),null!==c?(d=t(),null!==d?a=[a,c,d]:(a=null,b=j)):(a=null,b=j)):(a=null,b=j);null!==a&&(k.branch=a[2],a=void 0);null===a&&(b=h);return a}function Rc(){var a,c,d,h,j,l,m;l=j=b;"rport"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"rport"'));if(null!==a){m=b;c=v();if(null!==c){d=[];for(h=s();null!==h;)d.push(h),h=s();null!==d?c=[c,d]:(c=null,b=m)}else c=null,
b=m;c=null!==c?c:"";null!==c?a=[a,c]:(a=null,b=l)}else a=null,b=l;null!==a&&("undefined"!==typeof response_port&&(k.rport=response_port.join("")),a=void 0);null===a&&(b=j);return a}function Lc(){var a,c,d,h,e,f;f=b;a=Sc();null!==a?(c=ja(),null!==c?(d=t(),null!==d?(h=ja(),null!==h?(e=Da(),null!==e?a=[a,c,d,h,e]:(a=null,b=f)):(a=null,b=f)):(a=null,b=f)):(a=null,b=f)):(a=null,b=f);return a}function Sc(){var a,c;c=b;"sip"===e.substr(b,3).toLowerCase()?(a=e.substr(b,3),b+=3):(a=null,0===f&&g('"SIP"'));
null===a&&(a=t());null!==a&&(k.protocol=a,a=void 0);null===a&&(b=c);return a}function Da(){var a,c;c=b;"udp"===e.substr(b,3).toLowerCase()?(a=e.substr(b,3),b+=3):(a=null,0===f&&g('"UDP"'));null===a&&("tcp"===e.substr(b,3).toLowerCase()?(a=e.substr(b,3),b+=3):(a=null,0===f&&g('"TCP"')),null===a&&("tls"===e.substr(b,3).toLowerCase()?(a=e.substr(b,3),b+=3):(a=null,0===f&&g('"TLS"')),null===a&&("sctp"===e.substr(b,4).toLowerCase()?(a=e.substr(b,4),b+=4):(a=null,0===f&&g('"SCTP"')),null===a&&(a=t()))));
null!==a&&(k.transport=a,a=void 0);null===a&&(b=c);return a}function Mc(){var a,c,d,e,f;e=b;a=Tc();null!==a?(f=b,c=xb(),null!==c?(d=Uc(),null!==d?c=[c,d]:(c=null,b=f)):(c=null,b=f),c=null!==c?c:"",null!==c?a=[a,c]:(a=null,b=e)):(a=null,b=e);return a}function Tc(){var a,c;c=b;a=Ta();null===a&&(a=N(),null===a&&(a=pa()));null!==a&&(k.host=e.substring(b,c),a=void 0);null===a&&(b=c);return a}function Uc(){var a,c,d,e,f,g,m;m=g=b;a=s();a=null!==a?a:"";null!==a?(c=s(),c=null!==c?c:"",null!==c?(d=s(),d=null!==
d?d:"",null!==d?(e=s(),e=null!==e?e:"",null!==e?(f=s(),f=null!==f?f:"",null!==f?a=[a,c,d,e,f]:(a=null,b=m)):(a=null,b=m)):(a=null,b=m)):(a=null,b=m)):(a=null,b=m);null!==a&&(k.port=parseInt(a.join("")),a=void 0);null===a&&(b=g);return a}function Xa(){var a,c,d,e,f;f=e=b;a=s();null!==a?(c=s(),c=null!==c?c:"",null!==c?(d=s(),d=null!==d?d:"",null!==d?a=[a,c,d]:(a=null,b=f)):(a=null,b=f)):(a=null,b=f);null!==a&&(a=parseInt(a.join("")));null===a&&(b=e);return a}function Vc(){var a,b;a=[];b=J();null===
b&&(b=T(),null===b&&(b=A()));for(;null!==b;)a.push(b),b=J(),null===b&&(b=T(),null===b&&(b=A()));return a}function Wc(){var a,c;c=b;"stuns"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"stuns"'));null===a&&("stun"===e.substr(b,4).toLowerCase()?(a=e.substr(b,4),b+=4):(a=null,0===f&&g('"stun"')));null!==a&&(k.scheme=a,a=void 0);null===a&&(b=c);return a}function jb(){var a,c,d,h,j;h=b;a=Xc();null!==a?(j=b,58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=
Sa(),null!==d?c=[c,d]:(c=null,b=j)):(c=null,b=j),c=null!==c?c:"",null!==c?a=[a,c]:(a=null,b=h)):(a=null,b=h);return a}function Xc(){var a,c;c=b;a=N();null===a&&(a=pa(),null===a&&(a=ba()));null!==a&&(k.host=a,a=void 0);null===a&&(b=c);return a}function ba(){var a,c,d;d=b;a=[];c=kb();null===c&&(c=z(),null===c&&(c=lb()));for(;null!==c;)a.push(c),c=kb(),null===c&&(c=z(),null===c&&(c=lb()));null!==a&&(a=e.substring(b,d));null===a&&(b=d);return a}function kb(){var a;a=R();null===a&&(a=s(),null===a&&(45===
e.charCodeAt(b)?(a="-",b++):(a=null,0===f&&g('"-"')),null===a&&(46===e.charCodeAt(b)?(a=".",b++):(a=null,0===f&&g('"."')),null===a&&(95===e.charCodeAt(b)?(a="_",b++):(a=null,0===f&&g('"_"')),null===a&&(126===e.charCodeAt(b)?(a="~",b++):(a=null,0===f&&g('"~"')))))));return a}function lb(){var a;33===e.charCodeAt(b)?(a="!",b++):(a=null,0===f&&g('"!"'));null===a&&(36===e.charCodeAt(b)?(a="$",b++):(a=null,0===f&&g('"$"')),null===a&&(38===e.charCodeAt(b)?(a="&",b++):(a=null,0===f&&g('"&"')),null===a&&
(39===e.charCodeAt(b)?(a="'",b++):(a=null,0===f&&g('"\'"')),null===a&&(40===e.charCodeAt(b)?(a="(",b++):(a=null,0===f&&g('"("')),null===a&&(41===e.charCodeAt(b)?(a=")",b++):(a=null,0===f&&g('")"')),null===a&&(42===e.charCodeAt(b)?(a="*",b++):(a=null,0===f&&g('"*"')),null===a&&(43===e.charCodeAt(b)?(a="+",b++):(a=null,0===f&&g('"+"')),null===a&&(44===e.charCodeAt(b)?(a=",",b++):(a=null,0===f&&g('","')),null===a&&(59===e.charCodeAt(b)?(a=";",b++):(a=null,0===f&&g('";"')),null===a&&(61===e.charCodeAt(b)?
(a="=",b++):(a=null,0===f&&g('"="'))))))))))));return a}function Yc(){var a,c;c=b;"turns"===e.substr(b,5).toLowerCase()?(a=e.substr(b,5),b+=5):(a=null,0===f&&g('"turns"'));null===a&&("turn"===e.substr(b,4).toLowerCase()?(a=e.substr(b,4),b+=4):(a=null,0===f&&g('"turn"')));null!==a&&(k.scheme=a,a=void 0);null===a&&(b=c);return a}var Zc={CRLF:L,DIGIT:s,ALPHA:R,HEXDIG:H,WSP:S,OCTET:Ia,DQUOTE:F,SP:B,HTAB:I,alphanum:G,reserved:ha,unreserved:y,mark:rb,escaped:z,LWS:A,SWS:u,HCOLON:sb,TEXT_UTF8_TRIM:tb,TEXT_UTF8char:J,
UTF8_NONASCII:M,UTF8_CONT:T,LHEX:function(){var a;a=s();null===a&&(/^[a-f]/.test(e.charAt(b))?(a=e.charAt(b),b++):(a=null,0===f&&g("[a-f]")));return a},token:t,token_nodot:ia,separators:function(){var a;40===e.charCodeAt(b)?(a="(",b++):(a=null,0===f&&g('"("'));null===a&&(41===e.charCodeAt(b)?(a=")",b++):(a=null,0===f&&g('")"')),null===a&&(60===e.charCodeAt(b)?(a="<",b++):(a=null,0===f&&g('"<"')),null===a&&(62===e.charCodeAt(b)?(a=">",b++):(a=null,0===f&&g('">"')),null===a&&(64===e.charCodeAt(b)?(a=
"@",b++):(a=null,0===f&&g('"@"')),null===a&&(44===e.charCodeAt(b)?(a=",",b++):(a=null,0===f&&g('","')),null===a&&(59===e.charCodeAt(b)?(a=";",b++):(a=null,0===f&&g('";"')),null===a&&(58===e.charCodeAt(b)?(a=":",b++):(a=null,0===f&&g('":"')),null===a&&(92===e.charCodeAt(b)?(a="\\",b++):(a=null,0===f&&g('"\\\\"')),null===a&&(a=F(),null===a&&(47===e.charCodeAt(b)?(a="/",b++):(a=null,0===f&&g('"/"')),null===a&&(91===e.charCodeAt(b)?(a="[",b++):(a=null,0===f&&g('"["')),null===a&&(93===e.charCodeAt(b)?
(a="]",b++):(a=null,0===f&&g('"]"')),null===a&&(63===e.charCodeAt(b)?(a="?",b++):(a=null,0===f&&g('"?"')),null===a&&(61===e.charCodeAt(b)?(a="=",b++):(a=null,0===f&&g('"="')),null===a&&(123===e.charCodeAt(b)?(a="{",b++):(a=null,0===f&&g('"{"')),null===a&&(125===e.charCodeAt(b)?(a="}",b++):(a=null,0===f&&g('"}"')),null===a&&(a=B(),null===a&&(a=I()))))))))))))))))));return a},word:Ja,STAR:ub,SLASH:ja,EQUAL:v,LPAREN:vb,RPAREN:wb,RAQUOT:Ka,LAQUOT:La,COMMA:w,SEMI:x,COLON:xb,LDQUOT:Ma,RDQUOT:Na,comment:Oa,
ctext:Pa,quoted_string:U,quoted_string_clean:ka,qdtext:V,quoted_pair:K,SIP_URI_noparams:la,SIP_URI:oa,uri_scheme:Qa,userinfo:ma,user:Ab,user_unreserved:Ra,password:Bb,hostport:na,host:W,hostname:Ta,domainlabel:Ua,toplabel:Cb,IPv6reference:pa,IPv6address:Va,h16:r,ls32:D,IPv4address:N,dec_octet:X,port:Sa,uri_parameters:yb,uri_parameter:Wa,transport_param:Db,user_param:Eb,method_param:Fb,ttl_param:Gb,maddr_param:Hb,lr_param:Ib,other_param:Jb,pname:Kb,pvalue:Lb,paramchar:Y,param_unreserved:Mb,headers:zb,
header:ra,hname:Nb,hvalue:Ob,hnv_unreserved:Z,Request_Response:function(){var a;a=hc();null===a&&(a=Pb());return a},Request_Line:Pb,Request_URI:Qb,absoluteURI:Za,hier_part:Sb,net_path:Ub,abs_path:sa,opaque_part:Tb,uric:$,uric_no_slash:Yb,path_segments:Xb,segment:ta,param:$a,pchar:aa,scheme:Rb,authority:Wb,srvr:Zb,reg_name:ba,query:Vb,SIP_Version:Ya,INVITEm:$b,ACKm:ac,OPTIONSm:bc,BYEm:cc,CANCELm:dc,REGISTERm:ec,SUBSCRIBEm:fc,NOTIFYm:gc,Method:qa,Status_Line:hc,Status_Code:ic,extension_code:kc,Reason_Phrase:jc,
Allow_Events:function(){var a,c,d,e,f,g;f=b;a=ca();if(null!==a){c=[];g=b;d=w();null!==d?(e=ca(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=w(),null!==d?(e=ca(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return a},Call_ID:function(){var a,c,d,h,j,l;j=h=b;a=Ja();null!==a?(l=b,64===e.charCodeAt(b)?(c="@",b++):(c=null,0===f&&g('"@"')),null!==c?(d=Ja(),null!==d?c=[c,d]:(c=null,b=l)):(c=null,b=l),c=null!==c?c:"",null!==c?a=[a,
c]:(a=null,b=j)):(a=null,b=j);null!==a&&(k=e.substring(b,h),a=void 0);null===a&&(b=h);return a},Contact:function(){var a,c,d,e,f,g,m;f=b;a=ub();if(null===a)if(g=b,a=ua(),null!==a){c=[];m=b;d=w();null!==d?(e=ua(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);for(;null!==d;)c.push(d),m=b,d=w(),null!==d?(e=ua(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);null!==c?a=[a,c]:(a=null,b=g)}else a=null,b=g;if(null!==a){for(var q in k.multi_header)if(null===k.multi_header[q].parsed){k=null;break}k=null!==k?k.multi_header:
-1;a=void 0}null===a&&(b=f);return a},contact_param:ua,name_addr:O,display_name:va,contact_params:ab,c_p_q:lc,c_p_expires:mc,delta_seconds:P,qvalue:nc,generic_param:C,gen_value:oc,Content_Disposition:function(){var a,c,d,e,f,g;f=b;a=pc();if(null!==a){c=[];g=b;d=x();null!==d?(e=bb(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=x(),null!==d?(e=bb(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return a},disp_type:pc,disp_param:bb,
handling_param:qc,Content_Encoding:function(){var a,c,d,e,f,g;f=b;a=t();if(null!==a){c=[];g=b;d=w();null!==d?(e=t(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=w(),null!==d?(e=t(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return a},Content_Length:function(){var a,c,d;d=b;c=s();if(null!==c)for(a=[];null!==c;)a.push(c),c=s();else a=null;null!==a&&(k=parseInt(a.join("")),a=void 0);null===a&&(b=d);return a},Content_Type:function(){var a,
c;c=b;a=rc();null!==a&&(k=e.substring(b,c),a=void 0);null===a&&(b=c);return a},media_type:rc,m_type:sc,discrete_type:uc,composite_type:vc,extension_token:wa,x_token:wc,m_subtype:tc,m_parameter:cb,m_value:xc,CSeq:function(){var a,c,d,e;e=b;a=yc();null!==a?(c=A(),null!==c?(d=qa(),null!==d?a=[a,c,d]:(a=null,b=e)):(a=null,b=e)):(a=null,b=e);return a},CSeq_value:yc,Expires:function(){var a,c;c=b;a=P();null!==a&&(k=a,a=void 0);null===a&&(b=c);return a},Event:function(){var a,c,d,e,f,g,m;g=f=b;a=ca();if(null!==
a){c=[];m=b;d=x();null!==d?(e=C(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);for(;null!==d;)c.push(d),m=b,d=x(),null!==d?(e=C(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);null!==c?a=[a,c]:(a=null,b=g)}else a=null,b=g;null!==a&&(k.event=a[0].join("").toLowerCase(),a=void 0);null===a&&(b=f);return a},event_type:ca,From:function(){var a,c,d,e,f,g,m;g=f=b;a=la();null===a&&(a=O());if(null!==a){c=[];m=b;d=x();null!==d?(e=db(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);for(;null!==d;)c.push(d),m=b,d=
x(),null!==d?(e=db(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);null!==c?a=[a,c]:(a=null,b=g)}else a=null,b=g;if(null!==a){a=k.tag;try{k=new JsSIP.NameAddrHeader(k.uri,k.display_name,k.params),a&&k.setParam("tag",a)}catch(q){k=-1}a=void 0}null===a&&(b=f);return a},from_param:db,tag_param:eb,Max_Forwards:function(){var a,c,d;d=b;c=s();if(null!==c)for(a=[];null!==c;)a.push(c),c=s();else a=null;null!==a&&(k=parseInt(a.join("")),a=void 0);null===a&&(b=d);return a},Min_Expires:function(){var a,c;c=b;
a=P();null!==a&&(k=a,a=void 0);null===a&&(b=c);return a},Name_Addr_Header:function(){var a,c,d,e,f,g,m,q,p,r;p=q=b;a=[];for(c=va();null!==c;)a.push(c),c=va();if(null!==a)if(c=La(),null!==c)if(d=oa(),null!==d)if(e=Ka(),null!==e){f=[];r=b;g=x();null!==g?(m=C(),null!==m?g=[g,m]:(g=null,b=r)):(g=null,b=r);for(;null!==g;)f.push(g),r=b,g=x(),null!==g?(m=C(),null!==m?g=[g,m]:(g=null,b=r)):(g=null,b=r);null!==f?a=[a,c,d,e,f]:(a=null,b=p)}else a=null,b=p;else a=null,b=p;else a=null,b=p;else a=null,b=p;if(null!==
a){try{k=new JsSIP.NameAddrHeader(k.uri,k.display_name,k.params)}catch(s){k=-1}a=void 0}null===a&&(b=q);return a},Proxy_Authenticate:function(){return fb()},challenge:fb,other_challenge:zc,auth_param:da,digest_cln:xa,realm:Ac,realm_value:Hc,domain:Bc,URI:ya,nonce:Cc,nonce_value:Ic,opaque:Dc,stale:Ec,algorithm:Fc,qop_options:Gc,qop_value:za,Proxy_Require:function(){var a,c,d,e,f,g;f=b;a=t();if(null!==a){c=[];g=b;d=w();null!==d?(e=t(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),
g=b,d=w(),null!==d?(e=t(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return a},Record_Route:function(){var a,c,d,e,f,g,m;g=f=b;a=Aa();if(null!==a){c=[];m=b;d=w();null!==d?(e=Aa(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);for(;null!==d;)c.push(d),m=b,d=w(),null!==d?(e=Aa(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);null!==c?a=[a,c]:(a=null,b=g)}else a=null,b=g;if(null!==a){for(var q in k.multi_header)if(null===k.multi_header[q].parsed){k=null;break}k=
null!==k?k.multi_header:-1;a=void 0}null===a&&(b=f);return a},rec_route:Aa,Require:function(){var a,c,d,e,f,g;f=b;a=t();if(null!==a){c=[];g=b;d=w();null!==d?(e=t(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=w(),null!==d?(e=t(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return a},Route:function(){var a,c,d,e,f,g;f=b;a=Ba();if(null!==a){c=[];g=b;d=w();null!==d?(e=Ba(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==
d;)c.push(d),g=b,d=w(),null!==d?(e=Ba(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return a},route_param:Ba,Subscription_State:function(){var a,c,d,e,f,g;f=b;a=Jc();if(null!==a){c=[];g=b;d=x();null!==d?(e=gb(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=x(),null!==d?(e=gb(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return a},substate_value:Jc,subexp_params:gb,event_reason_value:Kc,
Subject:function(){var a;a=tb();return null!==a?a:""},Supported:function(){var a,c,d,e,f,g;f=b;a=t();if(null!==a){c=[];g=b;d=w();null!==d?(e=t(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=w(),null!==d?(e=t(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return null!==a?a:""},To:function(){var a,c,d,e,f,g,m;g=f=b;a=la();null===a&&(a=O());if(null!==a){c=[];m=b;d=x();null!==d?(e=hb(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=
m);for(;null!==d;)c.push(d),m=b,d=x(),null!==d?(e=hb(),null!==e?d=[d,e]:(d=null,b=m)):(d=null,b=m);null!==c?a=[a,c]:(a=null,b=g)}else a=null,b=g;if(null!==a){a=k.tag;try{k=new JsSIP.NameAddrHeader(k.uri,k.display_name,k.params),a&&k.setParam("tag",a)}catch(q){k=-1}a=void 0}null===a&&(b=f);return a},to_param:hb,Via:function(){var a,c,d,e,f,g;f=b;a=Ca();if(null!==a){c=[];g=b;d=w();null!==d?(e=Ca(),null!==e?d=[d,e]:(d=null,b=g)):(d=null,b=g);for(;null!==d;)c.push(d),g=b,d=w(),null!==d?(e=Ca(),null!==
e?d=[d,e]:(d=null,b=g)):(d=null,b=g);null!==c?a=[a,c]:(a=null,b=f)}else a=null,b=f;return a},via_parm:Ca,via_params:ib,via_ttl:Nc,via_maddr:Oc,via_received:Pc,via_branch:Qc,response_port:Rc,sent_protocol:Lc,protocol_name:Sc,transport:Da,sent_by:Mc,via_host:Tc,via_port:Uc,ttl:Xa,WWW_Authenticate:function(){return fb()},extension_header:function(){var a,c,d,e;e=b;a=t();null!==a?(c=sb(),null!==c?(d=Vc(),null!==d?a=[a,c,d]:(a=null,b=e)):(a=null,b=e)):(a=null,b=e);return a},header_value:Vc,message_body:function(){var a,
b;a=[];for(b=Ia();null!==b;)a.push(b),b=Ia();return a},stun_URI:function(){var a,c,d,h;h=b;a=Wc();null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=jb(),null!==d?a=[a,c,d]:(a=null,b=h)):(a=null,b=h)):(a=null,b=h);return a},stun_scheme:Wc,stun_host_port:jb,stun_host:Xc,reg_name:ba,stun_unreserved:kb,sub_delims:lb,turn_URI:function(){var a,c,d,h,j,k,m;k=b;a=Yc();null!==a?(58===e.charCodeAt(b)?(c=":",b++):(c=null,0===f&&g('":"')),null!==c?(d=jb(),null!==d?(m=b,"?transport="===
e.substr(b,11)?(h="?transport=",b+=11):(h=null,0===f&&g('"?transport="')),null!==h?(j=Da(),null!==j?h=[h,j]:(h=null,b=m)):(h=null,b=m),h=null!==h?h:"",null!==h?a=[a,c,d,h]:(a=null,b=k)):(a=null,b=k)):(a=null,b=k)):(a=null,b=k);return a},turn_scheme:Yc,turn_transport:function(){var a,c,d,h,j;j=h=b;a=Da();if(null!==a){"udp"===e.substr(b,3).toLowerCase()?(c=e.substr(b,3),b+=3):(c=null,0===f&&g('"udp"'));if(null===c&&("tcp"===e.substr(b,3).toLowerCase()?(c=e.substr(b,3),b+=3):(c=null,0===f&&g('"tcp"')),
null===c)){c=[];for(d=y();null!==d;)c.push(d),d=y()}null!==c?a=[a,c]:(a=null,b=j)}else a=null,b=j;null!==a&&(k.transport=transport,a=void 0);null===a&&(b=h);return a}};if(void 0!==E){if(void 0===Zc[E])throw Error("Invalid rule name: "+pb(E)+".");}else E="CRLF";var b=0,f=0,Q=0,Ha=[],k={};if(null===Zc[E]()||b!==e.length){for(var mb=Math.max(b,Q),bd=mb<e.length?e.charAt(mb):null,nb=1,Ea=1,Fa=!1,ob=0;ob<Math.max(b,Q);ob++){var Ga=e.charAt(ob);"\n"===Ga?(Fa||nb++,Ea=1,Fa=!1):"\r"===Ga||"\u2028"===Ga||
"\u2029"===Ga?(nb++,Ea=1,Fa=!0):(Ea++,Fa=!1)}qb=nb;ga=Ea;var cd=this.SyntaxError,ea=Ha;ea.sort();for(var $c=null,ad=[],fa=0;fa<ea.length;fa++)ea[fa]!==$c&&(ad.push(ea[fa]),$c=ea[fa]);new cd(ad,bd,mb,qb,ga);return-1}return k},toSource:function(){return this._source},SyntaxError:function(e,E,L,ga,g){this.name="SyntaxError";this.expected=e;this.found=E;switch(e.length){case 0:e="end of input";break;case 1:e=e[0];break;default:e=e.slice(0,e.length-1).join(", ")+" or "+e[e.length-1]}E=E?pb(E):"end of input";
this.message="Expected "+e+" but "+E+" found.";this.offset=L;this.line=ga;this.column=g}};L.SyntaxError.prototype=Error.prototype;return L}();
