#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 11;
use File::Path qw(make_path rmtree);

BEGIN {
    use_ok('NGCP::Daemon');
}

my $tmpdir = $ENV{RESULTS} // 't.tmp';

my $logfile = "$tmpdir/ngcp-daemon.log";
my $pidfile = "$tmpdir/ngcp-daemon.pid";

# Make sure we are running on a clean temporary tree.
rmtree($tmpdir);
make_path($tmpdir);

my $daemon;

ok(! -e $pidfile, 'daemon has not created the pidfile yet');
ok(! -e $logfile, 'daemon has not created the logfile yet');

$daemon = NGCP::Daemon->new(
    progname => 'test-daemon',
    nicename => 'NGCP Test Daemon',
    pidfile => $pidfile,
    logfile => $logfile,
);

is($daemon->is_running, 0, 'daemon has not started yet');
ok(! -e $pidfile, 'daemon has not created the pidfile yet');
ok(-e $logfile, 'daemon has created the logfile');

$daemon->init();

is($daemon->is_running, 1, 'daemon is running');
ok(-e $pidfile, 'daemon has created the pidfile');

$daemon->shutdown();

is($daemon->is_running, 0, 'daemon is stopped');
ok(! -e $pidfile, 'daemon has removed the pidfile');
ok(-e $logfile, 'daemon has created the logfile');

1;
