#!/bin/sh

SELF=ngcp-policy-rc.d

log()
{
  echo "[$(date)] $SELF: $*"
}

# Unconditionally setup the policy-rc.d queue, so that we catch any action
# from any dpkg invocation.
ngcp-service --queue=policy-rc.d queue-start

# Enqueue any relevant action, for deferred processing.
case "$2" in
  force-reload)
    log "enqueuing '$1' service 'restart' action for the next 'ngcpcfg apply'"
    ngcp-service --queue=policy-rc.d --enqueue --action=restart --service="$1"
    ;;
  start|stop|restart|reload)
    log "enqueuing '$1' service '$2' action for the next 'ngcpcfg apply'"
    ngcp-service --queue=policy-rc.d --enqueue --action="$2" --service="$1"
    ;;
  *)
    ;;
esac

# Apply the policy for the current invocation.
case "$1" in
  *ssh*)
    log "allowed action for ssh service: $*"
    exit 0
  ;;
esac

case "$2" in
  stop|status)
    log "allowed action: $*"
    exit 0
  ;;
  *)
    log "denied action: $*"
    exit 101
  ;;
esac
