package NGCP::Gather::Exim 0.001;

use strict;
use warnings;

our @EXPORT = qw(
    get_exim_queue_count
);

use Exporter qw(import);

=encoding utf8

=head1 NAME

NGCP::Gather::Exim - Gather Exim statistics

=head1 DESCRIPTION

This module provides support functions to gather Exim statistics information
for monitoring purposes.

=head1 FUNCTIONS

=over 4

=item $count = get_exim_queue_count(%opts)

Get number of messages in the Exim spool queue pending delivery.

=cut

sub get_exim_queue_count {
    my (%opts) = @_;

    opendir my $queue_fh, $opts{spooldir}
        or return 0;
    my @queue = grep { length == 18 && m/-H$/ } readdir $queue_fh;
    closedir $queue_fh;

    return scalar @queue;
}

=back

=head1 CHANGES

=head2 Version 0.xxx

This is a private module.

=head1 AUTHOR

Guillem Jover, C<< <gjover@sipwise.com> >>

=head1 BUGS

Please report any bugs to Sipwise GmbH.

=head1 LICENSE

Copyright (c) 2022 Sipwise GmbH, Austria.

GPL-3+, Sipwise GmbH, Austria.

=cut

1;
