package NGCP::Panel::Form::Reseller::Branding;

use HTML::FormHandler::Moose;
extends 'HTML::FormHandler';

use HTML::FormHandler::Widget::Block::Bootstrap;

has '+widget_wrapper' => ( default => 'Bootstrap' );
has '+enctype' => ( default => 'multipart/form-data');
has_field 'submitid' => ( type => 'Hidden' );
sub build_render_list {[qw/submitid fields actions/]}
sub build_form_element_class {[qw(form-horizontal)]}

has_field 'logo' => (
    type => 'Upload',
    required => 0,
    label => 'Logo',
    max_size => '67108864', # 64MB
);

has_field 'css' => (
    type => 'TextArea',
    label => 'CSS',
    cols => 200,
    rows => 10,
    maxlength => '67108864', # 64MB
    element_class => [qw/ngcp-autoconf-area/],
);

has_field 'csc_color_primary' => (
    type => 'Text',
    required => 0,
    label => 'CSC Primary Color',
    maxlength => 45,
    element_class => [qw/ngcp-csc-color-primary/],
);

has_field 'csc_color_secondary' => (
    type => 'Text',
    required => 0,
    label => 'CSC Secondary Color',
    maxlength => 45,
    element_class => [qw/ngcp-csc-color-secondary/],
);

has_field 'save' => (
    type => 'Submit',
    value => 'Save',
    element_class => [qw/btn btn-primary/],
    label => '',
);

has_block 'fields' => (
    tag => 'div',
    class => [qw/modal-body/],
    render_list => [qw/logo css csc_color_primary csc_color_secondary/],
);

has_block 'actions' => (
    tag => 'div',
    class => [qw/modal-footer/],
    render_list => [qw/save/],
);

1;
# vim: set tabstop=4 expandtab:
