package NGCP::Panel::Form::Subscriber::EditWebpass;

use HTML::FormHandler::Moose;
extends 'HTML::FormHandler';
use NGCP::Panel::Utils::Form;

use HTML::FormHandler::Widget::Block::Bootstrap;

has '+widget_wrapper' => ( default => 'Bootstrap' );
has_field 'submitid' => ( type => 'Hidden' );
sub build_render_list {[qw/submitid fields actions/]}
sub build_form_element_class {[qw(form-horizontal)]}

has_field 'webpassword' => (
    type => 'Password',
    label => 'Web Password',
    required => 1,
    minlength => 6,
    element_attr => { 
        rel => ['tooltip'], 
        title => ['The password to log into the CSC Panel'],
    },
);

has_field 'save' => (
    type => 'Submit',
    value => 'Save',
    element_class => [qw/btn btn-primary/],
    label => '',
);


has_block 'fields' => (
    tag => 'div',
    class => [qw/modal-body/],
    render_list => [qw/webpassword/ ],
);

has_block 'actions' => (
    tag => 'div',
    class => [qw/modal-footer/],
    render_list => [qw/save/],
);

sub validate_webpassword {
    my ($self, $field) = @_;
    my $c = $self->form->ctx;
    return unless $c;

    NGCP::Panel::Utils::Form::validate_password(c => $c, field => $field, utf8 => 0);
}

1;

# vim: set tabstop=4 expandtab:
