package NGCP::Panel::Model::DB;

use strict;
use warnings;

use base 'Catalyst::Model::DBIC::Schema';

__PACKAGE__->config(
    connect_info => [],
);

sub set_transaction_isolation {
    my ($self,$level) = @_;
    return $self->storage->dbh_do(
        sub {
          my ($storage, $dbh, @args) = @_;
          $dbh->do("SET TRANSACTION ISOLATION LEVEL " . $args[0]);
        },
        $level,
    );
}

sub set_wait_timeout {
    my ($self,$timeout) = @_;
    return $self->storage->dbh_do(
        sub {
          my ($storage, $dbh, @args) = @_;
          $dbh->do("SET SESSION wait_timeout = " . $args[0]);
        },
        $timeout,
    );
}

1;

__END__

=head1 NAME

NGCP::Panel::Model::DB - Catalyst DBIC Schema Model

=head1 SYNOPSIS

See L<NGCP::Panel>

=head1 DESCRIPTION

L<Catalyst::Model::DBIC::Schema> Model using schema L<NGCP::Schema>

=head1 GENERATED BY

Catalyst::Helper::Model::DBIC::Schema - 0.6

=head1 AUTHOR

Gerhard

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
