package NGCP::Panel::Role::API::AdminCerts;

use Sipwise::Base;

use parent 'NGCP::Panel::Role::API';

use Data::HAL::Link qw();
use HTTP::Status qw(:constants);

sub item_name {
    return 'admincerts';
}

sub resource_name{
    return 'admincerts';
}

sub get_form {
    my ($self, $c) = @_;
    return NGCP::Panel::Form::get("NGCP::Panel::Form::Administrator::APICert", $c);
}

sub _item_rs {
    my ($self, $c) = @_;
    my $item_rs;

    if($c->user->roles eq "admin") {
        $item_rs = $c->model('DB')->resultset('admins');
    } elsif($c->user->roles eq "reseller") {
        $item_rs = $c->model('DB')->resultset('admins')->search({
            reseller_id => $c->user->reseller_id,
        });
    }

    return $item_rs;
}

sub post_process_hal_resource {
    my ($self, $c, $item, $resource, $form) = @_;
    my $res = { has_certificate => $item->ssl_client_m_serial ? 1 : 0 };
    return $res;
}

1;
# vim: set tabstop=4 expandtab:
