import unittest
import os
import traceback
from multiprocessing import Value
import nose2
import time


from functions.Functions import click_js
from functions.Functions import create_firefoxdriver
from functions.Functions import create_chromedriver
from functions.Functions import fill_element
from functions.Functions import scroll_to_element
from functions.Functions import wait_for_invisibility
from functions.Collections import login_panel
from functions.Collections import logout_panel
from functions.Collections import create_reseller
from functions.Collections import create_reseller_contract
from functions.Collections import create_billing_profile
from functions.Collections import delete_reseller
from functions.Collections import delete_reseller_contract
from functions.Collections import delete_billing_profile
import selenium.common.exceptions
from selenium import webdriver
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.common.desired_capabilities import DesiredCapabilities
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.common.by import By
from datetime import datetime
import random

filename = 0
browser = ""


class testrun(unittest.TestCase):

    def setUp(self):
        if browser == "firefox":
            self.driver = create_firefoxdriver()
        elif browser == "chrome":
            self.driver = create_chromedriver()
        self.longMessage = True

    def test_admin(self):
        global filename
        adminname = "admin" + str(random.randint(1, 99999))
        resellername = "reseller" + str(random.randint(1, 99999))
        resellercontract = "contract" + str(random.randint(1, 99999))
        email = "test" + str(random.randint(1, 99999)) + "@test.com"
        adminname2 = "admin" + str(random.randint(1, 99999))
        filename = "test_admin.png"
        driver = self.driver
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        create_reseller_contract(driver, resellercontract)
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        create_reseller(driver, resellername, resellercontract)
        print("Go to 'Administrators'...", end="")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]').click()
        print("OK")
        print("Try to create a new Administrator...", end="")
        click_js(driver, '//*[@id="q-app"]/div//main//div/a[contains(., "add")]')
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Reseller")]/../div/input', 'default')
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        driver.find_element(By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Login")]/../div/input', adminname)
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//input[@aria-label="Password"]', 'Rand0m#PasswOrd#12345#')
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//input[@aria-label="Password Retype"]', 'Rand0m#PasswOrd#12345#')
        if driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Master"]').get_attribute('aria-checked') == "true":
            driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Master"]').click()
        if driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Active"]').get_attribute('aria-checked') == "false":
            driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Active"]').click()
        if driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Read Only"]').get_attribute('aria-checked') == "true":
            driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Read Only"]').click()
        if driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Show Passwords"]').get_attribute('aria-checked') == "true":
            driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Show Passwords"]').click()
        if driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Can Reset Password"]').get_attribute('aria-checked') == "true":
            driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Can Reset Password"]').click()
        if driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Show CDRs"]').get_attribute('aria-checked') == "true":
            driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Show CDRs"]').click()
        if driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Show Billing Info"]').get_attribute('aria-checked') == "true":
            driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/form//div[@aria-label="Show Billing Info"]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        print("OK")
        print("Check if Administrator was created...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + adminname + '")]')) > 0, "Administrator was not found")
        print("OK")
        print("Create a second Administrator...", end="")
        click_js(driver, '//*[@id="q-app"]/div//main//div/a[contains(., "add")]')
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Reseller")]/../div/input', resellername)
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        driver.find_element(By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Login")]/../div/input', adminname2)
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//input[@aria-label="Password"]', 'Rand0m#PasswOrd#12345#')
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//input[@aria-label="Password Retype"]', 'Rand0m#PasswOrd#12345#')
        driver.find_element(By.XPATH, '//label[@data-cy="roles-list"]').click()
        driver.find_element(By.XPATH, '//div[@data-cy="q-item--2"]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        print("OK")
        print("Try to login and check if admin is prohibited from changing his permissions...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        logout_panel(driver)
        login_panel(driver, adminname, 'Rand0m#PasswOrd#12345#')
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//table//tr/td[8]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div[@role="alert"][contains(., "User cannot modify own permissions")]')) > 0, "Notification showed up")
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main//table//tr[1]/td[8]//div[@aria-checked="false"]')) > 0, "'Active' toggle is not disabled")
        print("OK")
        print("Go back to administrator login...", end="")
        logout_panel(driver)
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]').click()
        print("OK")
        print("Check if 'Superuser' can edit admins from other resellers...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname2)
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//main//table//tr[1]//td/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body//div/a[contains(., "Edit")]')))
        driver.find_element(By.XPATH, '/html/body//div/a[contains(., "Edit")]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//*[@id="q-app"]/div//main//form//div//label//div[contains(., "Email")]/../div/input')))
        fill_element(driver, '//*[@id="q-app"]/div//main//form//div//label//div[contains(., "Email")]/../div/input', email)
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div[@role="alert"][contains(., "Administrator saved successfully")]')) > 0, "Admin could not be edited")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Close")]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        print("OK")
        print("Go back to administrator login...", end="")
        logout_panel(driver)
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]').click()
        print("Try to enable 'Customer Care'...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + adminname + '")]')) > 0, "Administrator was not found")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//main//table//tr[1]//td/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body//div/a[contains(., "Edit")]')))
        driver.find_element(By.XPATH, '/html/body//div/a[contains(., "Edit")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//label[@data-cy="roles-list"]').click()
        driver.find_element(By.XPATH, '//div[@data-cy="q-item--3"]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Close")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        print("OK")
        print("Check if 'Customer Care' is enabled...", end="")
        logout_panel(driver)
        login_panel(driver, adminname, 'Rand0m#PasswOrd#12345#')
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[1][contains(., "Customers")]')) > 0, "Customers buttons was not found")
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[2][contains(., "Subscribers")]')) > 0, "Subscribers buttons was not found")
        print("OK")
        print("Go back to administrator login...", end="")
        logout_panel(driver)
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]').click()
        print("OK")
        print("Try to enable 'Read-only'...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + adminname + '")]')) > 0, "Administrator was not found")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/div[2]/main/div[1]/div/div[1]/table/tbody/tr[1]/td[10]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        print("OK")
        print("Check if 'Read-only' was enabled...", end="")
        logout_panel(driver)
        login_panel(driver, adminname, 'Rand0m#PasswOrd#12345#')
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Customers")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Customers")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.implicitly_wait(1)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main//div/a[contains(., "Add")]')) == 0, "'Add' Button is still there")
        print("OK")
        driver.implicitly_wait(10)
        print("Go back to administrator login...", end="")
        logout_panel(driver)
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]').click()
        print("OK")
        print("Try to deactivate administrator...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + adminname + '")]')) > 0, "Administrator was not found")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table//tr[1]/td[9]/div').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        print("OK")
        print("Check if admin was deactivated...", end="")
        logout_panel(driver)
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@aria-label="Username"]')))
        fill_element(driver, '//*[@aria-label="Username"]', 'invalid')
        fill_element(driver, '//*[@aria-label="Password"]', 'data')
        click_js(driver, '//*[@id="q-app"]/div//main/div/form//button[contains(., "Sign In")]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div[contains(., "Wrong credentials")]')) > 0, "Admin was not deactivated")
        print("OK")
        print("Try to delete administrator...", end="")
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + adminname + '")]')) > 0, "Administrator was not found")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/table/tbody/tr[1]/td[2]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div/i[contains(., "warning")]')) > 0, "Admin was not deleted")
        print("OK")
        print("Try to delete second administrator...", end="")
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname2)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + adminname2 + '")]')) > 0, "Administrator was not found")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/table/tbody/tr[1]/td[2]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', adminname2)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div/i[contains(., "warning")]')) > 0, "Admin was not deleted")
        print("OK")
        delete_reseller(driver, resellername)
        filename = 0

    """
    def test_billing_profile(self):
        global filename
        billingname = "billing" + str(random.randint(1, 99999))
        billingrealname = "name" + str(random.randint(1, 99999))
        resellername = "reseller" + str(random.randint(1, 99999))
        resellercontract = "contract" + str(random.randint(1, 99999))
        filename = "test_billing_profile.png"
        driver = self.driver
        login_panel(driver)
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div/aside/div/div[2]//div[contains(., "Settings")]').click()
        create_reseller_contract(driver, resellercontract)
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        create_reseller(driver, resellername, resellercontract)
        print("Go to 'Billing Profiles'...", end="")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div/aside/div//a[contains(., "Billing Profiles")]').click()
        print("OK")
        print("Try to create a new Billing Profile...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/a[contains(., "add")]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Reseller")]/../div/input', resellername)
        driver.find_element(By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Handle")]/../div/input', billingname)
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Name")]/../div/input', billingrealname)
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        print("OK")
        print("Check if Billing Profile was created...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', billingrealname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + billingrealname + '")]')) > 0, "Billing Profile was not found")
        print("OK")
        print("Try to delete Billing Profile...", end="")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[7]/button')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[7]/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"][2]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"][2]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        print("OK")
        print("Check if Billing Profile was deleted...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', billingrealname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//i')) > 0, "Billing Profile was not deleted")
        print("OK")
        delete_reseller(driver, resellername)
        filename = 0
    """

    def test_contacts(self):
        global filename
        contactmail = "contact" + str(random.randint(1, 99999)) + "@test.inv"
        firstname = "first" + str(random.randint(1, 99999))
        lasttname = "last" + str(random.randint(1, 99999))
        filename = "test_contact.png"
        driver = self.driver
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        print("Go to 'Contacts'...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Contacts")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Contacts")]').click()
        print("OK")
        print("Try to create a new customer contact with an invalid Email...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Add")]').click()
        driver.find_element(By.XPATH, '/html/body//div[@class="q-list"]/a[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Reseller")]/../div/input', "default")
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Email")]/../div/input', "invaildmail")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div/main/form//div/label//div[contains(., "Input must be")]')) > 0)
        print("OK")
        print("Try to create a new customer contact...", end="")
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Email")]/../div/input', contactmail)
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        print("OK")
        print("Check if customer contact was created...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contactmail)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + contactmail + '")]')) > 0, "Contact was not found")
        print("OK")
        print("Try to add first and last name to contact...", end="")
        driver.find_element(By.XPATH, '//*[@data-cy="q-td--firstname"]/span').click()
        fill_element(driver, '/html/body//div//label//div//input[@aria-label="First Name"]', firstname)
        driver.find_element(By.XPATH, '/html/body//div/button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + firstname + '")]')) > 0, "Contact first name was not changed")
        driver.find_element(By.XPATH, '//*[@data-cy="q-td--lastname"]/span').click()
        fill_element(driver, '/html/body//div//label//div//input[@aria-label="Last Name"]', lasttname)
        driver.find_element(By.XPATH, '/html/body//div/button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contactmail)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + lasttname + '")]')) > 0, "Contact last name was not changed")
        print("OK")
        print("Try to delete contact...", end="")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contactmail)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//i')) > 0, "Contact was not deleted")
        print("OK")
        print("Try to create a new system contact with an invalid Email...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Add")]').click()
        driver.find_element(By.XPATH, '/html/body//div[@class="q-list"]/a[2]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Email")]/../div/input', "invaildmail")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div/main/form//div/label//div[contains(., "Input must be")]')) > 0)
        print("OK")
        print("Try to create a new system contact...", end="")
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Email")]/../div/input', contactmail)
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        print("OK")
        print("Check if system contact was created...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contactmail)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + contactmail + '")]')) > 0, "Contact was not found")
        print("OK")
        print("Try to add first and last name to contact...", end="")
        driver.find_element(By.XPATH, '//*[@data-cy="q-td--firstname"]/span').click()
        fill_element(driver, '/html/body//div//label//div//input[@aria-label="First Name"]', firstname)
        driver.find_element(By.XPATH, '/html/body//div/button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + firstname + '")]')) > 0, "Contact first name was not changed")
        driver.find_element(By.XPATH, '//*[@data-cy="q-td--lastname"]/span').click()
        fill_element(driver, '/html/body//div//label//div//input[@aria-label="Last Name"]', lasttname)
        driver.find_element(By.XPATH, '/html/body//div/button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contactmail)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + lasttname + '")]')) > 0, "Contact last name was not changed")
        print("OK")
        print("Try to edit and reset edits to system contact...", end="")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body//div/a[contains(., "Edit")]')))
        driver.find_element(By.XPATH, '/html/body//div/a[contains(., "Edit")]').click()
        fill_element(driver, '//*[@id="q-app"]//div/main//form//div/label//div/input[@aria-label="Company"]', contactmail)
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//button[@data-cy="aui-reset-button"]').click()
        self.assertTrue(
            driver.find_element(By.XPATH, '//input[@aria-label="Company"]').get_attribute('value') == '', 'Saved value is not correct')
        print("OK")
        filename = 0

    def test_contracts(self):
        global filename
        contractname = "customer" + str(random.randint(1, 99999))
        filename = "test_contracts.png"
        driver = self.driver
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        print("Go to 'Contracts'...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Contracts")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Contracts")]').click()
        print("OK")
        print("Try to create a new peering contract...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Add")]').click()
        driver.find_element(By.XPATH, '/html/body//div[@class="q-list"]/a[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Contact")]/../div/input', "default")
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        wait_for_invisibility(driver, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//main/form//div//label[contains(., "Status")]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "External")]/../div/input', contractname)
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//main/form//div//label[contains(., "Billing Profile")]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Save")]').click()
        print("OK")
        print("Check if contract has been created...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contractname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + contractname + '")]')) > 0, "Reseller was not found")
        print("OK")
        print("Try to edit contract status...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[8]/span').click()
        wait_for_invisibility(driver, '/html/body//div[@class="q-transition--fade-enter q-transition--fade-enter-active"]')
        click_js(driver, '/html/body//div//label//div/span[contains(., "Active")]')
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '/html/body//div[@class="q-item__label"][contains(., "Locked")]')))
        driver.find_element(By.XPATH, '/html/body//div[@class="q-item__label"][contains(., "Locked")]').click()
        wait_for_invisibility(driver, '/html/body/div[@role="listbox"]')
        driver.find_element(By.XPATH, '/html/body//div/button[contains(., "Save")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[8]/span[contains(., "Locked")]')) > 0, "Subscriber status was not edited")
        print("OK")
        print("Try to delete contract...", end="")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contractname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//i')) > 0, "Contact was not deleted")
        print("OK")
        print("Try to create a new reseller contract...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Add")]').click()
        driver.find_element(By.XPATH, '/html/body//div[@class="q-list"]/a[2]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Contact")]/../div/input', "default")
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        wait_for_invisibility(driver, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//main/form//div//label[contains(., "Status")]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "External")]/../div/input', contractname)
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//main/form//div//label[contains(., "Billing Profile")]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Save")]').click()
        print("OK")
        print("Check if contract has been created...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contractname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + contractname + '")]')) > 0, "Reseller was not found")
        print("OK")
        print("Try to edit contract status...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[8]/span').click()
        wait_for_invisibility(driver, '/html/body//div[@class="q-transition--fade-enter q-transition--fade-enter-active"]')
        click_js(driver, '/html/body//div//label//div/span[contains(., "Active")]')
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '/html/body//div[@class="q-item__label"][contains(., "Locked")]')))
        driver.find_element(By.XPATH, '/html/body//div[@class="q-item__label"][contains(., "Locked")]').click()
        wait_for_invisibility(driver, '/html/body/div[@role="listbox"]')
        click_js(driver, '/html/body//div/button[contains(., "Save")]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[8]/span[contains(., "Locked")]')) > 0, "Contract status was not edited")
        print("OK")
        print("Try to delete contract...", end="")
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]/div/div[2]/main/div[1]/div/div[1]/table/tbody/tr[1]/td[2]/button')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/div[2]/main/div[1]/div/div[1]/table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', contractname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//i')) > 0, "Contract was not deleted")
        print("OK")
        filename = 0

    def test_customer(self):
        global filename
        customername = "customer" + str(random.randint(1, 99999))
        filename = "test_customer.png"
        driver = self.driver
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        print("Go to 'Customers'...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Customers")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Customers")]').click()
        print("OK")
        print("Try to create a new customer...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/a[contains(., "Add")]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "External")]/../div/input', customername)
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//main/form//div//label[contains(., "Status")]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Contact")]/../div/input', "default")
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/div[2]/main/form/div/div[2]/div[1]/div[2]/div/label/div[1]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Save")]').click()
        print("OK")
        print("Check if customer has been created...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        driver.find_element(By.XPATH, '//label[@data-cy="aui-data-table-filter-criteria"]').click()
        time.sleep(1)
        driver.find_element(By.XPATH, '//div[@data-cy="q-item--2"]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', customername)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + customername + '")]')) > 0, "Reseller was not found")
        print("OK")
        print("Try to edit customer status...", end="")
        scroll_to_element(driver, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[11]/span')
        time.sleep(1)
        click_js(driver, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[@data-cy="q-td--status"]/span')
        wait_for_invisibility(driver, '/html/body//div[@class="q-transition--fade-enter q-transition--fade-enter-active"]')
        click_js(driver, '/html/body//div//label//div/span[contains(., "Active")]')
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '/html/body//div[@class="q-item__label"][contains(., "Locked")]')))
        driver.find_element(By.XPATH, '/html/body//div[@class="q-item__label"][contains(., "Locked")]').click()
        wait_for_invisibility(driver, '/html/body/div[@role="listbox"]')
        click_js(driver, '/html/body//div/button[contains(., "Save")]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[11]/span[contains(., "Locked")]')) > 0, "Customer status was not edited")
        print("OK")
        print("Go to customer preferences...", end="")
        click_js(driver, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[2]/button')
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body//div/a[contains(., "Preferences")]')))
        driver.find_element(By.XPATH, '/html/body//div/a[contains(., "Preferences")]').click()
        print("OK")
        print("Try to change a setting (concurrent_max)...", end="")
        driver.find_element(By.XPATH, '//button[@data-cy="aui-switch-old-panel-close"]').click()
        fill_element(driver, '/html/body//div//main//div//label//div/input[@aria-label="Maximum number of concurrent calls"]', 100)
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div//button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        self.assertTrue(
            driver.find_element(By.XPATH, '/html/body//div//main//div//label//div/input[@aria-label="Maximum number of concurrent calls"]').get_attribute('value') == '100',
            'Saved value is not correct')
        print("OK")
        print("Try to delete setting value and restoring it...", end="")
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div/i[@role="button"][@aria-label="Clear"]').click()
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div//button[@data-cy="preference-reset"]').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        self.assertTrue(
            driver.find_element(By.XPATH, '/html/body//div//main//div//label//div/input[@aria-label="Maximum number of concurrent calls"]').get_attribute('value') == '100',
            'Saved value is not correct')
        print("OK")
        print("Try to delete setting...", end="")
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div/i[@role="button"][@aria-label="Clear"]').click()
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div//button[@data-cy="preference-save"]').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        self.assertTrue(
            driver.find_element(By.XPATH, '/html/body//div//main//div//label//div/input[@aria-label="Maximum number of concurrent calls"]').get_attribute('value') == '', 'Saved value is not correct')
        print("OK")
        print("Try to delete customer...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Customers")]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', customername)
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + customername + '")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/div[2]/main/div[1]/div/div[1]/table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', customername)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//i')) > 0, "Reseller was not deleted")
        print("OK")
        filename = 0

    def test_domain(self):
        global filename
        domainname = "domain" + str(random.randint(1, 99999))
        filename = "test_domain.png"
        driver = self.driver
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        print("Go to 'Domains'...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Domains")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Domains")]').click()
        print("OK")
        print("Try to create a new domain...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/a[contains(., "add")]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Reseller")]/../div/input', 'default')
        click_js(driver, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[1]')
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Domain")]/../div/input', domainname)
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div//button[contains(., "Save")]').click()
        print("OK")
        print("Check if domain was created...", end="")
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//input[@data-cy="aui-input-search--datatable"]')))
        wait_for_invisibility(driver, 'div[@class="q-linear-progress"][@role="progressbar"]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', domainname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main/div//table/tbody/tr[1]/td[contains(., "' + domainname + '")]')) > 0, "Billing Profile was not found")
        print("OK")
        print("Try to open the domain preferences page...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10.).until(EC.element_to_be_clickable((By.XPATH, '/html/body//div/a[contains(., "Preferences")]')))
        driver.find_element(By.XPATH, '/html/body//div/a[contains(., "Preferences")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        print("OK")
        print("Try to change a setting (allowed_ips) with an invalid value...", end="")
        fill_element(driver, '/html/body//div//main//div//label//div/input[@aria-label="Allowed source IPs"]', 'invalid')
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div//button[contains(., "Add")]').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div//main//div//label//div//button[contains(., "Add")]')) > 0, "Incorrect value was saved")
        print("OK")
        print("Try to change a setting (allowed_ips) with a valid value...", end="")
        fill_element(driver, '/html/body//div//main//div//label//div/input[@aria-label="Allowed source IPs"]', '10.0.0.0')
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div//button[contains(., "Add")]').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div//main//div[contains(., "10.0.0.0")]')) > 0, 'Saved value is not correct')
        print("OK")
        print("Try to add two more IP addresses...", end="")
        fill_element(driver, '/html/body//div//main//div//label//div/input[@aria-label="Allowed source IPs"]', '10.0.0.1')
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div//button[contains(., "Add")]').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div//main//div[contains(., "10.0.0.1")]')) > 0, 'Saved value is not correct')
        fill_element(driver, '/html/body//div//main//div//label//div/input[@aria-label="Allowed source IPs"]', '10.0.0.2')
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div//button[contains(., "Add")]').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div//main//div[contains(., "10.0.0.2")]')) > 0, 'Saved value is not correct')
        print("OK")
        print("Try to delete one IP address...", end="")
        driver.find_element(By.XPATH, '/html/body//div//main//div[contains(., "10.0.0.0")]/../i').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        driver.implicitly_wait(1)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div//main//div[contains(., "10.0.0.0")]')) == 0, 'IP address 10.0.0.0 was not deleted')
        driver.implicitly_wait(10)
        print("OK")
        print("Try to delete all the other stored IP addresses...", end="")
        driver.find_element(By.XPATH, '/html/body//div//main//div//label//div/button[contains(., "Remove all")]').click()
        wait_for_invisibility(driver, '/html/body//div//main//div//label//div/svg[@class="q-spinner q-spinner-mat"]')
        driver.implicitly_wait(1)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div//main//div[contains(., "10.0.0.1")]')) == 0, 'IP address 10.0.0.1 was not deleted')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '/html/body//div//main//div[contains(., "10.0.0.2")]')) == 0, 'IP address 10.0.0.2 was not deleted')
        driver.implicitly_wait(10)
        print("OK")
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Domains")]').click()
        print("Try to delete domain...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', domainname)
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]/div/div[2]/main/div[1]/div/div[1]/table/tbody/tr[1]/td[2]/button')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/div[2]/main/div[1]/div/div[1]/table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        print("OK")
        print("Check if domain was deleted...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', domainname)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//i')) > 0, "Billing Profile was not deleted")
        print("OK")
        filename = 0

    def test_login_page(self):
        global filename
        filename = "test_login_page.png"
        driver = self.driver
        driver.get(os.environ['CATALYST_SERVER'] + ":1443")
        try:
            driver.implicitly_wait(1)
            driver.find_element(By.XPATH, '//*[@id="login_page_v1"]//div/b/a').click()
            driver.implicitly_wait(10)
        except:
            pass
        finally:
            driver.implicitly_wait(10)
        print("\nTry to login with no credentials...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]/div//main/div/form//button[contains(., "Sign In")]')))
        click_js(driver, '//*[@id="q-app"]/div//main/div/form//button[contains(., "Sign In")]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div[contains(., "Wrong credentials")]')) > 0, "Credentials werent rejected")
        print("OK")
        print("Try to login with false credentials...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@aria-label="Username"]')))
        fill_element(driver, '//*[@aria-label="Username"]', 'invalid')
        fill_element(driver, '//*[@aria-label="Password"]', 'data')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div/form//button[contains(., "Sign In")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div[contains(., "Wrong credentials")]')) > 0, "Credentials werent rejected")
        print("OK")
        print("Try to login with a wrong password...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@aria-label="Username"]')))
        fill_element(driver, '//*[@aria-label="Username"]', 'administrator')
        fill_element(driver, '//*[@aria-label="Password"]', 'ubvakud')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div/form//button[contains(., "Sign In")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div[contains(., "Wrong credentials")]')) > 0, "Credentials werent rejected")
        print("OK")
        print("Try to login with correct credentials...", end="")
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@aria-label="Username"]')))
        fill_element(driver, '//*[@aria-label="Username"]', 'administrator')
        fill_element(driver, '//*[@aria-label="Password"]', 'administrator')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main/div/form//button[contains(., "Sign In")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div[contains(., "Dashboard")]')) > 0, "Credentials werent accepted")
        print("OK")
        print("Try to logout...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div/button[@aria-label="UserMenu"]').click()
        driver.find_element(By.XPATH, '/html/body//div[@class="q-list"]/div[2]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="login-title"]')) > 0, "Logout wasnt successful")
        print("OK")
        filename = 0

    def test_other(self):
        global filename
        filename = "test_other.png"
        driver = self.driver
        login_panel(driver)
        filename = 0
        print("Try to search for page 'Customers'...", end="")
        fill_element(driver, '//*[@id="q-app"]//div/label//div//input[@aria-label="Search menu"]', "Customers")
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//aside//div//a[contains(., "Customers")]')) > 0, "Customers page wasnt found")
        print("OK")
        print("Try to access Customers page...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//aside//div//a[contains(., "Customers")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main/div[2]/div/div[contains(., "Customers")]')) > 0, "Customers page wasn't opened")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//aside//div/label/div/div/div[3]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//aside//div/a[contains(., "Dashboard")]').click()
        print("OK")
        print("Try to change language to German...", end="")
        driver.find_element(By.XPATH, '//*[@data-cy="aui-selection-language"]').click()
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body/div[4]/div/div[3]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//aside//div//a[contains(., "Übersicht")]')) > 0, "Language wasn't changed")
        print("OK")
        print("Try to change language to Spanish...", end="")
        driver.find_element(By.XPATH, '//*[@data-cy="aui-selection-language"]').click()
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body/div[4]/div/div[4]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//aside//div//a[contains(., "Tablero")]')) > 0, "Language wasn't changed")
        print("OK")
        print("Try to change language to French...", end="")
        driver.find_element(By.XPATH, '//*[@data-cy="aui-selection-language"]').click()
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body/div[4]/div/div[5]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//aside//div//a[contains(., "Tableau de bord")]')) > 0, "Language wasn't changed")
        print("OK")
        print("Try to change language to Italian...", end="")
        driver.find_element(By.XPATH, '//*[@data-cy="aui-selection-language"]').click()
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body/div[4]/div/div[6]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//aside//div//a[contains(., "Dashboard")]')) > 0, "Language wasn't changed")
        print("OK")
        print("Try to change language back to English...", end="")
        driver.find_element(By.XPATH, '//*[@data-cy="aui-selection-language"]').click()
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body/div[4]/div/div[2]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//aside//div//a[contains(., "Dashboard")]')) > 0, "Language wasn't changed")
        print("OK")
        print("Try to add Administrators and Resellers to favourites...", end="")
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Administrators")]')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div/aside/div//a[contains(., "Administrators")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/header/div/button[2]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div/aside/div//a[contains(., "Resellers")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/header/div/button[2]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//aside//div[@class="q-expansion-item__container relative-position"]/div[1]').click()
        time.sleep(1)
        print("OK")
        print("Check if webpages were added to favourites and unfavourite them afterwards...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//aside/div/div[2]/div[1]/div/div/div[3]/a[1]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main//div/a[contains(., "Administrators")]')) > 0, "Wrong webpage was opened")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/header/div/button[2]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//aside/div/div[2]/div[1]/div/div/div[3]/a[1]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main//div/a[contains(., "Resellers")]')) > 0, "Wrong webpage was opened")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/header/div/button[2]').click()
        print("OK")

    def test_reseller(self):
        global filename
        resellername = "reseller" + str(random.randint(1, 99999))
        resellercontract = "contract" + str(random.randint(1, 99999))
        filename = "test_reseller.png"
        driver = self.driver
        login_panel(driver)
        driver.find_element(By.XPATH, '//div[@data-cy="aui-main-menu-items--settings"]').click()
        create_reseller_contract(driver, resellercontract)
        print("Try to create a new Reseller...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Resellers")]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/a[contains(., "Add")]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Contract")]/../div/input', resellercontract)
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body//div/div[@class="q-virtual-scroll__content"]/div[1]')))
        driver.find_element(By.XPATH, '/html/body//div/div[@class="q-virtual-scroll__content"]/div[1]').click()
        fill_element(driver, '//*[@id="q-app"]/div//main/form/div//label//div[contains(., "Name")]/../div/input',  resellername)
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//main//div/button[contains(., "Save")]').click()
        print("OK")
        print("Check if reseller has been created...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', resellername)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + resellername + '")]')) > 0, "Reseller was not found")
        print("OK")
        print("Try to rename reseller...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/table/tbody/tr[1]/td[5]/span').click()
        resellername = "reseller" + str(random.randint(1, 99999))
        fill_element(driver, '/html/body//div//label//div//input[@aria-label="Name"]', resellername)
        driver.find_element(By.XPATH, '/html/body//div/button[contains(., "Save")]').click()
        print("OK")
        print("Check if reseller name was changed...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', resellername)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "' + resellername + '")]')) > 0, "Reseller name was not changed")
        print("OK")
        print("Try to edit reseller status...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[6]/span').click()
        wait_for_invisibility(driver, '/html/body//div[@class="q-transition--fade-enter q-transition--fade-enter-active"]')
        click_js(driver, '/html/body//div//label//div/span[contains(., "Active")]')
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '/html/body//div[@class="q-item__label"][contains(., "Locked")]')))
        driver.find_element(By.XPATH, '/html/body//div[@class="q-item__label"][contains(., "Locked")]').click()
        wait_for_invisibility(driver, '/html/body/div[@role="listbox"]')
        driver.find_element(By.XPATH, '/html/body//div/button[contains(., "Save")]').click()
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[6]/span[contains(., "Locked")]')) > 0, "Subscriber status was not edited")
        print("OK")
        driver.implicitly_wait(10)
        print("Try to open the reseller edit page...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10.).until(EC.element_to_be_clickable((By.XPATH, '/html/body//div/a[contains(., "Edit")]')))
        driver.find_element(By.XPATH, '/html/body//div/a[contains(., "Edit")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        print("OK")
        print("Try to edit reseller status...", end="")
        driver.find_element(By.XPATH, '//label[@data-cy="reseller-status"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[2]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[1]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        click_js(driver, '//*[@id="q-app"]/div//main//div/button[contains(., "Close")]')
        print("OK")
        print("Check if reseller staus has been changed...", end="")
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', resellername)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//table/tbody/tr[1]/td[contains(., "Active")]')) > 0, "Status was not changed")
        print("OK")
        print("Go to reseller details page...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10.).until(EC.element_to_be_clickable((By.XPATH, '/html/body//div/a[contains(., "Edit")]')))
        driver.find_element(By.XPATH, '/html/body//div/a[contains(., "Details")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        print("OK")
        print("Check if reseller base information is correct...", end="")
        self.assertTrue(driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table//tr/td[2]').text == resellername, "Reseller name is not correct")
        print("OK")
        print("Try to edit reseller information...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table//tr/td[4]/button').click()
        time.sleep(1)
        click_js(driver, '//a[@data-cy="aui-popup-menu-item--reseller-edit"]')
        driver.find_element(By.XPATH, '//label[@data-cy="reseller-status"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[2]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[2]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        click_js(driver, '//*[@id="q-app"]/div//main//div/button[contains(., "Close")]')
        print("OK")
        print("Check if reseller status was changed...", end="")
        self.assertTrue(driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table//tr/td[3]').text == "locked", "Reseller status is not correct")
        print("OK")
        print("Check if reseller contract information is correct...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//aside//a[contains(., "Reseller Contract")]').click()
        self.assertTrue(driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table//tr/td[2]').text == resellercontract, "Reseller contract name is not correct")
        print("OK")
        print("Try to edit reseller contract information...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table//tr/td[6]/button').click()
        time.sleep(1)
        click_js(driver, '//a[@data-cy="aui-popup-menu-item--contract-edit"]')
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//form/div/div[1]/div[1]/div[4]/div/label').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '/html/body/div//div[@class="q-virtual-scroll__content"]/div[2]')))
        time.sleep(1)
        driver.find_element(By.XPATH, '/html/body//div[@class="q-virtual-scroll__content"]/div[2]').click()
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div/button[contains(., "Save")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div[@role="progressbar"]')
        click_js(driver, '//*[@id="q-app"]/div//main//div/button[contains(., "Close")]')
        print("OK")
        print("Check if reseller contract status was changed...", end="")
        self.assertTrue(driver.find_element(By.XPATH, '//*[@id="q-app"]/div//main//div//table//tr/td[5]').text == "pending", "Reseller contract status is not correct")
        print("Try to delete Reseller...", end="")
        driver.find_element(By.XPATH, '//*[@id="q-app"]//div//aside//div//a[contains(., "Resellers")]').click()
        wait_for_invisibility(driver, '//*[@id="q-app"]/div//main//div/table/thead/tr[2]/th/div[@role="progressbar"]')
        WebDriverWait(driver, 10).until(EC.element_to_be_clickable((By.XPATH, '//*[@id="q-app"]/div/div[2]/main/div[1]/div/div[1]/table/tbody/tr[1]/td[2]/button')))
        driver.find_element(By.XPATH, '//*[@id="q-app"]/div/div[2]/main/div[1]/div/div[1]/table/tbody/tr[1]/td[2]/button').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]')))
        driver.find_element(By.XPATH, '//div[@data-cy="aui-data-table-row-menu--delete"]').click()
        WebDriverWait(driver, 10).until(EC.visibility_of_element_located((By.XPATH, '//button[@data-cy="btn-confirm"]')))
        driver.find_element(By.XPATH, '//button[@data-cy="btn-confirm"]').click()
        wait_for_invisibility(driver, '//input[@data-cy="aui-input-search--datatable"][@disabled]')
        fill_element(driver, '//input[@data-cy="aui-input-search--datatable"]', resellername)
        self.assertTrue(
            len(driver.find_elements(By.XPATH, '//*[@id="q-app"]//div//main//div//i')) > 0, "Reseller was not deleted")
        print("OK")
        filename = 0

    def tearDown(self):
        global filename
        driver = self.driver
        if filename:
            print("FAIL")
            driver.save_screenshot('/results/' + filename)
            filename = 0
        driver.quit()

if __name__ == '__main__':
    browser = os.environ['BROWSER']
    if browser == "all":
        print('----------------------------------------------------------------------')
        print('Running NGCP Panel tests now! (Browser: Firefox + Chrome)')
        print('----------------------------------------------------------------------')
        browser = "firefox"
        nose2.main(exit=False)
        browser = "chrome"
        nose2.main(exit=False)
    else:
        print('----------------------------------------------------------------------')
        print('Running NGCP Panel tests now! (Browser: ' + os.environ['BROWSER'].capitalize() + ')')
        print('----------------------------------------------------------------------')
        nose2.main(exit=False)
