package NGCP::Schema::Result::cdr_period_costs;

use strict;
use warnings;

use Scalar::Util qw(blessed);
use parent 'DBIx::Class::Core';

our $VERSION = '2.007';

__PACKAGE__->load_components("InflateColumn::DateTime", "Helper::Row::ToJSON");

__PACKAGE__->table("accounting.cdr_period_costs");

__PACKAGE__->add_columns(
  "id",
  {
      data_type => "integer",
      extra => { unsigned => 1 },
      is_nullable => 0,
      is_auto_increment => 1,
  },
  "contract_id",
  {
    data_type => "integer",
    extra => { unsigned => 1 },
    is_nullable => 0,
  },
  "period",
  {
    data_type => "enum",
    extra => { list => ["month", "day"] },
    is_nullable => 0,
  },
  "period_date",
  {
    data_type => "date",
    is_nullable => 0,
  },
  "direction",
  {
    data_type => "enum",
    default_value => "out",
    extra => { list => ["out", "in"] },
    is_nullable => 0,
  },
  "customer_cost",
  { data_type => "decimal",
    default_value => "0.000000",
    size => [14, 6],
    is_nullable => 0,
  },
  "reseller_cost",
  { data_type => "decimal",
    default_value => "0.000000",
    size => [14, 6],
    is_nullable => 0,
  },
  "cdr_count",
  {
    data_type => "integer",
    default_value => 0,
    extra => { unsigned => 1 },
    is_nullable => 0,
  },
  "fraud_limit_exceeded",
  {
    data_type => "tinyint",
    is_nullable => 1,
  },
  "fraud_limit_type",
  {
    data_type => "enum",
    extra => { list => ["contract", "billing_profile"] },
    is_nullable => 1,
  },
  "notify_status",
  {
    data_type => "enum",
    default_value => "new",
    extra => { list => ["new", "notified"] },
    is_nullable => 0,
  },
  "notified_at",
  {
    data_type => "datetime",
    is_nullable => 1,
  },
  "first_cdr_start_time",
  { data_type => "decimal",
    size => [13, 3],
    is_nullable => 0,
  },
  "first_cdr_id",
  {
    data_type => "integer",
    extra => { unsigned => 1 },
    is_nullable => 0,
  },
  "last_cdr_start_time",
  { data_type => "decimal",
    size => [13, 3],
    is_nullable => 0,
  },
  "last_cdr_id",
  {
    data_type => "integer",
    extra => { unsigned => 1 },
    is_nullable => 0,
  },
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->belongs_to(
  "contract",
  "NGCP::Schema::Result::contracts",
  { id => "contract_id" },
  { cascade_copy => 0, cascade_delete => 0 },
);

__PACKAGE__->belongs_to(
  "first_cdr",
  "NGCP::Schema::Result::cdr",
  { id => "first_cdr_start_id" },
  { cascade_copy => 0, cascade_delete => 0 },
);

__PACKAGE__->belongs_to(
  "last_cdr",
  "NGCP::Schema::Result::cdr",
  { id => "last_cdr_start_id" },
  { cascade_copy => 0, cascade_delete => 0 },
);

sub TO_JSON {
    my ($self) = @_;
    return {
        map { blessed($_) && $_->isa('DateTime') ? $_->datetime : $_ } %{ $self->next::method }
    };
}

1;

__END__

=encoding UTF-8

=head1 NAME

NGCP::Schema::Result::cdr_period_costs

=head1 DESCRIPTION

This module is a schema class for the NGCP database table "accouning.cdr_period_costs".

=head1 COMPONENTS LOADED

=over 4

=item * L<DBIx::Class::InflateColumn::DateTime>

=item * L<DBIx::Class::Helper::Row::ToJSON>

=back

=head1 TABLE: C<accounting.cdr_period_costs>

=head1 ACCESSORS

=head2 id

  data_type: 'integer'
  extra: {unsigned => 1}
  is_nullable: 0
  is_auto_increment: 1

=head2 contract_id

  data_type: 'integer'
  extra: {unsigned => 1}
  is_nullable: 0

=head2 period

  data_type: "enum"
  extra: { list => ["month", "day"] }
  is_nullable: 0

=head2 period_date

  data_type: "datetime"
  is_nullable: 0

=head2 direction

  data_type: "enum"
  default_value: "out"
  extra: { list => ["out", "in"] }
  is_nullable: 0

=head2 customer_cost

  data_type: "decimal"
  default_value: "0.000000"
  size: [14, 6]
  is_nullable: 0

=head2 reseller_cost

  data_type: "decimal"
  default_value: "0.000000"
  size: [14, 6]
  is_nullable: 0

=head2 cdr_count

  data_type: 'integer'
  default_value: 0
  extra: {unsigned => 1}
  is_nullable: 0

=head2 fraud_limit_exceeded

  data_type: 'tinyint'
  is_nullable: 1

=head2 fraud_limit_type

  data_type: "enum"
  extra: { list => ["contract", "billing_profile"] }
  is_nullable: 1

=head2 notify_status

  data_type: "enum"
  default_value: "new"
  extra: { list => ["new", "notified"] }
  is_nullable: 0

=head2 notified_at

  data_type: 'datetime'
  is_nullable: 1

=head2 first_cdr_start_time

  data_type: "decimal"
  size: [13, 3]
  is_nullable: 0

=head2 first_cdr_start_id

  data_type: 'integer'
  extra: {unsigned => 1}
  is_nullable: 0

=head2 last_cdr_start_time

  data_type: "decimal"
  size: [13, 3]
  is_nullable: 0

=head2 last_cdr_start_id

  data_type: 'integer'
  extra: {unsigned => 1}
  is_nullable: 0

=head1 PRIMARY KEY

=over 4

=item * L</contract_id>
=item * L</period>
=item * L</period_date>
=item * L</direction>

=back

=head1 RELATIONS

=head2 contact

Type: belongs_to

Related object: L<NGCP::Schema::Result::contacts>

=head2 first_cdr_start_time

Type: belongs_to

Related object: L<NGCP::Schema::Result::cdr>

=head2 last_cdr_start_time

Type: belongs_to

Related object: L<NGCP::Schema::Result::cdr>

=head1 AUTHOR

Sipwise Development Team C<< <support@sipwise.com> >>

=head1 LICENSE

This software is Copyright © 2019 by Sipwise GmbH, Austria.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this package.  If not, see <https://www.gnu.org/licenses/>.
