package NGCP::Schema::Result::reseller_brandings;

use strict;
use warnings;

use Scalar::Util qw(blessed);
use parent 'DBIx::Class::Core';

our $VERSION = '2.007';

__PACKAGE__->load_components("InflateColumn::DateTime", "Helper::Row::ToJSON");

__PACKAGE__->table("billing.reseller_brandings");

__PACKAGE__->add_columns(
  "id",
  {
    data_type => "integer",
    extra => { unsigned => 1 },
    is_auto_increment => 1,
    is_nullable => 0,
  },
  "reseller_id",
  { data_type => "integer", extra => { unsigned => 1 }, is_nullable => 0 },
  "logo",
  { data_type => "mediumblob", is_nullable => 1 },
  "logo_image_type",
  { data_type => "varchar", is_nullable => 1, size => 32 },
  "css",
  { data_type => "mediumtext", is_nullable => 1 },
  "csc_color_primary",
  { data_type => "varchar", is_nullable => 1, size => 45 },
  "csc_color_secondary",
  { data_type => "varchar", is_nullable => 1, size => 45 },

);

__PACKAGE__->belongs_to(
  "reseller",
  "NGCP::Schema::Result::resellers",
  { id => "reseller_id" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "CASCADE",
    on_update     => "CASCADE",
  }
);

__PACKAGE__->set_primary_key("id");

sub TO_JSON {
    my ($self) = @_;
    return {
        map { blessed($_) && $_->isa('DateTime') ? $_->datetime : $_ } %{ $self->next::method }
    };
}

1;
