import os
import sipconfig

# The name of the SIP build file generated by SIP and used by the build
# system.
build_file = "py_sems.sbf"

# Get the SIP configuration information.
config = sipconfig.Configuration()

# Run SIP to generate the code.
os.system(" ".join([config.sip_bin, "-c", ".", "-b", build_file, "-r", "py_sems.sip"]))

# Create the Makefile.
makefile = sipconfig.SIPModuleMakefile(config, build_file, makefile="Makefile.gen")

makefile.extra_cxxflags = ["-Wall -Wno-reorder -g"]
makefile.extra_include_dirs = ["$(COREPATH)"]
makefile.extra_lflags = ["-g"]
makefile._warnings = 0

# Generate the Makefile itself.
makefile.generate()
