/*
 * Copyright (C) 2010 Stefan Sayer
 *
 * This file is part of SEMS, a free SIP media server.
 *
 * SEMS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * For a license to use the SEMS software under conditions
 * other than those described here, or to purchase support for this
 * software, please contact iptel.org by e-mail at the following addresses:
 *    info@iptel.org
 *
 * SEMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _SDPFilter_h_
#define _SDPFilter_h_

#include "HeaderFilter.h" // filtertype
#include "AmSdp.h"

#include <string>
using std::string;

#include <set>


int filterSDP(AmSdp& sdp, const vector<FilterEntry>& filter_list);
int filterSDPalines(AmSdp& sdp, const vector<FilterEntry>& filter_list);
int filterMedia(AmSdp& sdp, const vector<FilterEntry>& filter_list);

/** normalize SDP, fixing some common issues and anonymize (IP addresses
 * replaced in such case by advertised_ip) */
int normalizeSDP(AmSdp& sdp, bool anonymize_sdp, const string &advertised_ip);

#endif
