#
# Voicemail plug-in configuration file
#
#

#
# Generic settings: applicable in any operation mode
#

#
# Default Voicemail mode:
#  This sets the main operation mode of this plug-in.
#
# - 0: voicemail classic (only send an email)
# - 1: voicebox (message stored through the msg_storage plug-in; query with the voicebox app)
# - 2: both (send an email AND store with msg_storage)
# - 3: announcement (play the annoucement but do not record anything)
#
# Default value: 0
#
default_vm_mode=0

#
# Simple mode:
#
#  If the simple mode is activated, the user part of the 
#  request URI is used as the key to store the voicemails. 
#
#  When the simple mode is de-activated (default), several parameters
#  have to be passed to SEMS either through the 'P-App-Param' header field
#  (together with the 'P-App-Name' header field), or through R-URI parameters.
#
#  Please note that the simple mode requires a default email address if
#  either the 'voicemail' or 'both' operation mode has been chosen
#  (see 'email_address' configuration parameter).
#
# Default value: no
#
#simple_mode=yes

#
# maximum voicemail message length, in seconds.
# After the maximum time, the call is ended by SEMS.
#
max_record_time=30

#
# optional: minimum voicemail message length, in milliseconds
# no voicemail is sent if the recorded message is shorter than
# or equal to the value set here.
# example - do not send voicemail shorter than 1.5s: 
#  min_record_time=1500
# default: 0
#min_record_time=0

# rec_file_ext : extension to recorded file, determines file
# format (wav, mp3; need mp3 plugin loaded for mp3)
# default is 'wav'
#
# example: 
#   rec_file_ext=mp3
#

# try_personal_greeting=[yes|no]
# optional: try to get a personal greeting from msg_storage mod?
# these can be recorded with annrecorder app
#
# Default:
#  try_personal_greeting=no
try_personal_greeting=yes

#
# These settings are needed if you keep audio and template files in MySQL database:
# (voicemail must have been compiled with MySQL support)
#
#mysql_host=localhost
#mysql_user=sems
#mysql_passwd=sems
#mysql_db=sems

# These settings are needed if you keep audio and template files in file system:
#
# path from which announcements are played:
announce_path=${SEMS_AUDIO_PREFIX}/sems/audio/voicemail/
#
# announcement played if no user/domain specific prompt found
default_announce=default_en.wav

#
# Options specific to the voicemail mode (and 'both')
#

# if set, this overrides any other email address, meaning that
# the voicemail will always be sent to that address.
#
# email_address = blub@mail.domain.net

#
# optional parameter: smtp_server=<hostname>
#
# - sets address of smtp server
#
# Default: localhost
#smtp_server=mail

# optional parameter: smtp_port=<port>
#
# - sets port of smtp server
#
# Default: 25
#smtp_port=25

#
# path for email templates:
email_template_path=${SEMS_CFG_PREFIX}/etc/sems/

# mail_header_vars=var1;var2;var3;...
#
# Variables that are substituted in the email template with 
# values from App-Param header (comma-separated list).
# 
# Example:
#   mail_header_vars=msg_count;sender_count
#
#   P-App-Param: user=...;eml=...;msg_count=10;sender_count=2
#
#   email.template: In your voicebox are %msg_count% messages, 
#                   %sender_count% from this sender.
#
# Default: none


#
# These options are applicable to all configurations:
#
