FIND_PACKAGE(PythonLibs)

IF(PYTHONLIBS_FOUND OR PYTHON_LIBRARIES)

	GET_FILENAME_COMPONENT(PYTHON_LD_PATH ${PYTHON_LIBRARIES} PATH)

	FIND_PATH(SIP_INCLUDE_DIR sip.h PATHS ${PYTHON_INCLUDE_PATH})
	FIND_PROGRAM(SIP_BINARY sip)

	IF(SIP_INCLUDE_DIR AND SIP_BINARY)
		SET(SIP_FOUND TRUE)
	ENDIF(SIP_INCLUDE_DIR AND SIP_BINARY)

	IF(SIP_FOUND)
		IF (NOT SIP_FIND_QUIETLY)
			MESSAGE(STATUS "Found sip includes:	${SIP_INCLUDE_DIR}/sip.h")
			MESSAGE(STATUS "Found sip binary:	${SIP_BINARY}")
		ENDIF (NOT SIP_FIND_QUIETLY)
	ELSE(SIP_FOUND)
		IF (SIP_FIND_REQUIRED)
			MESSAGE(FATAL_ERROR "Could NOT find sip development files")
		ENDIF (SIP_FIND_REQUIRED)
	ENDIF(SIP_FOUND)

ENDIF(PYTHONLIBS_FOUND OR PYTHON_LIBRARIES)

