/*
 * Copyright (C) 2010-2011 Raphael Coeffic
 *
 * This file is part of SEMS, a free SIP media server.
 *
 * SEMS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. This program is released under
 * the GPL with the additional exemption that compiling, linking,
 * and/or using OpenSSL is allowed.
 *
 * For a license to use the SEMS software under conditions
 * other than those described here, or to purchase support for this
 * software, please contact iptel.org by e-mail at the following addresses:
 *    info@iptel.org
 *
 * SEMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/** @file AmOfferAnswer.h */
#ifndef AmOfferAnswer_h
#define AmOfferAnswer_h

#include "AmSdp.h"
#include "AmSipMsg.h"

class AmSipDialog;

class AmOfferAnswer 
{
public:
  enum OAState {
    OA_None=0,
    OA_OfferRecved,
    OA_OfferSent,
    OA_PreviewCompleted, // see RFC6337, section 3.1.1
    OA_Completed,
    __max_OA
  };

private:
  OAState      state;
  OAState      saved_state;
  unsigned int cseq;
  string       remote_tag;
  AmSdp        sdp_remote;
  AmSdp        sdp_local;

  /* saved remote port */
  unsigned int remote_port_seen;

  AmSipDialog* dlg;

  /** Should SDP generation be forced when not required by standards? */
  bool force_sdp;

  /** State maintenance */
  void saveState();
  int  checkStateChange();

  /** SDP handling */
  int  onRxSdp(unsigned int m_cseq, const string& m_remote_tag,
               bool is_reliable, const AmMimeBody& body,
               const char** err_txt);
  int  onTxSdp(unsigned int m_cseq, bool is_reliable, const AmMimeBody& body, bool force_no_sdp_update = false);
  int  getSdpBody(string& sdp_body);

public:
  /** Constructor */
  AmOfferAnswer(AmSipDialog* dlg);

  /** Accessors */
  OAState getState() const;
  OAState getSavedState() { return saved_state; }
  void setState(OAState n_st);
  const AmSdp& getLocalSdp() const;
  const AmSdp& getRemoteSdp() const;
  const unsigned int& getRemoteMediaPort() const;

  void clear();
  void clearTransitionalState();

  void setForceSDP(bool force) { force_sdp = force; }
  bool getForceSDP() const { return force_sdp; }

  /** Event handlers */
  int onRequestIn(const AmSipRequest& req);
  int onReplyIn(const AmSipReply& reply);
  int onRequestOut(AmSipRequest& req);
  /* `no_sdp_generation` - can be used for cases like absent SDP in coming INVITE */
  int onReplyOut(AmSipReply& reply, int &flags, AmMimeBody &ret_body, bool no_sdp_generation = false);
  int onRequestSent(const AmSipRequest& req);
  int onReplySent(const AmSipReply& reply);
  void onNoAck(unsigned int ack_cseq);
};

#endif
