package NGCP::Log::Functions;

=encoding utf8

=head1 NAME

NGCP::Log::Functions - functions interface for NGCP::Log

=head1 DESCRIPTION

The NGCP::Log::Functions is a functions interface wrapper over the NGCP::Log
object class.

A default logger object is created on module load, so that any of the
functions provided work out of the box. If the default logger is not suitable,
a new one can be created to replace the default with B<create_logger()>.

=cut

use strict;
use warnings;

use Exporter qw(import);
use NGCP::Log;

our $VERSION = '0.01';
our @EXPORT = qw(
    create_logger
    reload_logger
    sysfatal
    fatal
    error
    warning
    notice
    info
    debug
);

my $log;

=head1 FUNCTIONS

=over 4

=item create_logger(%opts)

Creates a new internal NGCP::Log object so that its methods can be used.
It accepts all of its options.

=cut

sub create_logger
{
    my (%opts) = @_;

    $log = NGCP::Log->new(%opts);
}

BEGIN {
    create_logger();
};

=item reload_logger()

Calls the L<NGCP::Log> B<reload> method.

=cut

sub reload_logger
{
    $log->reload();
}

=item sysfatal($msg)

Calls the L<NGCP::Log> B<sysfatal> method.

=cut

sub sysfatal
{
    $log->sysfatal(@_);
}

=item fatal($msg)

Calls the L<NGCP::Log> B<fatal> method.

=cut

sub fatal
{
    $log->fatal(@_);
}

=item error($msg)

Calls the L<NGCP::Log> B<error> method.

=cut

sub error
{
    $log->error(@_);
}

=item warning($msg)

Calls the L<NGCP::Log> B<warning> method.

=cut

sub warning
{
    $log->warning(@_);
}

=item notice($msg)

Calls the L<NGCP::Log> B<notice> method.

=cut

sub notice
{
    $log->notice(@_);
}

=item info($msg)

Calls the L<NGCP::Log> B<info> method.

=cut

sub info
{
    $log->info(@_);
}

=item debug($msg)

Calls the L<NGCP::Log> B<debug> method.

=cut

sub debug
{
    $log->debug(@_);
}

=back

=head1 BUGS AND LIMITATIONS

Please report problems you notice to the Sipwise
Development Team <support@sipwise.com>.

=head1 AUTHOR

Guillem Jover <gjover@sipwise.com>

=head1 LICENSE

Copyright (C) 2021 Sipwise GmbH, Austria

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

=cut

1;
