#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 4;
use Errno qw(ENOENT);
use File::Path qw(make_path rmtree);
use File::Compare;

use_ok('NGCP::Log');

my $tmpdir = $ENV{RESULTS} // 't.tmp';
my $testlog = "$tmpdir/test.log";

# Make sure we are running on a clean temporary tree.
rmtree($tmpdir);
make_path($tmpdir);

my $log;

$log = NGCP::Log->new(
    progname => 'test-log',
    output => $testlog,
);

$log->debug('debug message, not shown by default');
$log->info('info message, shown by default');
$log->warning('warning message, shown by default');
$log->error('error message, shown by default');
eval {
    $log->fatal('fatal message, shown by default; terminate program');
    1;
};
ok($@, 'fatal tried to terminate the program');
eval {
    local $! = ENOENT;
    $log->sysfatal('sysfatal message, shown by default; terminate program');
    1;
};
ok($@, 'sysfatal tried to terminate the program');

ok(compare("t/NGCP_Log/default.log", $testlog) == 0,
    'default log contains expected output');

1;
