#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 7;

use_ok('NGCP::Service::IO');

delete local $ENV{NGCP_ROOT_DIR};
is(get_root_dir(), '', 'no envvar, empty root dir');

ok(execute([ '/bin/true' ]) == 0, 'global true');
ok(execute([ '/bin/false' ]) != 0, 'global false');

my $rc = 10;
my $stub_missing = 0;
eval {
    $rc = execute([ '/bin/stub-prog' ]);
} or do {
    $stub_missing = 1;
};
ok($stub_missing && $rc == 10, 'missing global stub program');

local $ENV{NGCP_ROOT_DIR} = 't/mock';
is(get_root_dir(), 't/mock', 'envvar, mock root dir');

ok(execute([ '/bin/stub-prog' ]) == 1, 'mock stub');

1;
