from abc import ABC, abstractmethod

from .logger import Logger


class Base(ABC):
    """Base class.

    Implements functionality that is used by most of the modules.
    Inherits ABC

    Attributes:
        _logger (Logger): logger instance of the subclass
        log (Logger): access to the logger by subclasses

    """
    _logger: Logger
    log: Logger

    def __init__(self) -> None:
        """Constructor for Base class.

        Assigns self._logger to self.log to enable
        subclasses to use self.log

        Args:
            None

        Returns:
            None

        """
        self.log = self._logger
        super().__init__()
