import glob
import importlib
import os

brokers_list = []
"""Loaded backend modules list.

Contains a list of modules that are found and loaded by the
search logic below, exports the variable into __all__ and it's
used in the App module
"""
for f in glob.glob(os.path.dirname(__file__) + '/*.py'):
    if os.path.isfile(f) and not os.path.basename(f).startswith('_'):
        module: str = os.path.basename(f)[:-3]
        globals()[module] = importlib.import_module('.' + module,
                                                    package=__name__)
        brokers_list.append(globals()[module])

__all__ = brokers_list
