/*
 * SpanDSP - a series of DSP components for telephony
 *
 * v34_superconstellation_map.h - ITU V.34 modem superconstellation mapping.
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2009 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* The 1/4 superconstellation from Figure 5/V.34

 45                                       408 396 394 400 414

 41                           398 375 349 339 329 326 335 347 359 386

 37                   412 371 340 314 290 279 269 265 273 281 302 322 353 390

 33               401 357 318 282 257 236 224 216 212 218 228 247 270 298 337 378

 29           406 350 306 266 234 206 185 173 164 162 170 181 197 220 253 288 327 379

 25           360 310 263 226 193 165 146 133 123 121 125 137 154 179 207 242 289 338 391

 21       384 324 277 229 189 156 131 110  96  87  83  92 100 117 140 172 208 254 299 354

 17       355 294 243 201 160 126  98  79  64  58  54  62  71  90 112 141 180 221 271 323 387

 13   392 330 274 222 177 135 102  77  55  41  35  31  37  48  65  91 118 155 198 248 303 361

  9   380 316 255 203 158 119  84  60  39  24  17  15  20  30  49  72 101 138 182 230 283 348 415

  5   367 304 244 194 148 108  75  50  28  13   6   4   8  21  38  63  93 127 171 219 275 336 402

  1   362 296 238 186 142 103  69  43  22   9   1   0   5  16  32  56  85 122 163 213 267 328 395

 -3   365 300 240 190 144 106  73  45  25  11   3   2   7  18  36  59  88 124 166 217 272 331 397

 -7   372 307 251 199 152 113  80  52  33  19  12  10  14  26  42  66  97 134 174 225 280 341 409

-11   388 320 261 210 167 128 94   67  47  34  27  23  29  40  57  81 111 147 187 237 291 351

-15   410 343 284 232 183 149 115  89  68  53  46  44  51  61  78  99 132 168 209 258 315 376

-19       369 311 259 214 175 139 116  95  82  74  70  76 86  104 129 157 195 235 285 342 399

-23       403 345 292 249 205 176 150 130 114 107 105 109 120 136 161 191 227 268 319 373

-27           382 332 287 250 215 184 169 153 145 143 151 159 178 202 231 264 308 358 413

-31               377 333 293 260 233 211 200 192 188 196 204 223 245 278 312 352 404

-35                   383 346 313 286 262 252 241 239 246 256 276 295 325 363 407

-39                       405 370 344 321 309 301 297 305 317 334 356 385

-43                               411 389 374 366 364 368 381 393

      -43 -39 -35 -31 -27 -23 -19 -15 -11  -7  -3   1   5  9   13  17  21  25  29  33  37  41  45
*/

static const int8_t v34_superconstellation[1664/4][2] =
{
    {  1,   1},   /*    0 */
    { -3,   1},   /*    1 */
    {  1,  -3},   /*    2 */
    { -3,  -3},   /*    3 */
    {  1,   5},   /*    4 */
    {  5,   1},   /*    5 */
    { -3,   5},   /*    6 */
    {  5,  -3},   /*    7 */
    {  5,   5},   /*    8 */
    { -7,   1},   /*    9 */
    {  1,  -7},   /*   10 */
    { -7,  -3},   /*   11 */
    { -3,  -7},   /*   12 */
    { -7,   5},   /*   13 */
    {  5,  -7},   /*   14 */
    {  1,   9},   /*   15 */
    {  9,   1},   /*   16 */
    { -3,   9},   /*   17 */
    {  9,  -3},   /*   18 */
    { -7,  -7},   /*   19 */
    {  5,   9},   /*   20 */
    {  9,   5},   /*   21 */
    {-11,   1},   /*   22 */
    {  1, -11},   /*   23 */
    { -7,   9},   /*   24 */
    {-11,  -3},   /*   25 */
    {  9,  -7},   /*   26 */
    { -3, -11},   /*   27 */
    {-11,   5},   /*   28 */
    {  5, -11},   /*   29 */
    {  9,   9},   /*   30 */
    {  1,  13},   /*   31 */
    { 13,   1},   /*   32 */
    {-11,  -7},   /*   33 */
    { -7, -11},   /*   34 */
    { -3,  13},   /*   35 */
    { 13,  -3},   /*   36 */
    {  5,  13},   /*   37 */
    { 13,   5},   /*   38 */
    {-11,   9},   /*   39 */
    {  9, -11},   /*   40 */
    { -7,  13},   /*   41 */
    { 13,  -7},   /*   42 */
    {-15,   1},   /*   43 */
    {  1, -15},   /*   44 */
    {-15,  -3},   /*   45 */
    { -3, -15},   /*   46 */
    {-11, -11},   /*   47 */
    {  9,  13},   /*   48 */
    { 13,   9},   /*   49 */
    {-15,   5},   /*   50 */
    {  5, -15},   /*   51 */
    {-15,  -7},   /*   52 */
    { -7, -15},   /*   53 */
    {  1,  17},   /*   54 */
    {-11,  13},   /*   55 */
    { 17,   1},   /*   56 */
    { 13, -11},   /*   57 */
    { -3,  17},   /*   58 */
    { 17,  -3},   /*   59 */
    {-15,   9},   /*   60 */
    {  9, -15},   /*   61 */
    {  5,  17},   /*   62 */
    { 17,   5},   /*   63 */
    { -7,  17},   /*   64 */
    { 13,  13},   /*   65 */
    { 17,  -7},   /*   66 */
    {-15, -11},   /*   67 */
    {-11, -15},   /*   68 */
    {-19,   1},   /*   69 */
    {  1, -19},   /*   70 */
    {  9,  17},   /*   71 */
    { 17,   9},   /*   72 */
    {-19,  -3},   /*   73 */
    { -3, -19},   /*   74 */
    {-19,   5},   /*   75 */
    {  5, -19},   /*   76 */
    {-15,  13},   /*   77 */
    { 13, -15},   /*   78 */
    {-11,  17},   /*   79 */
    {-19,  -7},   /*   80 */
    { 17, -11},   /*   81 */
    { -7, -19},   /*   82 */
    {  1,  21},   /*   83 */
    {-19,   9},   /*   84 */
    { 21,   1},   /*   85 */
    {  9, -19},   /*   86 */
    { -3,  21},   /*   87 */
    { 21,  -3},   /*   88 */
    {-15, -15},   /*   89 */
    { 13,  17},   /*   90 */
    { 17,  13},   /*   91 */
    {  5,  21},   /*   92 */
    { 21,   5},   /*   93 */
    {-19, -11},   /*   94 */
    {-11, -19},   /*   95 */
    { -7,  21},   /*   96 */
    { 21,  -7},   /*   97 */
    {-15,  17},   /*   98 */
    { 17, -15},   /*   99 */
    {  9,  21},   /*  100 */
    { 21,   9},   /*  101 */
    {-19,  13},   /*  102 */
    {-23,   1},   /*  103 */
    { 13, -19},   /*  104 */
    {  1, -23},   /*  105 */
    {-23,  -3},   /*  106 */
    { -3, -23},   /*  107 */
    {-23,   5},   /*  108 */
    {  5, -23},   /*  109 */
    {-11,  21},   /*  110 */
    { 21, -11},   /*  111 */
    { 17,  17},   /*  112 */
    {-23,  -7},   /*  113 */
    { -7, -23},   /*  114 */
    {-19, -15},   /*  115 */
    {-15, -19},   /*  116 */
    { 13,  21},   /*  117 */
    { 21,  13},   /*  118 */
    {-23,   9},   /*  119 */
    {  9, -23},   /*  120 */
    {  1,  25},   /*  121 */
    { 25,   1},   /*  122 */
    { -3,  25},   /*  123 */
    { 25,  -3},   /*  124 */
    {  5,  25},   /*  125 */
    {-19,  17},   /*  126 */
    { 25,   5},   /*  127 */
    {-23, -11},   /*  128 */
    { 17, -19},   /*  129 */
    {-11, -23},   /*  130 */
    {-15,  21},   /*  131 */
    { 21, -15},   /*  132 */
    { -7,  25},   /*  133 */
    { 25,  -7},   /*  134 */
    {-23,  13},   /*  135 */
    { 13, -23},   /*  136 */
    {  9,  25},   /*  137 */
    { 25,   9},   /*  138 */
    {-19, -19},   /*  139 */
    { 17,  21},   /*  140 */
    { 21,  17},   /*  141 */
    {-27,   1},   /*  142 */
    {  1, -27},   /*  143 */
    {-27,  -3},   /*  144 */
    { -3, -27},   /*  145 */
    {-11,  25},   /*  146 */
    { 25, -11},   /*  147 */
    {-27,   5},   /*  148 */
    {-23, -15},   /*  149 */
    {-15, -23},   /*  150 */
    {  5, -27},   /*  151 */
    {-27,  -7},   /*  152 */
    { -7, -27},   /*  153 */
    { 13,  25},   /*  154 */
    { 25,  13},   /*  155 */
    {-19,  21},   /*  156 */
    { 21, -19},   /*  157 */
    {-27,   9},   /*  158 */
    {  9, -27},   /*  159 */
    {-23,  17},   /*  160 */
    { 17, -23},   /*  161 */
    {  1,  29},   /*  162 */
    { 29,   1},   /*  163 */
    { -3,  29},   /*  164 */
    {-15,  25},   /*  165 */
    { 29,  -3},   /*  166 */
    {-27, -11},   /*  167 */
    { 25, -15},   /*  168 */
    {-11, -27},   /*  169 */
    {  5,  29},   /*  170 */
    { 29,   5},   /*  171 */
    { 21,  21},   /*  172 */
    { -7,  29},   /*  173 */
    { 29,  -7},   /*  174 */
    {-23, -19},   /*  175 */
    {-19, -23},   /*  176 */
    {-27,  13},   /*  177 */
    { 13, -27},   /*  178 */
    { 17,  25},   /*  179 */
    { 25,  17},   /*  180 */
    {  9,  29},   /*  181 */
    { 29,   9},   /*  182 */
    {-27, -15},   /*  183 */
    {-15, -27},   /*  184 */
    {-11,  29},   /*  185 */
    {-31,   1},   /*  186 */
    { 29, -11},   /*  187 */
    {  1, -31},   /*  188 */
    {-23,  21},   /*  189 */
    {-31,  -3},   /*  190 */
    { 21, -23},   /*  191 */
    { -3, -31},   /*  192 */
    {-19,  25},   /*  193 */
    {-31,   5},   /*  194 */
    { 25, -19},   /*  195 */
    {  5, -31},   /*  196 */
    { 13,  29},   /*  197 */
    { 29,  13},   /*  198 */
    {-31,  -7},   /*  199 */
    { -7, -31},   /*  200 */
    {-27,  17},   /*  201 */
    { 17, -27},   /*  202 */
    {-31,   9},   /*  203 */
    {  9, -31},   /*  204 */
    {-23, -23},   /*  205 */
    {-15,  29},   /*  206 */
    { 21,  25},   /*  207 */
    { 25,  21},   /*  208 */
    { 29, -15},   /*  209 */
    {-31, -11},   /*  210 */
    {-11, -31},   /*  211 */
    {  1,  33},   /*  212 */
    { 33,   1},   /*  213 */
    {-27, -19},   /*  214 */
    {-19, -27},   /*  215 */
    { -3,  33},   /*  216 */
    { 33,  -3},   /*  217 */
    {  5,  33},   /*  218 */
    { 33,   5},   /*  219 */
    { 17,  29},   /*  220 */
    { 29,  17},   /*  221 */
    {-31,  13},   /*  222 */
    { 13, -31},   /*  223 */
    { -7,  33},   /*  224 */
    { 33,  -7},   /*  225 */
    {-23,  25},   /*  226 */
    { 25, -23},   /*  227 */
    {  9,  33},   /*  228 */
    {-27,  21},   /*  229 */
    { 33,   9},   /*  230 */
    { 21, -27},   /*  231 */
    {-31, -15},   /*  232 */
    {-15, -31},   /*  233 */
    {-19,  29},   /*  234 */
    { 29, -19},   /*  235 */
    {-11,  33},   /*  236 */
    { 33, -11},   /*  237 */
    {-35,   1},   /*  238 */
    {  1, -35},   /*  239 */
    {-35,  -3},   /*  240 */
    { -3, -35},   /*  241 */
    { 25,  25},   /*  242 */
    {-31,  17},   /*  243 */
    {-35,   5},   /*  244 */
    { 17, -31},   /*  245 */
    {  5, -35},   /*  246 */
    { 13,  33},   /*  247 */
    { 33,  13},   /*  248 */
    {-27, -23},   /*  249 */
    {-23, -27},   /*  250 */
    {-35,  -7},   /*  251 */
    { -7, -35},   /*  252 */
    { 21,  29},   /*  253 */
    { 29,  21},   /*  254 */
    {-35,   9},   /*  255 */
    {  9, -35},   /*  256 */
    {-15,  33},   /*  257 */
    { 33, -15},   /*  258 */
    {-31, -19},   /*  259 */
    {-19, -31},   /*  260 */
    {-35, -11},   /*  261 */
    {-11, -35},   /*  262 */
    {-27,  25},   /*  263 */
    { 25, -27},   /*  264 */
    {  1,  37},   /*  265 */
    {-23,  29},   /*  266 */
    { 37,   1},   /*  267 */
    { 29, -23},   /*  268 */
    { -3,  37},   /*  269 */
    { 17,  33},   /*  270 */
    { 33,  17},   /*  271 */
    { 37,  -3},   /*  272 */
    {  5,  37},   /*  273 */
    {-35,  13},   /*  274 */
    { 37,   5},   /*  275 */
    { 13, -35},   /*  276 */
    {-31,  21},   /*  277 */
    { 21, -31},   /*  278 */
    { -7,  37},   /*  279 */
    { 37,  -7},   /*  280 */
    {  9,  37},   /*  281 */
    {-19,  33},   /*  282 */
    { 37,   9},   /*  283 */
    {-35, -15},   /*  284 */
    { 33, -19},   /*  285 */
    {-15, -35},   /*  286 */
    {-27, -27},   /*  287 */
    { 25,  29},   /*  288 */
    { 29,  25},   /*  289 */
    {-11,  37},   /*  290 */
    { 37, -11},   /*  291 */
    {-31, -23},   /*  292 */
    {-23, -31},   /*  293 */
    {-35,  17},   /*  294 */
    { 17, -35},   /*  295 */
    {-39,   1},   /*  296 */
    {  1, -39},   /*  297 */
    { 21,  33},   /*  298 */
    { 33,  21},   /*  299 */
    {-39,  -3},   /*  300 */
    { -3, -39},   /*  301 */
    { 13,  37},   /*  302 */
    { 37,  13},   /*  303 */
    {-39,   5},   /*  304 */
    {  5, -39},   /*  305 */
    {-27,  29},   /*  306 */
    {-39,  -7},   /*  307 */
    { 29, -27},   /*  308 */
    { -7, -39},   /*  309 */
    {-31,  25},   /*  310 */
    {-35, -19},   /*  311 */
    { 25, -31},   /*  312 */
    {-19, -35},   /*  313 */
    {-15,  37},   /*  314 */
    { 37, -15},   /*  315 */
    {-39,   9},   /*  316 */
    {  9, -39},   /*  317 */
    {-23,  33},   /*  318 */
    { 33, -23},   /*  319 */
    {-39, -11},   /*  320 */
    {-11, -39},   /*  321 */
    { 17,  37},   /*  322 */
    { 37,  17},   /*  323 */
    {-35,  21},   /*  324 */
    { 21, -35},   /*  325 */
    {  1,  41},   /*  326 */
    { 29,  29},   /*  327 */
    { 41,   1},   /*  328 */
    { -3,  41},   /*  329 */
    {-39,  13},   /*  330 */
    { 41,  -3},   /*  331 */
    {-31, -27},   /*  332 */
    {-27, -31},   /*  333 */
    { 13, -39},   /*  334 */
    {  5,  41},   /*  335 */
    { 41,   5},   /*  336 */
    { 25,  33},   /*  337 */
    { 33,  25},   /*  338 */
    { -7,  41},   /*  339 */
    {-19,  37},   /*  340 */
    { 41,  -7},   /*  341 */
    { 37, -19},   /*  342 */
    {-39, -15},   /*  343 */
    {-15, -39},   /*  344 */
    {-35, -23},   /*  345 */
    {-23, -35},   /*  346 */
    {  9,  41},   /*  347 */
    { 41,   9},   /*  348 */
    {-11,  41},   /*  349 */
    {-31,  29},   /*  350 */
    { 41, -11},   /*  351 */
    { 29, -31},   /*  352 */
    { 21,  37},   /*  353 */
    { 37,  21},   /*  354 */
    {-39,  17},   /*  355 */
    { 17, -39},   /*  356 */
    {-27,  33},   /*  357 */
    { 33, -27},   /*  358 */
    { 13,  41},   /*  359 */
    {-35,  25},   /*  360 */
    { 41,  13},   /*  361 */
    {-43,   1},   /*  362 */
    { 25, -35},   /*  363 */
    {  1, -43},   /*  364 */
    {-43,  -3},   /*  365 */
    { -3, -43},   /*  366 */
    {-43,   5},   /*  367 */
    {  5, -43},   /*  368 */
    {-39, -19},   /*  369 */
    {-19, -39},   /*  370 */
    {-23,  37},   /*  371 */
    {-43,  -7},   /*  372 */
    { 37, -23},   /*  373 */
    { -7, -43},   /*  374 */
    {-15,  41},   /*  375 */
    { 41, -15},   /*  376 */
    {-31, -31},   /*  377 */
    { 29,  33},   /*  378 */
    { 33,  29},   /*  379 */
    {-43,   9},   /*  380 */
    {  9, -43},   /*  381 */
    {-35, -27},   /*  382 */
    {-27, -35},   /*  383 */
    {-39,  21},   /*  384 */
    { 21, -39},   /*  385 */
    { 17,  41},   /*  386 */
    { 41,  17},   /*  387 */
    {-43, -11},   /*  388 */
    {-11, -43},   /*  389 */
    { 25,  37},   /*  390 */
    { 37,  25},   /*  391 */
    {-43,  13},   /*  392 */
    { 13, -43},   /*  393 */
    {  1,  45},   /*  394 */
    { 45,   1},   /*  395 */
    { -3,  45},   /*  396 */
    { 45,  -3},   /*  397 */
    {-19,  41},   /*  398 */
    { 41, -19},   /*  399 */
    {  5,  45},   /*  400 */
    {-31,  33},   /*  401 */
    { 45,   5},   /*  402 */
    {-39, -23},   /*  403 */
    { 33, -31},   /*  404 */
    {-23, -39},   /*  405 */
    {-35,  29},   /*  406 */
    { 29, -35},   /*  407 */
    { -7,  45},   /*  408 */
    { 45,  -7},   /*  409 */
    {-43, -15},   /*  410 */
    {-15, -43},   /*  411 */
    {-27,  37},   /*  412 */
    { 37, -27},   /*  413 */
    {  9,  45},   /*  414 */
    { 45,   9}    /*  415 */
};

static const int16_t v34_inverse_superconstellation[23][23] =
{
    {  0,  0,  0,  0,  0,  0,  0,411,389,374,366,364,368,381,393,  0,  0,  0,  0,  0,  0,  0,  0},
    {  0,  0,  0,  0,  0,405,370,344,321,309,301,297,305,317,334,356,385,  0,  0,  0,  0,  0,  0},
    {  0,  0,  0,  0,383,346,313,286,262,252,241,239,246,256,276,295,325,363,407,  0,  0,  0,  0},
    {  0,  0,  0,377,333,293,260,233,211,200,192,188,196,204,223,245,278,312,352,404,  0,  0,  0},
    {  0,  0,382,332,287,250,215,184,169,153,145,143,151,159,178,202,231,264,308,358,413,  0,  0},
    {  0,403,345,292,249,205,176,150,130,114,107,105,109,120,136,161,191,227,268,319,373,  0,  0},
    {  0,369,311,259,214,175,139,116, 95, 82, 74, 70, 76, 86,104,129,157,195,235,285,342,399,  0},
    {410,343,284,232,183,149,115, 89, 68, 53, 46, 44, 51, 61, 78, 99,132,168,209,258,315,376,  0},
    {388,320,261,210,167,128, 94, 67, 47, 34, 27, 23, 29, 40, 57, 81,111,147,187,237,291,351,  0},
    {372,307,251,199,152,113, 80, 52, 33, 19, 12, 10, 14, 26, 42, 66, 97,134,174,225,280,341,409},
    {365,300,240,190,144,106, 73, 45, 25, 11,  3,  2,  7, 18, 36, 59, 88,124,166,217,272,331,397},
    {362,296,238,186,142,103, 69, 43, 22,  9,  1,  0,  5, 16, 32, 56, 85,122,163,213,267,328,395},
    {367,304,244,194,148,108, 75, 50, 28, 13,  6,  4,  8, 21, 38, 63, 93,127,171,219,275,336,402},
    {380,316,255,203,158,119, 84, 60, 39, 24, 17, 15, 20, 30, 49, 72,101,138,182,230,283,348,415},
    {392,330,274,222,177,135,102, 77, 55, 41, 35, 31, 37, 48, 65, 91,118,155,198,248,303,361,  0},
    {  0,355,294,243,201,160,126, 98, 79, 64, 58, 54, 62, 71, 90,112,141,180,221,271,323,387,  0},
    {  0,384,324,277,229,189,156,131,110, 96, 87, 83, 92,100,117,140,172,208,254,299,354,  0,  0},
    {  0,  0,360,310,263,226,193,165,146,133,123,121,125,137,154,179,207,242,289,338,391,  0,  0},
    {  0,  0,406,350,306,266,234,206,185,173,164,162,170,181,197,220,253,288,327,379,  0,  0,  0},
    {  0,  0,  0,401,357,318,282,257,236,224,216,212,218,228,247,270,298,337,378,  0,  0,  0,  0},
    {  0,  0,  0,  0,412,371,340,314,290,279,269,265,273,281,302,322,353,390,  0,  0,  0,  0,  0},
    {  0,  0,  0,  0,  0,  0,398,375,349,339,329,326,335,347,359,386,  0,  0,  0,  0,  0,  0,  0},
    {  0,  0,  0,  0,  0,  0,  0,  0,  0,408,396,394,400,414,  0,  0,  0,  0,  0,  0,  0,  0,  0}
};

/*- End of file ------------------------------------------------------------*/
